/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.model.provisional;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IVirtualItemListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IVirtualItemValidator;
import org.eclipse.debug.internal.ui.viewers.model.provisional.VirtualItem;

public class VirtualTree
extends VirtualItem {
    private final boolean fLazy;
    private IVirtualItemValidator fValidator;
    private final Set<IVirtualItemListener> fVirtualItemListeners = new HashSet<IVirtualItemListener>(1);
    private VirtualItem[] fSelection = new VirtualItem[0];

    public VirtualTree(int style, IVirtualItemValidator validator) {
        super(null, new VirtualItem.Index(0));
        this.fLazy = (style & 0x10000000) != 0;
        this.fValidator = this.fLazy && validator == null ? new SelectedItemValidator() : validator;
        this.clearNeedsLabelUpdate();
        this.clearNeedsDataUpdate();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.fVirtualItemListeners.clear();
    }

    @Override
    public void setNeedsCountUpdate() {
        super.setNeedsCountUpdate();
        this.clearNeedsLabelUpdate();
        this.clearNeedsDataUpdate();
    }

    @Override
    public void setNeedsLabelUpdate() {
    }

    @Override
    public void setData(String key, Object data) {
        super.setData(key, data);
        if (data == null) {
            this.clearNeedsDataUpdate();
        }
    }

    public void addItemListener(IVirtualItemListener listener) {
        this.fVirtualItemListeners.add(listener);
    }

    public void removeItemListener(IVirtualItemListener listener) {
        this.fVirtualItemListeners.remove(listener);
    }

    public VirtualItem[] getSelection() {
        return this.fSelection;
    }

    public void setSelection(VirtualItem[] items) {
        this.fSelection = items;
    }

    public void showItem(VirtualItem item) {
        if (this.fValidator != null) {
            this.fValidator.showItem(item);
        }
    }

    public void fireItemDisposed(VirtualItem item) {
        for (IVirtualItemListener listener : this.fVirtualItemListeners) {
            listener.disposed(item);
        }
    }

    public void fireItemRevealed(VirtualItem item) {
        for (IVirtualItemListener listener : this.fVirtualItemListeners) {
            listener.revealed(item);
        }
    }

    @Override
    public void setData(Object data) {
        super.setData(data);
        this.setHasItems(data != null);
    }

    @Override
    public void setHasItems(boolean hasChildren) {
        super.setHasItems(hasChildren);
        if (hasChildren) {
            this.setExpanded(true);
        }
    }

    public boolean isItemVisible(VirtualItem item) {
        if (this.fLazy) {
            return this.fValidator.isItemVisible(item);
        }
        return true;
    }

    public void validate() {
        this.validate(this);
    }

    public void validate(VirtualItem item) {
        if (item.needsDataUpdate()) {
            if (this.isItemVisible(item)) {
                this.fireItemRevealed(item);
            }
        } else if (item.getData() != null) {
            if ((item.needsLabelUpdate() || item.needsCountUpdate() && item.hasItems() && item.getExpanded()) && this.isItemVisible(item)) {
                this.fireItemRevealed(item);
            }
            if (item.getData() != null && item.getItemCount() > 0 && item.getExpanded()) {
                int i = 0;
                while (i < item.getItemCount()) {
                    this.validate(item.getItem(new VirtualItem.Index(i)));
                    ++i;
                }
            }
        }
    }

    private class SelectedItemValidator
    implements IVirtualItemValidator {
        private SelectedItemValidator() {
        }

        @Override
        public boolean isItemVisible(VirtualItem item) {
            VirtualItem[] virtualItemArray = VirtualTree.this.fSelection;
            int n = VirtualTree.this.fSelection.length;
            int n2 = 0;
            while (n2 < n) {
                VirtualItem selectionItem = virtualItemArray[n2];
                while (selectionItem != null) {
                    if (item.equals(selectionItem)) {
                        return true;
                    }
                    selectionItem = selectionItem.getParent();
                }
                ++n2;
            }
            return false;
        }

        @Override
        public void showItem(VirtualItem item) {
        }
    }
}

