/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.graph.core.criticalpath;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.tracecompass.analysis.graph.core.criticalpath.ICriticalPathAlgorithm;
import org.eclipse.tracecompass.internal.analysis.graph.core.criticalpath.CriticalPathAlgorithmBounded;

public final class AlgorithmManager {
    private static final AlgorithmManager INSTANCE = new AlgorithmManager();
    private final Map<String, Class<? extends ICriticalPathAlgorithm>> fMap = new HashMap<String, Class<? extends ICriticalPathAlgorithm>>();
    private final Map<String, Class<? extends ICriticalPathAlgorithm>> fPublicMap = Collections.unmodifiableMap(this.fMap);

    static {
        INSTANCE.register(CriticalPathAlgorithmBounded.class);
    }

    private AlgorithmManager() {
    }

    public static AlgorithmManager getInstance() {
        return INSTANCE;
    }

    public void register(Class<? extends ICriticalPathAlgorithm> type) {
        this.fMap.put(type.getSimpleName(), type);
    }

    public Map<String, Class<? extends ICriticalPathAlgorithm>> registeredTypes() {
        return this.fPublicMap;
    }
}

