/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.provider.IIndexProvider;
import org.eclipse.cdt.core.index.provider.IReadOnlyPDOMProvider;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.index.provider.IIndexFragmentProvider;
import org.eclipse.cdt.internal.core.index.provider.Messages;
import org.eclipse.cdt.internal.core.index.provider.ReadOnlyPDOMProviderBridge;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;

public final class IndexProviderManager
implements IElementChangedListener {
    private static final String ELEMENT_RO_PDOM_PROVIDER = "ReadOnlyPDOMProvider";
    private static final String ELEMENT_RO_INDEX_FRAGMENT_PROVIDER = "ReadOnlyIndexFragmentProvider";
    private static final String ELEMENT_PROVIDER_USAGE = "FragmentProviderUsage";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String ATTRIBUTE_NAVIGATION = "navigation";
    private static final String ATTRIBUTE_CONTENT_ASSIST = "content_assist";
    private static final String ATTRIBUTE_ADD_IMPORT = "add_import";
    private static final String ATTRIBUTE_CALL_HIERARCHY = "call_hierarchy";
    private static final String ATTRIBUTE_TYPE_HIERARCHY = "type_hierarchy";
    private static final String ATTRIBUTE_INCLUDE_BROWSER = "include_browser";
    private static final String ATTRIBUTE_SEARCH = "search";
    private static final String ATTRIBUTE_EDITOR = "editor";
    private IIndexFragmentProvider[] fragmentProviders;
    private int[] fragmentProviderUsage;
    private Map<ProvisionMapKey, Boolean> provisionMap;
    private Set<String> compatibleFragmentUnavailable;
    private VersionRange pdomVersionRange;

    public IndexProviderManager() {
        this.reset();
    }

    public void reset() {
        Version minVersion = Version.parseVersion((String)PDOM.versionString(PDOM.getMinSupportedVersion()));
        Version maxVersion = Version.parseVersion((String)PDOM.versionString(PDOM.getMaxSupportedVersion()));
        this.reset(new VersionRange(minVersion, true, maxVersion, true));
    }

    public void reset(VersionRange pdomVersionRange) {
        this.fragmentProviders = new IIndexFragmentProvider[0];
        this.provisionMap = new HashMap<ProvisionMapKey, Boolean>();
        this.pdomVersionRange = pdomVersionRange;
        this.compatibleFragmentUnavailable = new HashSet<String>();
    }

    public void startup() {
        ArrayList<IIndexFragmentProvider> providers = new ArrayList<IIndexFragmentProvider>();
        ArrayList<IConfigurationElement[]> usageSpecifications = new ArrayList<IConfigurationElement[]>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint indexProviders = registry.getExtensionPoint("org.eclipse.cdt.core.CIndex");
        IExtension[] iExtensionArray = indexProviders.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            try {
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (ELEMENT_RO_PDOM_PROVIDER.equals(element.getName())) {
                        provider = element.createExecutableExtension(ATTRIBUTE_CLASS);
                        if (provider instanceof IReadOnlyPDOMProvider) {
                            providers.add(new ReadOnlyPDOMProviderBridge((IReadOnlyPDOMProvider)provider));
                            usageSpecifications.add(element.getChildren(ELEMENT_PROVIDER_USAGE));
                        } else {
                            CCorePlugin.log(NLS.bind((String)Messages.IndexProviderManager_InvalidIndexProvider, (Object)extension.getContributor().getName()));
                        }
                    } else if (ELEMENT_RO_INDEX_FRAGMENT_PROVIDER.equals(element.getName())) {
                        provider = element.createExecutableExtension(ATTRIBUTE_CLASS);
                        if (provider instanceof IIndexFragmentProvider) {
                            providers.add((IIndexFragmentProvider)provider);
                            usageSpecifications.add(element.getChildren(ELEMENT_PROVIDER_USAGE));
                        } else {
                            CCorePlugin.log(NLS.bind((String)Messages.IndexProviderManager_InvalidIndexProvider, (Object)extension.getContributor().getName()));
                        }
                    }
                    ++n4;
                }
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
            ++n2;
        }
        CoreModel.getDefault().addElementChangedListener(this);
        this.fragmentProviders = providers.toArray(new IIndexFragmentProvider[providers.size()]);
        this.fragmentProviderUsage = this.computeProviderUsage(usageSpecifications);
        assert (this.fragmentProviders.length == this.fragmentProviderUsage.length);
    }

    private int[] computeProviderUsage(List<IConfigurationElement[]> usageFilters) {
        int[] usage = new int[usageFilters.size()];
        int i = 0;
        while (i < usage.length) {
            IConfigurationElement[] usageFilter = usageFilters.get(i);
            usage[i] = this.computeProviderUsage(usageFilter);
            ++i;
        }
        return usage;
    }

    private int computeProviderUsage(IConfigurationElement[] usageFilter) {
        if (usageFilter == null || usageFilter.length == 0) {
            return -1;
        }
        int result = 0;
        IConfigurationElement elem = usageFilter[0];
        result |= this.getOption(elem, ATTRIBUTE_ADD_IMPORT, 32);
        result |= this.getOption(elem, ATTRIBUTE_CALL_HIERARCHY, 64);
        result |= this.getOption(elem, ATTRIBUTE_CONTENT_ASSIST, 16);
        result |= this.getOption(elem, ATTRIBUTE_INCLUDE_BROWSER, 256);
        result |= this.getOption(elem, ATTRIBUTE_NAVIGATION, 8);
        result |= this.getOption(elem, ATTRIBUTE_SEARCH, 512);
        result |= this.getOption(elem, ATTRIBUTE_TYPE_HIERARCHY, 128);
        return result |= this.getOption(elem, ATTRIBUTE_EDITOR, 1024);
    }

    public int getOption(IConfigurationElement elem, String attributeName, int option) {
        if (Boolean.parseBoolean(elem.getAttribute(attributeName))) {
            return option;
        }
        return 0;
    }

    public IIndexFragment[] getProvidedIndexFragments(ICConfigurationDescription config, int usage) throws CoreException {
        HashMap<String, IIndexFragment> id2fragment = new HashMap<String, IIndexFragment>();
        IProject project = config.getProjectDescription().getProject();
        int i = 0;
        while (i < this.fragmentProviders.length) {
            block10: {
                if ((this.fragmentProviderUsage[i] & usage) != 0) {
                    IIndexFragmentProvider provider = this.fragmentProviders[i];
                    try {
                        IIndexFragment[] fragments;
                        if (!this.providesForProject(provider, project)) break block10;
                        IIndexFragment[] iIndexFragmentArray = fragments = provider.getIndexFragments(config);
                        int n = fragments.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IIndexFragment fragment = iIndexFragmentArray[n2];
                            try {
                                this.processCandidate(id2fragment, fragment);
                            }
                            catch (InterruptedException e) {
                                CCorePlugin.log(e);
                            }
                            catch (CoreException e) {
                                CCorePlugin.log(e);
                            }
                            ++n2;
                        }
                    }
                    catch (CoreException e) {
                        CCorePlugin.log(e);
                    }
                }
            }
            ++i;
        }
        ArrayList<IIndexFragment> preresult = new ArrayList<IIndexFragment>();
        for (Map.Entry entry : id2fragment.entrySet()) {
            if (entry.getValue() == null) {
                String key = (String)entry.getKey();
                if (this.compatibleFragmentUnavailable.contains(key)) continue;
                String msg = NLS.bind((String)Messages.IndexProviderManager_NoCompatibleFragmentsAvailable, (Object)key, (Object)this.collectVersions(config, project, usage, key));
                CCorePlugin.log((IStatus)new Status(2, "org.eclipse.cdt.core", msg));
                this.compatibleFragmentUnavailable.add(key);
                continue;
            }
            preresult.add((IIndexFragment)entry.getValue());
        }
        return preresult.toArray(new IIndexFragment[preresult.size()]);
    }

    private String collectVersions(ICConfigurationDescription config, IProject project, int usage, String fragid) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < this.fragmentProviders.length) {
            block12: {
                if ((this.fragmentProviderUsage[i] & usage) != 0) {
                    IIndexFragmentProvider provider = this.fragmentProviders[i];
                    try {
                        IIndexFragment[] fragments;
                        if (!this.providesForProject(provider, project)) break block12;
                        IIndexFragment[] iIndexFragmentArray = fragments = provider.getIndexFragments(config);
                        int n = fragments.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IIndexFragment fragment = iIndexFragmentArray[n2];
                            try {
                                fragment.acquireReadLock();
                                try {
                                    String csver;
                                    if (fragid.equals(fragment.getProperty("org.eclipse.cdt.internal.core.index.fragment.id")) && (csver = fragment.getProperty("org.eclipse.cdt.internal.core.index.fragment.format.version")) != null) {
                                        if (result.length() > 0) {
                                            result.append(", ");
                                        }
                                        result.append(csver);
                                    }
                                }
                                finally {
                                    fragment.releaseReadLock();
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            ++n2;
                        }
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
            }
            ++i;
        }
        return result.toString();
    }

    private VersionRange getCurrentlySupportedVersionRangeForFormat(String formatID) {
        if ("org.eclipse.cdt.internal.core.pdom.PDOM".equals(formatID)) {
            return this.pdomVersionRange;
        }
        return null;
    }

    private void processCandidate(Map<String, IIndexFragment> id2fragment, IIndexFragment candidate) throws InterruptedException, CoreException {
        String cid = null;
        String csver = null;
        String cformatID = null;
        candidate.acquireReadLock();
        try {
            cid = candidate.getProperty("org.eclipse.cdt.internal.core.index.fragment.id");
            csver = candidate.getProperty("org.eclipse.cdt.internal.core.index.fragment.format.version");
            cformatID = candidate.getProperty("org.eclipse.cdt.internal.core.index.fragment.format.id");
        }
        finally {
            candidate.releaseReadLock();
        }
        assert (cid != null && csver != null && cformatID != null);
        Version cver = Version.parseVersion((String)csver);
        IIndexFragment existing = id2fragment.get(cid);
        VersionRange versionRange = this.getCurrentlySupportedVersionRangeForFormat(cformatID);
        if (versionRange == null || versionRange.isIncluded(cver)) {
            if (existing != null) {
                Version ever;
                String esver = null;
                String eformatID = null;
                existing.acquireReadLock();
                try {
                    esver = existing.getProperty("org.eclipse.cdt.internal.core.index.fragment.format.version");
                    eformatID = existing.getProperty("org.eclipse.cdt.internal.core.index.fragment.format.id");
                }
                finally {
                    existing.releaseReadLock();
                }
                if (eformatID.equals(cformatID) && (ever = Version.parseVersion((String)esver)).compareTo(cver) < 0) {
                    id2fragment.put(cid, candidate);
                }
            } else {
                id2fragment.put(cid, candidate);
            }
        } else if (existing == null) {
            id2fragment.put(cid, null);
        }
    }

    public void addIndexProvider(IIndexProvider provider) {
        if (!(provider instanceof IIndexFragmentProvider)) {
            CCorePlugin.log("An unknown index provider implementation was plugged in to the CIndex extension point");
            return;
        }
        int length = this.fragmentProviders.length;
        IIndexFragmentProvider[] newProviders = new IIndexFragmentProvider[length + 1];
        System.arraycopy(this.fragmentProviders, 0, newProviders, 0, length);
        newProviders[length] = (IIndexFragmentProvider)provider;
        this.fragmentProviders = newProviders;
        int[] newFilters = new int[length + 1];
        System.arraycopy(this.fragmentProviderUsage, 0, newFilters, 0, length);
        newFilters[length] = -1;
        this.fragmentProviderUsage = newFilters;
    }

    public void removeIndexProvider(IIndexProvider provider) {
        int i = 0;
        while (i < this.fragmentProviders.length) {
            if (this.fragmentProviders[i] == provider) {
                int length = this.fragmentProviders.length;
                IIndexFragmentProvider[] newProviders = new IIndexFragmentProvider[length - 1];
                System.arraycopy(this.fragmentProviders, 0, newProviders, 0, i);
                System.arraycopy(this.fragmentProviders, i + 1, newProviders, i, length - i - 1);
                this.fragmentProviders = newProviders;
                int[] newFilters = new int[length - 1];
                System.arraycopy(this.fragmentProviderUsage, 0, newFilters, 0, i);
                System.arraycopy(this.fragmentProviderUsage, i + 1, newFilters, i, length - i - 1);
                this.fragmentProviderUsage = newFilters;
                return;
            }
            ++i;
        }
    }

    private boolean providesForProject(IIndexProvider provider, IProject project) {
        ProvisionMapKey key = new ProvisionMapKey(provider, project);
        if (!this.provisionMap.containsKey(key)) {
            try {
                ICProject cproject = CoreModel.getDefault().create(project);
                this.provisionMap.put(key, provider.providesFor(cproject));
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
                this.provisionMap.put(key, Boolean.FALSE);
            }
        }
        return this.provisionMap.get(key);
    }

    @Override
    public void elementChanged(ElementChangedEvent event) {
        try {
            if (event.getType() == 1) {
                this.processDelta(event.getDelta());
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
    }

    private void processDelta(ICElementDelta delta) throws CoreException {
        int type = delta.getElement().getElementType();
        switch (type) {
            case 10: {
                ICElementDelta[] children = delta.getAffectedChildren();
                int i = 0;
                while (i < children.length) {
                    this.processDelta(children[i]);
                    ++i;
                }
                break;
            }
            case 11: {
                ICProject cproject = (ICProject)delta.getElement();
                switch (delta.getKind()) {
                    case 2: {
                        ArrayList<ProvisionMapKey> toRemove = new ArrayList<ProvisionMapKey>();
                        for (ProvisionMapKey key : this.provisionMap.keySet()) {
                            if (!key.getProject().equals((Object)cproject.getProject())) continue;
                            toRemove.add(key);
                        }
                        for (ProvisionMapKey key : toRemove) {
                            this.provisionMap.remove(key);
                        }
                    }
                }
            }
        }
    }

    private static class ProvisionMapKey {
        private final IIndexProvider provider;
        private final IProject project;

        ProvisionMapKey(IIndexProvider provider, IProject project) {
            this.provider = provider;
            this.project = project;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ProvisionMapKey) {
                ProvisionMapKey other = (ProvisionMapKey)obj;
                return other.project.equals((Object)this.project) && other.provider.equals(this.provider);
            }
            return false;
        }

        public int hashCode() {
            return this.project.hashCode() ^ this.provider.hashCode();
        }

        public IProject getProject() {
            return this.project;
        }
    }
}

