/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.index;

import java.net.URI;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexLocationConverter;
import org.eclipse.cdt.internal.core.index.IndexFileLocation;
import org.eclipse.core.filesystem.URIUtil;

public class URIRelativeLocationConverter
implements IIndexLocationConverter {
    private URI baseURI;

    public URIRelativeLocationConverter(URI baseURI) {
        this.baseURI = baseURI;
    }

    @Override
    public IIndexFileLocation fromInternalFormat(String raw) {
        String rawPath = URIUtil.toURI((String)raw).getRawPath();
        if (rawPath.length() > 0 && rawPath.charAt(0) == '/') {
            rawPath = rawPath.substring(1);
        }
        URI uri = this.baseURI.resolve(rawPath);
        return new IndexFileLocation(uri, null);
    }

    @Override
    public String toInternalFormat(IIndexFileLocation location) {
        URI relative = this.baseURI.relativize(location.getURI());
        return relative.isAbsolute() ? null : relative.getPath();
    }
}

