/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.ast;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.parser.IToken;

public class ASTCompletionNode
implements IASTCompletionNode {
    private final IToken completionToken;
    private final List<IASTCompletionNode.CompletionNameEntry> entries = new ArrayList<IASTCompletionNode.CompletionNameEntry>();
    private final IASTTranslationUnit translationUnit;

    public ASTCompletionNode(IToken completionToken, IASTTranslationUnit translationUnit) {
        this.completionToken = completionToken;
        this.translationUnit = translationUnit;
    }

    public void addName(IASTName name) {
        this.entries.add(new IASTCompletionNode.CompletionNameEntry(name, name.getParent()));
    }

    @Override
    public String getPrefix() {
        return this.completionToken.getType() == 141 ? "" : this.completionToken.getImage();
    }

    @Override
    public int getLength() {
        return this.completionToken.getLength();
    }

    @Override
    public boolean containsName(IASTName name) {
        for (IASTCompletionNode.CompletionNameEntry entry : this.entries) {
            if (entry.fName != name) continue;
            return true;
        }
        return false;
    }

    @Override
    public IASTName[] getNames() {
        IASTName[] names = new IASTName[this.entries.size()];
        int i = 0;
        while (i < this.entries.size()) {
            names[i] = this.entries.get((int)i).fName;
            ++i;
        }
        return names;
    }

    @Override
    public IASTCompletionNode.CompletionNameEntry[] getEntries() {
        return this.entries.toArray(new IASTCompletionNode.CompletionNameEntry[this.entries.size()]);
    }

    @Override
    public IASTTranslationUnit getTranslationUnit() {
        return this.translationUnit;
    }
}

