/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.AnalysisCompilationData;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.IDataDrivenCompilationUnit;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlActionCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlConditionCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlFsmStateCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlStateValueCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenAction;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenActionResetStoredFields;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenActionUpdateStoredFields;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenFsmStateTransition;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValue;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValueEventName;
import org.w3c.dom.Element;

public class TmfXmlFsmStateTransitionCu
implements IDataDrivenCompilationUnit {
    private static final TmfXmlStateValueCu EVENT_NAME_VALUE = new TmfXmlStateValueCu(() -> new DataDrivenValueEventName(null)){
        private @Nullable DataDrivenValue fValue = null;

        @Override
        public DataDrivenValue generate() {
            DataDrivenValue value = this.fValue;
            if (value == null) {
                this.fValue = value = super.generate();
            }
            return value;
        }
    };
    private static final Pattern WILDCARD_PATTERN = Pattern.compile("\\*");
    private static final Pattern ALL_ACCEPT_PATTERN = Pattern.compile(".*");
    private final TmfXmlConditionCu fEvents;
    private final TmfXmlConditionCu fConditions;
    private final TmfXmlFsmStateCu fTarget;
    private final List<TmfXmlActionCu> fActions;
    private final boolean fSaveFields;
    private final boolean fClearFields;

    private TmfXmlFsmStateTransitionCu(TmfXmlConditionCu eventCond, TmfXmlConditionCu conditions, TmfXmlFsmStateCu target, List<TmfXmlActionCu> actions, boolean saveFields, boolean clearFields) {
        this.fEvents = eventCond;
        this.fConditions = conditions;
        this.fTarget = target;
        this.fActions = actions;
        this.fSaveFields = saveFields;
        this.fClearFields = clearFields;
    }

    @Override
    public DataDrivenFsmStateTransition generate() {
        List<DataDrivenAction> actions = this.fActions.stream().map(TmfXmlActionCu::generate).collect(Collectors.toList());
        if (this.fSaveFields) {
            actions.add(DataDrivenActionUpdateStoredFields.getInstance());
        }
        if (this.fClearFields) {
            actions.add(DataDrivenActionResetStoredFields.getInstance());
        }
        return new DataDrivenFsmStateTransition(this.fEvents.generate(), this.fConditions.generate(), this.fTarget.getId(), actions);
    }

    public static @Nullable TmfXmlFsmStateTransitionCu compile(AnalysisCompilationData analysisData, Element element, Map<String, TmfXmlFsmStateCu.TmfXmlFsmSimpleStateCu> states) {
        TmfXmlConditionCu eventCond = TmfXmlFsmStateTransitionCu.compileEventsCondition(element);
        TmfXmlConditionCu conditions = TmfXmlFsmStateTransitionCu.compileConditions(analysisData, element);
        if (conditions == null) {
            return null;
        }
        String targetStr = element.getAttribute("target");
        if (targetStr.isEmpty()) {
            Activator.logError("State Transition: No target defined");
            return null;
        }
        TmfXmlFsmStateCu target = states.get(targetStr);
        if (target == null) {
            Activator.logError("State Transition: Undefined target state: " + targetStr);
            return null;
        }
        String actionsStr = element.getAttribute("action");
        ArrayList<TmfXmlActionCu> actions = new ArrayList<TmfXmlActionCu>();
        if (!actionsStr.isEmpty()) {
            String[] stringArray = actionsStr.split(":");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String action = stringArray[n2];
                TmfXmlActionCu actionCu = analysisData.getAction(action);
                if (actionCu == null) {
                    Activator.logError("State Transition: Undefined action: " + action);
                    return null;
                }
                actions.add(actionCu);
                ++n2;
            }
        }
        String saveSfStr = element.getAttribute("saveStoredFields");
        boolean saveFields = false;
        if (!saveSfStr.isEmpty()) {
            saveFields = Boolean.parseBoolean(saveSfStr);
        }
        String clearSfStr = element.getAttribute("clearStoredFields");
        boolean clearFields = false;
        if (!clearSfStr.isEmpty()) {
            clearFields = Boolean.parseBoolean(clearSfStr);
        }
        return new TmfXmlFsmStateTransitionCu(eventCond, conditions, target, actions, saveFields, clearFields);
    }

    public static @Nullable TmfXmlConditionCu compileAsCondition(AnalysisCompilationData analysisData, Element element) {
        TmfXmlConditionCu event = TmfXmlFsmStateTransitionCu.compileEventsCondition(element);
        TmfXmlConditionCu conditions = TmfXmlFsmStateTransitionCu.compileConditions(analysisData, element);
        if (conditions == null) {
            return null;
        }
        String targetStr = element.getAttribute("target");
        String actionsStr = element.getAttribute("action");
        String saveSfStr = element.getAttribute("saveStoredFields");
        String clearSfStr = element.getAttribute("clearStoredFields");
        if (!(targetStr.isEmpty() && actionsStr.isEmpty() && saveSfStr.isEmpty() && clearSfStr.isEmpty())) {
            Activator.logWarning("State Transition: Transition used a condition, there should be only 'events' and 'cond' attributes");
        }
        return TmfXmlConditionCu.createAndCondition((List<TmfXmlConditionCu>)ImmutableList.of((Object)event, (Object)conditions));
    }

    private static @Nullable TmfXmlConditionCu compileConditions(AnalysisCompilationData analysisData, Element element) {
        String testsStr = element.getAttribute("cond");
        ArrayList<TmfXmlConditionCu> conditions = new ArrayList<TmfXmlConditionCu>();
        if (!testsStr.isEmpty()) {
            String[] stringArray = testsStr.split(":");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String condition = stringArray[n2];
                TmfXmlConditionCu test = analysisData.getTest(condition);
                if (test == null) {
                    Activator.logError("State Transition: Undefined condition: " + condition);
                    return null;
                }
                conditions.add(test);
                ++n2;
            }
        }
        return TmfXmlConditionCu.createAndCondition(conditions);
    }

    private static TmfXmlConditionCu compileEventsCondition(Element element) {
        String eventsStr = element.getAttribute("event");
        ArrayList<Pattern> events = new ArrayList<Pattern>();
        if (!eventsStr.isEmpty()) {
            String[] stringArray = eventsStr.split("\\|");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String eventName = stringArray[n2];
                String name = WILDCARD_PATTERN.matcher(eventName).replaceAll(".*");
                events.add(Pattern.compile(name));
                ++n2;
            }
        } else {
            events.add(ALL_ACCEPT_PATTERN);
        }
        ArrayList<TmfXmlConditionCu> eventConditions = new ArrayList<TmfXmlConditionCu>();
        for (Pattern pattern : events) {
            eventConditions.add(new TmfXmlConditionCu.TmfXmlRegexConditionCu(pattern, EVENT_NAME_VALUE));
        }
        return TmfXmlConditionCu.createOrCondition(eventConditions);
    }

    public static @Nullable TmfXmlFsmStateCu compileInitialTransition(AnalysisCompilationData analysisData, Element element, Map<String, TmfXmlFsmStateCu.TmfXmlFsmSimpleStateCu> states) {
        String targetStr;
        String eventsStr = element.getAttribute("event");
        String condStr = element.getAttribute("cond");
        String actionsStr = element.getAttribute("action");
        String saveSfStr = element.getAttribute("saveStoredFields");
        String clearSfStr = element.getAttribute("clearStoredFields");
        if (!(eventsStr.isEmpty() && condStr.isEmpty() && actionsStr.isEmpty() && saveSfStr.isEmpty() && clearSfStr.isEmpty())) {
            Activator.logWarning("Initial Transition: Initial transition needs the 'target' attribute to point to the real initial state. All other attributes will be ignored. If this state is meant to be the real initial state, use the 'initialState' element instead.");
        }
        if ((targetStr = element.getAttribute("target")).isEmpty()) {
            Activator.logError("Initial Transition: No target defined");
            return null;
        }
        TmfXmlFsmStateCu target = states.get(targetStr);
        if (target == null) {
            Activator.logError("Initial Transition: Undefined target state: " + targetStr);
            return null;
        }
        return target;
    }
}

