/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.uml2sd.handlers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.SDView;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.handlers.MoveSDDown;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.handlers.MoveSDLeft;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.handlers.MoveSDRight;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.handlers.MoveSDUp;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.handlers.MoveToMessage;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.handlers.OpenSDFindDialog;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.handlers.ShowNodeEnd;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.handlers.ShowNodeStart;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.util.Messages;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;

public class KeyBindingsManager {
    private static KeyBindingsManager fInstance = null;
    private Set<String> fViews = new HashSet<String>();
    private List<IHandlerActivation> fHandlerActivations = new ArrayList<IHandlerActivation>();
    private MoveToMessage fGoToMessageForKeyBinding;
    private OpenSDFindDialog fFindForKeyBinding;
    private MoveSDUp fMoveUpForKeyBinding;
    private MoveSDDown fMoveDownForKeyBinding;
    private MoveSDLeft fMoveLeftForKeyBinding;
    private MoveSDRight fMoveRightForKeyBinding;
    private ShowNodeStart fShowNodeStartForKeyBinding;
    private ShowNodeEnd fShowNodeEndForKeyBinding;

    protected KeyBindingsManager() {
    }

    public static synchronized KeyBindingsManager getInstance() {
        if (fInstance == null) {
            fInstance = new KeyBindingsManager();
        }
        return fInstance;
    }

    public void add(String viewId) {
        if (this.fViews.isEmpty()) {
            this.initialize();
        }
        if (!this.fViews.contains(viewId)) {
            this.fViews.add(viewId);
        }
    }

    public void remove(String viewId) {
        if (this.fViews.contains(viewId)) {
            this.fViews.remove(viewId);
        }
        if (this.fViews.isEmpty()) {
            this.dispose();
        }
    }

    private void initialize() {
        this.fGoToMessageForKeyBinding = new MoveToMessage();
        Object serviceObject = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(IHandlerService.class);
        IHandlerService service = (IHandlerService)serviceObject;
        AbstractHandler handler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                KeyBindingsManager.this.fGoToMessageForKeyBinding.run();
                return null;
            }
        };
        IHandlerActivation activation = service.activateHandler(this.fGoToMessageForKeyBinding.getActionDefinitionId(), (IHandler)handler);
        this.fHandlerActivations.add(activation);
        this.fMoveUpForKeyBinding = new MoveSDUp();
        handler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                KeyBindingsManager.this.fMoveUpForKeyBinding.run();
                return null;
            }
        };
        activation = service.activateHandler(this.fMoveUpForKeyBinding.getActionDefinitionId(), (IHandler)handler);
        this.fHandlerActivations.add(activation);
        this.fMoveDownForKeyBinding = new MoveSDDown();
        handler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                KeyBindingsManager.this.fMoveDownForKeyBinding.run();
                return null;
            }
        };
        activation = service.activateHandler(this.fMoveDownForKeyBinding.getActionDefinitionId(), (IHandler)handler);
        this.fHandlerActivations.add(activation);
        this.fMoveLeftForKeyBinding = new MoveSDLeft();
        handler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                KeyBindingsManager.this.fMoveLeftForKeyBinding.run();
                return null;
            }
        };
        activation = service.activateHandler(this.fMoveLeftForKeyBinding.getActionDefinitionId(), (IHandler)handler);
        this.fHandlerActivations.add(activation);
        this.fMoveRightForKeyBinding = new MoveSDRight();
        handler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                KeyBindingsManager.this.fMoveRightForKeyBinding.run();
                return null;
            }
        };
        activation = service.activateHandler(this.fMoveRightForKeyBinding.getActionDefinitionId(), (IHandler)handler);
        this.fHandlerActivations.add(activation);
        this.fFindForKeyBinding = new OpenSDFindDialog();
        handler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                KeyBindingsManager.this.fFindForKeyBinding.run();
                return null;
            }
        };
        activation = service.activateHandler(this.fFindForKeyBinding.getActionDefinitionId(), (IHandler)handler);
        this.fFindForKeyBinding.setEnabled(false);
        this.fHandlerActivations.add(activation);
        this.fShowNodeStartForKeyBinding = new ShowNodeStart();
        this.fShowNodeStartForKeyBinding.setText(Messages.SequenceDiagram_ShowNodeStart);
        this.fShowNodeStartForKeyBinding.setId("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.ShowNodeStart");
        this.fShowNodeStartForKeyBinding.setActionDefinitionId("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.ShowNodeStart");
        handler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                KeyBindingsManager.this.fShowNodeStartForKeyBinding.run();
                return null;
            }
        };
        activation = service.activateHandler(this.fShowNodeStartForKeyBinding.getActionDefinitionId(), (IHandler)handler);
        this.fHandlerActivations.add(activation);
        this.fShowNodeEndForKeyBinding = new ShowNodeEnd();
        this.fShowNodeEndForKeyBinding.setText(Messages.SequenceDiagram_ShowNodeEnd);
        this.fShowNodeEndForKeyBinding.setId("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.ShowNodeEnd");
        this.fShowNodeEndForKeyBinding.setActionDefinitionId("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.ShowNodeEnd");
        handler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                KeyBindingsManager.this.fShowNodeEndForKeyBinding.run();
                return null;
            }
        };
        activation = service.activateHandler(this.fShowNodeEndForKeyBinding.getActionDefinitionId(), (IHandler)handler);
        this.fHandlerActivations.add(activation);
    }

    private void dispose() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        Object serviceObject = window.getService(IHandlerService.class);
        IHandlerService service = (IHandlerService)serviceObject;
        for (IHandlerActivation activation : this.fHandlerActivations) {
            service.deactivateHandler(activation);
        }
        this.fHandlerActivations.clear();
        this.fGoToMessageForKeyBinding = null;
        this.fFindForKeyBinding = null;
        this.fMoveUpForKeyBinding = null;
        this.fMoveDownForKeyBinding = null;
        this.fMoveLeftForKeyBinding = null;
        this.fMoveRightForKeyBinding = null;
        this.fShowNodeStartForKeyBinding = null;
        this.fShowNodeEndForKeyBinding = null;
    }

    public void setSdView(SDView view) {
        if (!this.fViews.isEmpty()) {
            this.fGoToMessageForKeyBinding.setView(view);
            this.fFindForKeyBinding.setView(view);
            this.fMoveUpForKeyBinding.setView(view);
            this.fMoveDownForKeyBinding.setView(view);
            this.fMoveLeftForKeyBinding.setView(view);
            this.fMoveRightForKeyBinding.setView(view);
            this.fShowNodeStartForKeyBinding.setView(view);
            this.fShowNodeEndForKeyBinding.setView(view);
        }
    }

    public void setFindEnabled(boolean enabled) {
        if (this.fFindForKeyBinding != null) {
            this.fFindForKeyBinding.setEnabled(enabled);
        }
    }
}

