/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.ust.core.analysis.cpu;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.lttng2.ust.core.analysis.cpu.UstCpuStateProvider;
import org.eclipse.tracecompass.internal.lttng2.ust.core.trace.ContextVtidAspect;
import org.eclipse.tracecompass.lttng2.ust.core.trace.LttngUstTrace;
import org.eclipse.tracecompass.tmf.core.analysis.requirements.TmfAbstractAnalysisRequirement;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class UstCpuAnalysisModule
extends TmfStateSystemAnalysisModule {
    public static final @NonNull String ID = "org.eclipse.linuxtools.lttng2.ust.analysis.cpu";
    private static final @NonNull TmfAbstractAnalysisRequirement VTID_ASPECT_REQUIREMENT = new TmfAbstractAnalysisRequirement(Collections.emptySet(), TmfAbstractAnalysisRequirement.PriorityLevel.MANDATORY){

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public boolean test(ITmfTrace trace) {
            if (trace instanceof LttngUstTrace) {
                @NonNull Iterable eventAspects = TmfTraceUtils.getEventAspects((ITmfTrace)trace, ContextVtidAspect.class);
                return eventAspects.iterator().hasNext();
            }
            return false;
        }
    };

    public ITmfStateProvider createStateProvider() {
        return new UstCpuStateProvider(Objects.requireNonNull(this.getTrace()));
    }

    public Iterable<TmfAbstractAnalysisRequirement> getAnalysisRequirements() {
        return ImmutableSet.of((Object)VTID_ASPECT_REQUIREMENT);
    }
}

