/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ICModelStatus;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IContainerEntry;
import org.eclipse.cdt.core.model.IIncludeEntry;
import org.eclipse.cdt.core.model.IIncludeFileEntry;
import org.eclipse.cdt.core.model.ILibraryEntry;
import org.eclipse.cdt.core.model.IMacroEntry;
import org.eclipse.cdt.core.model.IMacroFileEntry;
import org.eclipse.cdt.core.model.IOutputEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.IPathEntryContainer;
import org.eclipse.cdt.core.model.IProjectEntry;
import org.eclipse.cdt.core.model.ISourceEntry;
import org.eclipse.cdt.core.resources.IPathEntryVariableManager;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.CoreModelMessages;
import org.eclipse.cdt.internal.core.model.PathEntry;
import org.eclipse.cdt.internal.core.model.PathEntryManager;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.DefaultScope;

public class PathEntryUtil {
    static final PathEntryManager manager = PathEntryManager.getDefault();
    static final IMarker[] NO_MARKERS = new IMarker[0];
    static final boolean VALIDATE_INCLUDE_ENTRIES = DefaultScope.INSTANCE.getNode("org.eclipse.cdt.core").getBoolean("validate_include_entries", true);

    private PathEntryUtil() {
    }

    public static IPathEntry getExpandedPathEntry(IPathEntry entry, ICProject cproject) throws CModelException {
        switch (entry.getEntryKind()) {
            case 16: {
                IIncludeEntry includeEntry = (IIncludeEntry)entry;
                IPath refPath = includeEntry.getBaseReference();
                if (refPath == null || refPath.isEmpty()) break;
                IPath includePath = includeEntry.getIncludePath();
                if (refPath.isAbsolute()) {
                    IPathEntry[] entries2;
                    ICProject refCProject;
                    IProject project;
                    IResource res = cproject.getCModel().getWorkspace().getRoot().findMember(refPath);
                    if (res == null || res.getType() != 4 || !CoreModel.hasCNature(project = (IProject)res) && !CoreModel.hasCCNature(project) || (refCProject = CoreModel.getDefault().create(project)) == null) break;
                    IPathEntry[] iPathEntryArray = entries2 = manager.getResolvedPathEntries(refCProject);
                    int n = entries2.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IIncludeEntry refEntry;
                        IPathEntry pathEntry = iPathEntryArray[n2];
                        if (pathEntry.getEntryKind() == 16 && (refEntry = (IIncludeEntry)pathEntry).getIncludePath().equals((Object)includePath)) {
                            IPath newBasePath = refEntry.getBasePath();
                            if (!newBasePath.isAbsolute() && !includePath.isAbsolute()) {
                                IResource refRes;
                                if (!newBasePath.isEmpty()) {
                                    refRes = cproject.getCModel().getWorkspace().getRoot().findMember(newBasePath);
                                } else {
                                    IPath refResPath = refEntry.getPath();
                                    refRes = cproject.getCModel().getWorkspace().getRoot().findMember(refResPath);
                                }
                                if (refRes != null) {
                                    if (refRes.getType() == 1) {
                                        refRes = refRes.getParent();
                                    }
                                    newBasePath = refRes.getLocation().append(newBasePath);
                                }
                            }
                            return CoreModel.newIncludeEntry(includeEntry.getPath(), newBasePath, includePath);
                        }
                        ++n2;
                    }
                } else {
                    IPathEntry[] entries;
                    IPathEntryContainer container = manager.getPathEntryContainer(refPath, cproject);
                    if (container == null) break;
                    IPathEntry[] iPathEntryArray = entries = container.getPathEntries();
                    int pathEntry = entries.length;
                    int entries2 = 0;
                    while (entries2 < pathEntry) {
                        IIncludeEntry refEntry;
                        IPathEntry pathEntry2 = iPathEntryArray[entries2];
                        if (pathEntry2.getEntryKind() == 16 && (refEntry = (IIncludeEntry)pathEntry2).getIncludePath().equals((Object)includePath)) {
                            IPath newBasePath = refEntry.getBasePath();
                            return CoreModel.newIncludeEntry(includeEntry.getPath(), newBasePath, includePath);
                        }
                        ++entries2;
                    }
                }
                break;
            }
            case 64: {
                IMacroEntry macroEntry = (IMacroEntry)entry;
                IPath refPath = macroEntry.getBaseReference();
                if (refPath == null || refPath.isEmpty()) break;
                String name = macroEntry.getMacroName();
                if (refPath.isAbsolute()) {
                    IPathEntry[] entries3;
                    ICProject refCProject;
                    IProject project;
                    IResource res = cproject.getCModel().getWorkspace().getRoot().findMember(refPath);
                    if (res == null || res.getType() != 4 || !CoreModel.hasCNature(project = (IProject)res) && !CoreModel.hasCCNature(project) || (refCProject = CoreModel.getDefault().create(project)) == null) break;
                    IPathEntry[] newBasePath = entries3 = manager.getResolvedPathEntries(refCProject);
                    int refEntry = entries3.length;
                    int n = 0;
                    while (n < refEntry) {
                        IMacroEntry refEntry2;
                        IPathEntry pathEntry = newBasePath[n];
                        if (pathEntry.getEntryKind() == 64 && (refEntry2 = (IMacroEntry)pathEntry).getMacroName().equals(name)) {
                            String value = refEntry2.getMacroValue();
                            return CoreModel.newMacroEntry(macroEntry.getPath(), name, value);
                        }
                        ++n;
                    }
                } else {
                    IPathEntry[] entries;
                    IPathEntryContainer container = manager.getPathEntryContainer(refPath, cproject);
                    if (container == null) break;
                    IPathEntry[] iPathEntryArray = entries = container.getPathEntries();
                    int pathEntry = entries.length;
                    int entries3 = 0;
                    while (entries3 < pathEntry) {
                        IMacroEntry refEntry;
                        IPathEntry pathEntry3 = iPathEntryArray[entries3];
                        if (pathEntry3.getEntryKind() == 64 && (refEntry = (IMacroEntry)pathEntry3).getMacroName().equals(name)) {
                            String value = refEntry.getMacroValue();
                            return CoreModel.newMacroEntry(macroEntry.getPath(), name, value);
                        }
                        ++entries3;
                    }
                }
                break;
            }
            case 1: {
                ILibraryEntry libEntry = (ILibraryEntry)entry;
                IPath refPath = libEntry.getBaseReference();
                if (refPath == null || refPath.isEmpty()) break;
                IPath libraryPath = libEntry.getLibraryPath();
                if (refPath.isAbsolute()) {
                    IPathEntry[] entries;
                    ICProject refCProject;
                    IProject project;
                    IResource res = cproject.getCModel().getWorkspace().getRoot().findMember(refPath);
                    if (res == null || res.getType() != 4 || !CoreModel.hasCNature(project = (IProject)res) && !CoreModel.hasCCNature(project) || (refCProject = CoreModel.getDefault().create(project)) == null) break;
                    IPathEntry[] iPathEntryArray = entries = manager.getResolvedPathEntries(refCProject);
                    int refEntry = entries.length;
                    int n = 0;
                    while (n < refEntry) {
                        ILibraryEntry refEntry3;
                        IPathEntry pathEntry = iPathEntryArray[n];
                        if (pathEntry.getEntryKind() == 1 && (refEntry3 = (ILibraryEntry)pathEntry).getLibraryPath().equals((Object)libraryPath)) {
                            IPath newBasePath = refEntry3.getBasePath();
                            if (!newBasePath.isAbsolute() && !libraryPath.isAbsolute()) {
                                IResource refRes;
                                if (!newBasePath.isEmpty()) {
                                    refRes = cproject.getCModel().getWorkspace().getRoot().findMember(newBasePath);
                                } else {
                                    IPath refResPath = refEntry3.getPath();
                                    refRes = cproject.getCModel().getWorkspace().getRoot().findMember(refResPath);
                                }
                                if (refRes != null) {
                                    if (refRes.getType() == 1) {
                                        refRes = refRes.getParent();
                                    }
                                    newBasePath = refRes.getLocation().append(newBasePath);
                                }
                            }
                            return CoreModel.newLibraryEntry(entry.getPath(), newBasePath, refEntry3.getLibraryPath(), refEntry3.getSourceAttachmentPath(), refEntry3.getSourceAttachmentRootPath(), refEntry3.getSourceAttachmentPrefixMapping(), false);
                        }
                        ++n;
                    }
                } else {
                    IPathEntry[] entries;
                    IPathEntryContainer container = manager.getPathEntryContainer(refPath, cproject);
                    if (container == null) break;
                    IPathEntry[] iPathEntryArray = entries = container.getPathEntries();
                    int n = entries.length;
                    int n3 = 0;
                    while (n3 < n) {
                        ILibraryEntry refEntry;
                        IPathEntry pathEntry = iPathEntryArray[n3];
                        if (pathEntry.getEntryKind() == 1 && (refEntry = (ILibraryEntry)pathEntry).getPath().equals((Object)libraryPath)) {
                            return CoreModel.newLibraryEntry(entry.getPath(), refEntry.getBasePath(), refEntry.getLibraryPath(), refEntry.getSourceAttachmentPath(), refEntry.getSourceAttachmentRootPath(), refEntry.getSourceAttachmentPrefixMapping(), false);
                        }
                        ++n3;
                    }
                }
                break;
            }
        }
        return entry;
    }

    public static IPathEntry cloneEntryAndExpand(IPath rpath, IPathEntry entry) {
        IPath entryPath = entry.getPath();
        if (entryPath == null) {
            entryPath = Path.EMPTY;
        }
        IPath resourcePath = entryPath.isAbsolute() ? entryPath : rpath.append(entryPath);
        IPathEntryVariableManager varManager = CCorePlugin.getDefault().getPathEntryVariableManager();
        switch (entry.getEntryKind()) {
            case 16: {
                IIncludeEntry include = (IIncludeEntry)entry;
                IPath basePath = include.getBasePath();
                basePath = varManager.resolvePath(basePath);
                IPath includePath = include.getIncludePath();
                includePath = varManager.resolvePath(includePath);
                return CoreModel.newIncludeEntry(resourcePath, basePath, includePath, include.isSystemInclude(), include.getExclusionPatterns(), include.isExported());
            }
            case 256: {
                IIncludeFileEntry includeFile = (IIncludeFileEntry)entry;
                IPath basePath = includeFile.getBasePath();
                basePath = varManager.resolvePath(basePath);
                IPath includeFilePath = includeFile.getIncludeFilePath();
                includeFilePath = varManager.resolvePath(includeFilePath);
                return CoreModel.newIncludeFileEntry(resourcePath, basePath, (IPath)Path.EMPTY, includeFilePath, includeFile.getExclusionPatterns(), includeFile.isExported());
            }
            case 1: {
                ILibraryEntry library = (ILibraryEntry)entry;
                IPath basePath = library.getBasePath();
                basePath = varManager.resolvePath(basePath);
                IPath libraryPath = library.getLibraryPath();
                libraryPath = varManager.resolvePath(libraryPath);
                IPath sourceAttachmentPath = library.getSourceAttachmentPath();
                sourceAttachmentPath = varManager.resolvePath(sourceAttachmentPath);
                IPath sourceAttachmentRootPath = library.getSourceAttachmentRootPath();
                sourceAttachmentRootPath = varManager.resolvePath(sourceAttachmentRootPath);
                IPath sourceAttachmentPrefixMapping = library.getSourceAttachmentPrefixMapping();
                sourceAttachmentPrefixMapping = varManager.resolvePath(sourceAttachmentPrefixMapping);
                return CoreModel.newLibraryEntry(resourcePath, basePath, libraryPath, sourceAttachmentPath, sourceAttachmentRootPath, sourceAttachmentPrefixMapping, library.isExported());
            }
            case 64: {
                IMacroEntry macro = (IMacroEntry)entry;
                return CoreModel.newMacroEntry(resourcePath, macro.getMacroName(), macro.getMacroValue(), macro.getExclusionPatterns(), macro.isExported());
            }
            case 512: {
                IMacroFileEntry macroFile = (IMacroFileEntry)entry;
                IPath basePath = macroFile.getBasePath();
                basePath = varManager.resolvePath(basePath);
                IPath macroFilePath = macroFile.getMacroFilePath();
                macroFilePath = varManager.resolvePath(macroFilePath);
                return CoreModel.newMacroFileEntry(resourcePath, basePath, (IPath)Path.EMPTY, macroFilePath, macroFile.getExclusionPatterns(), macroFile.isExported());
            }
            case 128: {
                IOutputEntry out = (IOutputEntry)entry;
                return CoreModel.newOutputEntry(resourcePath, out.getExclusionPatterns());
            }
            case 4: {
                IProjectEntry projEntry = (IProjectEntry)entry;
                return CoreModel.newProjectEntry(projEntry.getPath(), projEntry.isExported());
            }
            case 8: {
                ISourceEntry source = (ISourceEntry)entry;
                return CoreModel.newSourceEntry(resourcePath, source.getExclusionPatterns());
            }
            case 32: {
                return CoreModel.newContainerEntry(entry.getPath(), entry.isExported());
            }
        }
        return entry;
    }

    public static ICModelStatus validatePathEntry(ICProject cProject, IPathEntry[] entries) {
        StringBuilder errMesg;
        int i;
        HashSet<IPathEntry> entrySet = new HashSet<IPathEntry>(entries.length);
        IPathEntry[] iPathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IPathEntry entry = iPathEntryArray[n2];
            if (entry != null) {
                if (entrySet.contains(entry)) {
                    return new CModelStatus(964, MessageFormat.format(CCorePlugin.getResourceString("CoreModel.PathEntry.DuplicateEntry"), entry, entry.getPath()));
                }
                entrySet.add(entry);
            }
            ++n2;
        }
        List<IPathEntry> dups = PathEntryUtil.checkForDuplication(Arrays.asList(entries), 8);
        if (dups.size() > 0) {
            ICModelStatus[] cmodelStatus = new ICModelStatus[dups.size()];
            i = 0;
            while (i < dups.size()) {
                errMesg = new StringBuilder(CCorePlugin.getResourceString("CoreModel.PathEntry.DuplicateEntry"));
                cmodelStatus[i] = new CModelStatus(964, errMesg.toString());
                ++i;
            }
            return CModelStatus.newMultiStatus(964, cmodelStatus);
        }
        dups = PathEntryUtil.checkForDuplication(Arrays.asList(entries), 128);
        if (dups.size() > 0) {
            ICModelStatus[] cmodelStatus = new ICModelStatus[dups.size()];
            i = 0;
            while (i < dups.size()) {
                errMesg = new StringBuilder(CCorePlugin.getResourceString("CoreModel.PathEntry.DuplicateEntry"));
                cmodelStatus[i] = new CModelStatus(977, errMesg.toString());
                ++i;
            }
            return CModelStatus.newMultiStatus(964, cmodelStatus);
        }
        IPathEntry[] iPathEntryArray2 = entries;
        int n3 = entries.length;
        n = 0;
        while (n < n3) {
            IPathEntry entry = iPathEntryArray2[n];
            if (entry != null) {
                IPath entryPath = entry.getPath();
                int kind = entry.getEntryKind();
                if (kind == 8) {
                    IPathEntry[] iPathEntryArray3 = entries;
                    int n4 = entries.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        IPathEntry otherEntry = iPathEntryArray3[n5];
                        if (otherEntry != null) {
                            int otherKind = otherEntry.getEntryKind();
                            IPath otherPath = otherEntry.getPath();
                            if (entry != otherEntry && otherKind == 8) {
                                char[][] exclusionPatterns = ((ISourceEntry)otherEntry).fullExclusionPatternChars();
                                if (otherPath.isPrefixOf(entryPath) && !otherPath.equals((Object)entryPath) && !CoreModelUtil.isExcluded(entryPath.append("*"), exclusionPatterns)) {
                                    if (CoreModelUtil.isExcluded(entryPath, exclusionPatterns)) {
                                        StringBuilder errMesg2 = new StringBuilder(CCorePlugin.getResourceString("CoreModel.PathEntry.NestedEntry"));
                                        return new CModelStatus(964, errMesg2.toString());
                                    }
                                    if (otherKind == 8) {
                                        StringBuilder errMesg3 = new StringBuilder(CCorePlugin.getResourceString("CoreModel.PathEntry.NestedEntry"));
                                        return new CModelStatus(964, errMesg3.toString());
                                    }
                                    StringBuilder errMesg4 = new StringBuilder(CCorePlugin.getResourceString("CoreModel.PathEntry.NestedEntry"));
                                    return new CModelStatus(964, errMesg4.toString());
                                }
                            }
                        }
                        ++n5;
                    }
                }
            }
            ++n;
        }
        return CModelStatus.VERIFIED_OK;
    }

    public static ICModelStatus validatePathEntry(ICProject cProject, IPathEntry entry, boolean checkSourceAttachment, boolean recurseInContainers) {
        IProject project = cProject.getProject();
        IPath path = entry.getPath();
        if (entry.getEntryKind() != 4 && entry.getEntryKind() != 32 && entry.getEntryKind() != 128 && !PathEntryUtil.isValidWorkspacePath(project, path)) {
            return new CModelStatus(964, CoreModelMessages.getFormattedString("PathEntryManager.0", new Object[]{path.toOSString(), ((PathEntry)entry).getKindString()}));
        }
        switch (entry.getEntryKind()) {
            case 16: {
                if (!VALIDATE_INCLUDE_ENTRIES) break;
                IIncludeEntry include = (IIncludeEntry)entry;
                IPath includePath = include.getFullIncludePath();
                if (!PathEntryUtil.isValidExternalPath(includePath)) {
                    return new CModelStatus(964, CoreModelMessages.getFormattedString("PathEntryManager.2", includePath.toOSString()));
                }
                if (PathEntryUtil.isValidBasePath(include.getBasePath())) break;
                return new CModelStatus(964, CoreModelMessages.getFormattedString("PathEntryManager.1", includePath.toOSString()));
            }
            case 1: {
                IPath sourceAttach;
                ILibraryEntry library = (ILibraryEntry)entry;
                if (!(!checkSourceAttachment || (sourceAttach = library.getSourceAttachmentPath()) == null || sourceAttach.isAbsolute() || PathEntryUtil.isValidWorkspacePath(project, sourceAttach) && PathEntryUtil.isValidExternalPath(sourceAttach))) {
                    return new CModelStatus(964, CoreModelMessages.getFormattedString("PathEntryManager.3", sourceAttach.toOSString()));
                }
                IPath libraryPath = library.getFullLibraryPath();
                if (!PathEntryUtil.isValidExternalPath(libraryPath)) {
                    return new CModelStatus(964, CoreModelMessages.getFormattedString("PathEntryManager.4", libraryPath.toOSString()));
                }
                if (PathEntryUtil.isValidBasePath(library.getBasePath())) break;
                return new CModelStatus(964, CoreModelMessages.getFormattedString("PathEntryManager.7", libraryPath.toOSString()));
            }
            case 4: {
                IProjectEntry projEntry = (IProjectEntry)entry;
                path = projEntry.getPath();
                IProject reqProject = project.getWorkspace().getRoot().getProject(path.segment(0));
                if (!reqProject.isAccessible()) {
                    return new CModelStatus(964, CoreModelMessages.getString("PathEntryManager.5"));
                }
                if (CoreModel.hasCNature(reqProject) || CoreModel.hasCCNature(reqProject)) break;
                return new CModelStatus(964, CoreModelMessages.getString("PathEntryManager.6"));
            }
            case 32: {
                if (!recurseInContainers) break;
                try {
                    IPathEntry[] contEntries;
                    IPathEntryContainer cont = manager.getPathEntryContainer((IContainerEntry)entry, cProject);
                    IPathEntry[] iPathEntryArray = contEntries = cont.getPathEntries();
                    int n = contEntries.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPathEntry contEntrie = iPathEntryArray[n2];
                        ICModelStatus status = PathEntryUtil.validatePathEntry(cProject, contEntrie, checkSourceAttachment, false);
                        if (!status.isOK()) {
                            return status;
                        }
                        ++n2;
                    }
                    break;
                }
                catch (CModelException e) {
                    return new CModelStatus(e);
                }
            }
        }
        return CModelStatus.VERIFIED_OK;
    }

    private static boolean isValidWorkspacePath(IProject project, IPath path) {
        if (path == null) {
            return false;
        }
        IWorkspaceRoot workspaceRoot = project.getWorkspace().getRoot();
        IResource res = null;
        res = path.isAbsolute() ? workspaceRoot.findMember(path) : project.findMember(path);
        return res != null && res.isAccessible();
    }

    private static boolean isValidExternalPath(IPath path) {
        if (path != null) {
            if (path.isUNC()) {
                return true;
            }
            File file = path.toFile();
            if (file != null) {
                return file.exists();
            }
        }
        return false;
    }

    private static boolean isValidBasePath(IPath path) {
        IResource res;
        return path.isEmpty() || path.isAbsolute() || (res = ResourcesPlugin.getWorkspace().getRoot().findMember(path)) != null && res.isAccessible();
    }

    public static List<IPathEntry> checkForDuplication(List<IPathEntry> pathEntries, int type) {
        ArrayList<IPathEntry> duplicate = new ArrayList<IPathEntry>(pathEntries.size());
        int i = 0;
        while (i < pathEntries.size()) {
            IPathEntry pathEntry = pathEntries.get(i);
            if (pathEntry.getEntryKind() == type) {
                int j = 0;
                while (j < pathEntries.size()) {
                    IPathEntry otherEntry = pathEntries.get(j);
                    if (otherEntry.getEntryKind() == type && !pathEntry.equals(otherEntry) && !duplicate.contains(pathEntry) && pathEntry.getPath().equals((Object)otherEntry.getPath())) {
                        duplicate.add(otherEntry);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return duplicate;
    }

    public static void createPathEntryProblemMarker(IProject project, ICModelStatus status) {
        int severity = PathEntryUtil.code2Severity(status);
        try {
            IMarker marker = project.createMarker("org.eclipse.cdt.core.pathentry_problem");
            marker.setAttributes(new String[]{"message", "severity", "location", "pathEntryFileFormat"}, new Object[]{status.getMessage(), severity, "pathentry", "false"});
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public static void flushPathEntryProblemMarkers(IProject project) {
        IWorkspace workspace = project.getWorkspace();
        try {
            IMarker[] markers = PathEntryUtil.getPathEntryProblemMarkers(project);
            workspace.deleteMarkers(markers);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public static IMarker[] getPathEntryProblemMarkers(IProject project) {
        try {
            IMarker[] markers = project.findMarkers("org.eclipse.cdt.core.pathentry_problem", false, 0);
            if (markers != null) {
                return markers;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return NO_MARKERS;
    }

    public static boolean hasPathEntryProblemMarkersChange(IProject project, ICModelStatus[] status) {
        IMarker[] markers = PathEntryUtil.getPathEntryProblemMarkers(project);
        if (markers.length != status.length) {
            return true;
        }
        int i = 0;
        while (i < markers.length) {
            boolean found = false;
            String message = markers[i].getAttribute("message", "");
            int severity = markers[i].getAttribute("severity", 2);
            int j = 0;
            while (j < status.length) {
                String msg = status[j].getMessage();
                int cseverity = PathEntryUtil.code2Severity(status[j]);
                if (msg.equals(message) && severity == cseverity) {
                    found = true;
                }
                ++j;
            }
            if (!found) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int code2Severity(ICModelStatus status) {
        return switch (status.getCode()) {
            case 964 -> 1;
            case 979 -> 1;
            default -> 2;
        };
    }
}

