/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.framework;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleWiring;

class XMLParsingServiceFactory
implements ServiceFactory<Object> {
    private final boolean isSax;
    private final boolean setTccl;

    public XMLParsingServiceFactory(boolean isSax, boolean setTccl) {
        this.isSax = isSax;
        this.setTccl = setTccl;
    }

    @Override
    public Object getService(Bundle bundle, ServiceRegistration<Object> registration) {
        if (!this.setTccl || bundle == null) {
            return this.createService();
        }
        ClassLoader savedClassLoader = Thread.currentThread().getContextClassLoader();
        boolean restoreTccl = true;
        try {
            ClassLoader cl;
            BundleWiring wiring = bundle.adapt(BundleWiring.class);
            ClassLoader classLoader = cl = wiring == null ? null : wiring.getClassLoader();
            if (cl != null) {
                try {
                    Thread.currentThread().setContextClassLoader(cl);
                }
                catch (RuntimeException e) {
                    restoreTccl = false;
                }
            }
            Object object = this.createService();
            return object;
        }
        finally {
            if (restoreTccl) {
                Thread.currentThread().setContextClassLoader(savedClassLoader);
            }
        }
    }

    private Object createService() {
        if (this.isSax) {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            try {
                factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            return factory;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        return factory;
    }

    @Override
    public void ungetService(Bundle bundle, ServiceRegistration<Object> registration, Object service) {
    }
}

