/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.profiling.core.base;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.profiling.core.base.FlameDefaultPalette2;
import org.eclipse.tracecompass.analysis.profiling.core.base.IDataPalette;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.registry.LinuxStyle;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph2.AggregatedThreadStatus;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;

public class FlameWithKernelPalette
implements IDataPalette {
    private static final Map<String, OutputElementStyle> STYLES;
    private static final Map<String, OutputElementStyle> STYLE_MAP;
    private static @Nullable FlameWithKernelPalette fInstance;

    static {
        STYLE_MAP = Collections.synchronizedMap(new HashMap());
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        Map<String, OutputElementStyle> defaultStyles = FlameDefaultPalette2.getInstance().getStyles();
        builder.putAll(defaultStyles);
        LinuxStyle[] linuxStyleArray = LinuxStyle.values();
        int n = linuxStyleArray.length;
        int n2 = 0;
        while (n2 < n) {
            LinuxStyle style = linuxStyleArray[n2];
            builder.put((Object)style.getLabel(), (Object)new OutputElementStyle(null, style.toMap()));
            ++n2;
        }
        STYLES = builder.build();
        fInstance = null;
    }

    private FlameWithKernelPalette() {
    }

    public static FlameWithKernelPalette getInstance() {
        FlameWithKernelPalette instance = fInstance;
        if (instance == null) {
            fInstance = instance = new FlameWithKernelPalette();
        }
        return instance;
    }

    @Override
    public OutputElementStyle getStyleFor(Object object) {
        if (object instanceof AggregatedThreadStatus) {
            return FlameWithKernelPalette.getElementStyle(((AggregatedThreadStatus)object).getProcessStatus().getStateValue().unboxInt());
        }
        return FlameDefaultPalette2.getInstance().getStyleFor(object);
    }

    private static OutputElementStyle getElementStyle(int stateValue) {
        String styleFor = FlameWithKernelPalette.getStyleFor(stateValue);
        return STYLE_MAP.computeIfAbsent(styleFor, style -> new OutputElementStyle(style));
    }

    public static String getStyleFor(int stateValue) {
        switch (stateValue) {
            case 0: {
                return LinuxStyle.UNKNOWN.getLabel();
            }
            case 2: {
                return LinuxStyle.USERMODE.getLabel();
            }
            case 3: {
                return LinuxStyle.SYSCALL.getLabel();
            }
            case 4: {
                return LinuxStyle.INTERRUPTED.getLabel();
            }
            case 1: {
                return LinuxStyle.WAIT_BLOCKED.getLabel();
            }
            case 5: {
                return LinuxStyle.WAIT_FOR_CPU.getLabel();
            }
            case 6: {
                return LinuxStyle.WAIT_UNKNOWN.getLabel();
            }
        }
        return LinuxStyle.UNKNOWN.getLabel();
    }

    @Override
    public Map<String, OutputElementStyle> getStyles() {
        return STYLES;
    }
}

