/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values;

import org.eclipse.jdt.annotation.Nullable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class RhinoScriptEngine {
    private static final int DEFAULT_OPTIMIZATION_LEVEL = 9;
    private @Nullable ScriptableObject fScope;
    private @Nullable Context fContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @Nullable Context getContext() {
        Context context = Context.getCurrentContext();
        if (context == null) {
            ContextFactory contextFactory = ContextFactory.getGlobal();
            synchronized (contextFactory) {
                context = Context.enter();
            }
        }
        return context;
    }

    public synchronized void setupEngine() {
        Context context = RhinoScriptEngine.getContext();
        if (context != null) {
            context.setGeneratingDebug(false);
            context.setOptimizationLevel(9);
            context.setDebugger(null, null);
            this.fScope = new ImporterTopLevel(context);
            context.setGenerateObserverCount(true);
            context.setInstructionObserverThreshold(10);
            try {
                Context.class.getDeclaredField("VERSION_ES6");
                context.setLanguageVersion(200);
            }
            catch (Exception e) {
                try {
                    Context.class.getDeclaredField("VERSION_1_8");
                    context.setLanguageVersion(180);
                }
                catch (Exception e1) {
                    context.setLanguageVersion(170);
                }
            }
            this.fContext = context;
        }
    }

    public synchronized void teardownEngine() {
        Context.exit();
        this.fContext = null;
        this.fScope = null;
    }

    public @Nullable Object execute(String javascriptExpression) throws RhinoException {
        Context context = this.fContext;
        ScriptableObject scope = this.fScope;
        Object result = null;
        if (context != null && scope != null) {
            result = context.evaluateString((Scriptable)scope, javascriptExpression, "Data Driven Source", 1, null);
        }
        if (result == null || result instanceof Undefined) {
            return null;
        }
        if (result instanceof NativeJavaObject) {
            return ((NativeJavaObject)result).unwrap();
        }
        if ("org.mozilla.javascript.InterpretedFunction".equals(result.getClass().getName())) {
            return null;
        }
        return result;
    }

    public void put(String name, @Nullable Object value) {
        ScriptableObject scope = this.fScope;
        if (scope != null) {
            scope.put(name, (Scriptable)scope, value);
        }
    }
}

