/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenFsm;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.IDataDrivenRuntimeObject;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.runtime.DataDrivenRuntimeData;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.module.IAnalysisDataContainer;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

public class DataDrivenPatternEventHandler
implements IDataDrivenRuntimeObject {
    private final Collection<DataDrivenFsm> fFsms;
    private final Collection<DataDrivenFsm> fInitials;
    private final Set<DataDrivenFsm> fActiveFsmList = new HashSet<DataDrivenFsm>();

    public DataDrivenPatternEventHandler(Collection<DataDrivenFsm> fsms, Collection<DataDrivenFsm> initials) {
        this.fFsms = fsms;
        this.fInitials = initials;
    }

    public void dispose(DataDrivenRuntimeData executionData) {
        for (DataDrivenFsm fsm : this.fFsms) {
            fsm.dispose(executionData);
        }
    }

    public void handleEvent(ITmfEvent event, IAnalysisDataContainer container, DataDrivenRuntimeData runtimeData) {
        Set<DataDrivenFsm> activeFsmList = this.fActiveFsmList;
        if (activeFsmList.isEmpty()) {
            Collection<DataDrivenFsm> fsms = this.fInitials;
            if (this.fInitials.isEmpty()) {
                fsms = this.fFsms;
            }
            for (DataDrivenFsm fsm : fsms) {
                this.fActiveFsmList.add(fsm);
                fsm.createScenario(event, true, runtimeData, container);
            }
        } else {
            ArrayList<DataDrivenFsm> fsmToStart = new ArrayList<DataDrivenFsm>();
            for (DataDrivenFsm fsm : this.fFsms) {
                if (!fsm.isNewScenarioAllowed(runtimeData.getRuntimeForFsm(fsm))) continue;
                fsmToStart.add(fsm);
            }
            for (DataDrivenFsm fsm : fsmToStart) {
                this.fActiveFsmList.add(fsm);
                fsm.createScenario(event, false, runtimeData, container);
            }
        }
        for (DataDrivenFsm fsm : activeFsmList) {
            fsm.handleEvent(event, runtimeData, container);
        }
    }
}

