/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.model.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.TableColumnDescriptor;
import org.eclipse.tracecompass.tmf.core.model.ITableColumnDescriptor;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;

public class TmfTreeModel<T extends ITmfTreeDataModel> {
    public static final int ALL_LEVELS = -1;
    private List<String> fHeaders;
    private List<ITableColumnDescriptor> fColumnDescriptors;
    private List<T> fEntries;
    private @Nullable String fScope;
    private int fAutoExpandLevel = -1;

    public TmfTreeModel(List<String> headers, List<T> entries) {
        this(headers, entries, null);
    }

    public TmfTreeModel(List<String> headers, List<T> entries, @Nullable String scope) {
        this.fHeaders = headers;
        this.fColumnDescriptors = new ArrayList<ITableColumnDescriptor>();
        for (String header : headers) {
            TableColumnDescriptor.Builder builder = new TableColumnDescriptor.Builder();
            builder.setText(header);
            this.fColumnDescriptors.add(builder.build());
        }
        this.fEntries = entries;
        this.fScope = scope;
    }

    public List<ITableColumnDescriptor> getColumnDescriptors() {
        return this.fColumnDescriptors;
    }

    private TmfTreeModel(Builder<T> builder) {
        this.fHeaders = builder.fColumnDescriptors.stream().map(ITableColumnDescriptor::getText).collect(Collectors.toList());
        this.fColumnDescriptors = builder.fColumnDescriptors;
        this.fEntries = builder.fEntries;
        this.fScope = builder.fScope;
        this.fAutoExpandLevel = builder.fAutoExpandLevel;
    }

    public List<String> getHeaders() {
        return this.fHeaders;
    }

    public List<T> getEntries() {
        return this.fEntries;
    }

    public @Nullable String getScope() {
        return this.fScope;
    }

    public int getAutoExpandLevel() {
        return this.fAutoExpandLevel;
    }

    public void setAutoExpandLevel(int autoExpandLevel) {
        this.fAutoExpandLevel = autoExpandLevel;
    }

    public static class Builder<T extends ITmfTreeDataModel> {
        private List<ITableColumnDescriptor> fColumnDescriptors = new ArrayList<ITableColumnDescriptor>();
        private List<T> fEntries = Collections.emptyList();
        private @Nullable String fScope;
        private int fAutoExpandLevel = -1;

        public Builder<T> setColumnDescriptors(List<ITableColumnDescriptor> columnDescriptors) {
            this.fColumnDescriptors = columnDescriptors;
            return this;
        }

        public Builder<T> setEntries(List<T> entries) {
            this.fEntries = entries;
            return this;
        }

        public Builder<T> setScope(String scope) {
            this.fScope = scope;
            return this;
        }

        public Builder<T> setAutoExpandLevel(int autoExpandLevel) {
            this.fAutoExpandLevel = autoExpandLevel;
            return this;
        }

        public TmfTreeModel<T> build() {
            return new TmfTreeModel(this);
        }
    }
}

