/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.dataprovider;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.tmf.core.config.ITmfConfiguration;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderDescriptor;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderFactory;
import org.eclipse.tracecompass.tmf.core.model.ITmfDataProvider;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;

public class DataProviderManager {
    private static @Nullable DataProviderManager INSTANCE;
    private static final String EXTENSION_POINT_ID = "org.eclipse.tracecompass.tmf.core.dataprovider";
    private static final String ELEMENT_NAME_PROVIDER = "dataProviderFactory";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_ID = "id";
    private static final String ELEMENT_NAME_HIDE_DATA_PROVIDER = "hideDataProvider";
    private static final String ATTR_ID_REGEX = "idRegex";
    private static final String ATTR_TRACETYPE = "tracetype";
    private static final URL CONFIG_FILE_TEMPLATE;
    private static final File CONFIG_FILE;
    private static final Pattern CONFIG_LINE_PATTERN;
    private static final String HIDE = "hide";
    private static final String SHOW = "show";
    private static final String WILDCARD = "*";
    private Map<String, IDataProviderFactory> fDataProviderFactories = new HashMap<String, IDataProviderFactory>();
    private Multimap<String, Pattern> fHideDataProviders = HashMultimap.create();
    private Multimap<String, Pattern> fShowDataProviders = HashMultimap.create();
    private final Multimap<ITmfTrace, ITmfDataProvider> fInstances = LinkedHashMultimap.create();

    static {
        CONFIG_FILE_TEMPLATE = DataProviderManager.class.getResource("/templates/dataprovider.ini");
        CONFIG_FILE = Activator.getDefault().getStateLocation().addTrailingSeparator().append("dataprovider.ini").toFile();
        CONFIG_LINE_PATTERN = Pattern.compile("(hide|show):(.+):(.*)");
    }

    public static synchronized DataProviderManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DataProviderManager();
        }
        return INSTANCE;
    }

    public static synchronized void dispose() {
        DataProviderManager manager = INSTANCE;
        if (manager != null) {
            TmfSignalManager.deregister(manager);
            for (IDataProviderFactory factory : manager.fDataProviderFactories.values()) {
                TmfSignalManager.deregister(factory);
                factory.dispose();
            }
            manager.fDataProviderFactories.clear();
            manager.fInstances.clear();
        }
        INSTANCE = null;
    }

    private DataProviderManager() {
        this.loadDataProviders();
        this.loadHiddenDataProviders();
        TmfSignalManager.register(this);
    }

    private void loadDataProviders() {
        IConfigurationElement[] configElements;
        IConfigurationElement[] iConfigurationElementArray = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement cElement = iConfigurationElementArray[n2];
            if (cElement != null && cElement.getName().equals(ELEMENT_NAME_PROVIDER)) {
                try {
                    Object extension = cElement.createExecutableExtension(ATTR_CLASS);
                    this.fDataProviderFactories.put(cElement.getAttribute(ATTR_ID), (IDataProviderFactory)extension);
                }
                catch (CoreException e) {
                    Activator.logError("Unable to load extensions", e);
                }
            }
            ++n2;
        }
    }

    private void loadHiddenDataProviders() {
        IConfigurationElement[] configElements;
        IConfigurationElement[] iConfigurationElementArray = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement cElement = iConfigurationElementArray[n2];
            if (cElement != null && cElement.getName().equals(ELEMENT_NAME_HIDE_DATA_PROVIDER)) {
                String idRegex = cElement.getAttribute(ATTR_ID_REGEX);
                String tracetype = cElement.getAttribute(ATTR_TRACETYPE);
                tracetype = tracetype == null || tracetype.isBlank() ? WILDCARD : tracetype;
                try {
                    this.fHideDataProviders.put((Object)tracetype, (Object)Pattern.compile(idRegex));
                    String pluginId = ((IExtension)cElement.getParent()).getNamespaceIdentifier();
                    Activator.log((IStatus)new Status(1, "org.eclipse.tracecompass.tmf.core", String.format("plugin: %s is hiding data providers matching regex:\"%s\" for tracetype:%s", pluginId, idRegex, tracetype)));
                }
                catch (PatternSyntaxException e) {
                    Activator.logError("Invalid hideDataProvider regex pattern", e);
                }
            }
            ++n2;
        }
        if (!CONFIG_FILE.exists()) {
            try {
                File defaultConfigFile = new File(FileLocator.toFileURL((URL)CONFIG_FILE_TEMPLATE).toURI());
                Files.copy(defaultConfigFile.toPath(), CONFIG_FILE.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException | URISyntaxException e) {
                Activator.logError("Error copying " + String.valueOf(CONFIG_FILE_TEMPLATE) + " to " + CONFIG_FILE.getAbsolutePath(), e);
            }
        }
        try {
            Throwable e = null;
            Object var3_6 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(CONFIG_FILE));){
                String line = null;
                while ((line = reader.readLine()) != null) {
                    Matcher matcher = CONFIG_LINE_PATTERN.matcher(line);
                    if (!matcher.matches()) continue;
                    String oper = matcher.group(1);
                    String idRegex = matcher.group(2);
                    String tracetype = matcher.group(3);
                    tracetype = tracetype == null || tracetype.isBlank() ? WILDCARD : tracetype;
                    try {
                        if (oper.equals(HIDE)) {
                            this.fHideDataProviders.put((Object)tracetype, (Object)Pattern.compile(idRegex));
                            Activator.log((IStatus)new Status(1, "org.eclipse.tracecompass.tmf.core", String.format("dataprovider.ini is hiding data providers matching regex:\"%s\" for tracetype:%s", idRegex, tracetype)));
                            continue;
                        }
                        if (!oper.equals(SHOW)) continue;
                        this.fShowDataProviders.put((Object)tracetype, (Object)Pattern.compile(idRegex));
                        Activator.log((IStatus)new Status(1, "org.eclipse.tracecompass.tmf.core", String.format("dataprovider.ini is showing data providers matching regex:\"%s\" for tracetype:%s", idRegex, tracetype)));
                    }
                    catch (PatternSyntaxException e2) {
                        Activator.logError("Invalid dataprovider.ini regex pattern", e2);
                    }
                }
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException e) {
            Activator.logError("Error reading " + CONFIG_FILE.getAbsolutePath(), e);
        }
    }

    @Deprecated(since="10.0", forRemoval=true)
    public synchronized <T extends ITmfTreeDataProvider<? extends ITmfTreeDataModel>> @Nullable T getOrCreateDataProvider(@NonNull ITmfTrace trace, String id, Class<T> dataProviderClass) {
        return (T)((ITmfTreeDataProvider)this.fetchOrCreateDataProvider(trace, id, dataProviderClass));
    }

    public synchronized <T extends ITmfDataProvider> @Nullable T fetchOrCreateDataProvider(@NonNull ITmfTrace trace, String id, Class<T> dataProviderClass) {
        Object dataProvider = this.fetchExistingDataProvider(trace, id, dataProviderClass);
        if (dataProvider != null) {
            return (T)((ITmfDataProvider)dataProviderClass.cast(dataProvider));
        }
        String[] ids = id.split(":", 2);
        for (ITmfTrace opened : TmfTraceManager.getInstance().getOpenedTraces()) {
            if (!TmfTraceManager.getTraceSetWithExperiment(opened).contains(trace)) continue;
            IDataProviderFactory providerFactory = this.fDataProviderFactories.get(ids[0]);
            if (providerFactory != null) {
                ITmfDataProvider iTmfDataProvider = dataProvider = ids.length > 1 ? providerFactory.createDataProvider(trace, String.valueOf(ids[1])) : providerFactory.createDataProvider(trace);
                if (dataProvider != null && id.equals(dataProvider.getId()) && dataProviderClass.isAssignableFrom(dataProvider.getClass())) {
                    this.fInstances.put((Object)trace, dataProvider);
                    return (T)((ITmfDataProvider)dataProviderClass.cast(dataProvider));
                }
            }
            return null;
        }
        return null;
    }

    @Deprecated(since="10.0", forRemoval=true)
    public synchronized <T extends ITmfTreeDataProvider<? extends ITmfTreeDataModel>> @Nullable T getExistingDataProvider(@NonNull ITmfTrace trace, String id, Class<T> dataProviderClass) {
        return (T)((ITmfTreeDataProvider)this.fetchExistingDataProvider(trace, id, dataProviderClass));
    }

    public synchronized <T extends ITmfDataProvider> @Nullable T fetchExistingDataProvider(@NonNull ITmfTrace trace, String id, Class<T> dataProviderClass) {
        for (ITmfDataProvider dataProvider : this.fInstances.get((Object)trace)) {
            if (!id.equals(dataProvider.getId()) || !dataProviderClass.isAssignableFrom(dataProvider.getClass()) || this.isHidden(id, trace)) continue;
            return (T)((ITmfDataProvider)dataProviderClass.cast(dataProvider));
        }
        return null;
    }

    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        new Thread(() -> {
            DataProviderManager dataProviderManager = this;
            synchronized (dataProviderManager) {
                for (ITmfTrace trace : TmfTraceManager.getTraceSetWithExperiment(signal.getTrace())) {
                    this.fInstances.removeAll((Object)trace).forEach(ITmfDataProvider::dispose);
                }
            }
        }).start();
    }

    public List<IDataProviderDescriptor> getAvailableProviders(@Nullable ITmfTrace trace) {
        if (trace == null) {
            return Collections.emptyList();
        }
        return this.getAvailableProviders(trace, (IDataProviderDescriptor desc) -> true);
    }

    public List<IDataProviderDescriptor> getAvailableProviders(@Nullable ITmfTrace trace, @Nullable ITmfConfiguration configuration) {
        if (trace == null || configuration == null) {
            return Collections.emptyList();
        }
        Predicate<IDataProviderDescriptor> predicate = desc -> {
            ITmfConfiguration cfg = desc.getConfiguration();
            return cfg != null && cfg.getSourceTypeId().equals(configuration.getSourceTypeId()) && cfg.getId().equals(configuration.getId());
        };
        return this.getAvailableProviders(trace, predicate);
    }

    private List<IDataProviderDescriptor> getAvailableProviders(@NonNull ITmfTrace trace, @NonNull Predicate<IDataProviderDescriptor> predicate) {
        ArrayList<IDataProviderDescriptor> list = new ArrayList<IDataProviderDescriptor>();
        for (IDataProviderFactory factory : this.fDataProviderFactories.values()) {
            Collection<IDataProviderDescriptor> descriptors = factory.getDescriptors(trace);
            for (IDataProviderDescriptor descriptor : descriptors) {
                if (this.isHidden(descriptor.getId(), trace) || !predicate.test(descriptor)) continue;
                list.add(descriptor);
            }
        }
        list.sort(Comparator.comparing(IDataProviderDescriptor::getName));
        return list;
    }

    private boolean isHidden(String id, @Nullable ITmfTrace trace) {
        return DataProviderManager.isMatching(this.fHideDataProviders, id, trace) && !DataProviderManager.isMatching(this.fShowDataProviders, id, trace);
    }

    private static boolean isMatching(Multimap<String, Pattern> multimap, String id, @Nullable ITmfTrace trace) {
        for (Pattern pattern : multimap.get((Object)WILDCARD)) {
            if (!pattern.matcher(id).matches()) continue;
            return true;
        }
        for (ITmfTrace expTrace : TmfTraceManager.getTraceSet(trace)) {
            String tracetype = expTrace.getTraceTypeId();
            for (Pattern pattern : multimap.get((Object)tracetype)) {
                if (!pattern.matcher(id).matches()) continue;
                return true;
            }
        }
        return false;
    }

    public <T extends ITmfTreeDataProvider<? extends ITmfTreeDataModel>> boolean removeDataProvider(ITmfTrace trace, T provider) {
        return this.fInstances.remove((Object)trace, provider);
    }

    public void removeDataProvider(ITmfTrace trace, String id) {
        Iterator iter = this.fInstances.get((Object)trace).iterator();
        while (iter.hasNext()) {
            ITmfDataProvider dp = (ITmfDataProvider)iter.next();
            if (!dp.getId().equals(id)) continue;
            dp.dispose();
            iter.remove();
            break;
        }
    }

    public synchronized Collection<IDataProviderFactory> getFactories() {
        return this.fDataProviderFactories.entrySet().stream().filter(e -> !this.isHidden((String)e.getKey(), null)).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public synchronized @Nullable IDataProviderFactory getFactory(String id) {
        String factoryId = DataProviderManager.extractFactoryId(id);
        return this.isHidden(factoryId, null) ? null : this.fDataProviderFactories.get(factoryId);
    }

    public synchronized void addDataProviderFactory(String id, IDataProviderFactory factory) {
        IDataProviderFactory existingFactory = this.fDataProviderFactories.put(id, factory);
        this.removeExistingDataProviders(existingFactory, id);
    }

    public synchronized void removeDataProviderFactory(String id) {
        String passedFactoryId = DataProviderManager.extractFactoryId(id);
        IDataProviderFactory existingFactory = this.fDataProviderFactories.remove(passedFactoryId);
        this.removeExistingDataProviders(existingFactory, passedFactoryId);
    }

    private void removeExistingDataProviders(IDataProviderFactory factory, String passedFactoryId) {
        if (factory != null) {
            for (ITmfTrace trace : this.fInstances.keySet()) {
                Iterator iter = this.fInstances.get((Object)trace).iterator();
                while (iter.hasNext()) {
                    ITmfDataProvider dp = (ITmfDataProvider)iter.next();
                    String factoryId = DataProviderManager.extractFactoryId(dp.getId());
                    if (!passedFactoryId.equals(factoryId)) continue;
                    dp.dispose();
                    iter.remove();
                }
            }
        }
    }

    private static String extractFactoryId(String id) {
        String[] ids = id.split(":", 2);
        return ids.length > 1 ? ids[0] : id;
    }
}

