/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.markers;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.trace.ICyclesConverter;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public interface IMarkerConstants {
    public static final String MARKER_SETS = "marker-sets";
    public static final String MARKER_SET = "marker-set";
    public static final String MARKER = "marker";
    public static final String SUBMARKER = "submarker";
    public static final String SEGMENTS = "segments";
    public static final String SEGMENT = "segment";
    public static final String NAME = "name";
    public static final String LABEL = "label";
    public static final String ID = "id";
    public static final String REFERENCE_ID = "referenceid";
    public static final String COLOR = "color";
    public static final String PERIOD = "period";
    public static final String UNIT = "unit";
    public static final String RANGE = "range";
    public static final String OFFSET = "offset";
    public static final String INDEX = "index";
    public static final String LENGTH = "length";
    public static final String MS = "ms";
    public static final String US = "us";
    public static final String NS = "ns";
    public static final String CYCLES = "cycles";
    public static final long NANO_PER_MILLI = 1000000L;
    public static final long NANO_PER_MICRO = 1000L;

    public static double convertToNanos(double number, String unit, @Nullable ITmfTrace trace) {
        ICyclesConverter adapter;
        if (unit.equalsIgnoreCase(MS)) {
            return number * 1000000.0;
        }
        if (unit.equalsIgnoreCase(US)) {
            return number * 1000.0;
        }
        if (unit.equalsIgnoreCase(NS)) {
            return number;
        }
        if (unit.equalsIgnoreCase(CYCLES) && trace instanceof IAdaptable && (adapter = (ICyclesConverter)((IAdaptable)trace).getAdapter(ICyclesConverter.class)) != null) {
            return adapter.cyclesToNanos((long)number);
        }
        return number;
    }
}

