/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.callstack;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.core.callstack.TmfResolvedSizedSymbol;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.segmentstore.core.SegmentStoreFactory;
import org.eclipse.tracecompass.tmf.core.symbols.IMappingFile;
import org.eclipse.tracecompass.tmf.core.symbols.TmfResolvedSymbol;

public class SizedMappingFile
implements IMappingFile {
    private final String fFullPath;
    private final boolean fIsBinaryFile;
    private final ISegmentStore<TmfResolvedSizedSymbol> fSymbolStore;
    private final int fPid;

    public SizedMappingFile(String path, boolean isBinaryFile, Map<Long, TmfResolvedSymbol> results, int pid) {
        this.fFullPath = path;
        this.fIsBinaryFile = isBinaryFile;
        this.fSymbolStore = SegmentStoreFactory.createSegmentStore((SegmentStoreFactory.SegmentStoreType[])new SegmentStoreFactory.SegmentStoreType[0]);
        for (TmfResolvedSymbol symbol : results.values()) {
            if (!(symbol instanceof TmfResolvedSizedSymbol)) continue;
            this.fSymbolStore.add((Object)((TmfResolvedSizedSymbol)symbol));
        }
        this.fPid = pid;
    }

    @Override
    public @NonNull String getFullPath() {
        return this.fFullPath;
    }

    @Override
    public boolean isBinaryFile() {
        return this.fIsBinaryFile;
    }

    @Override
    public @Nullable TmfResolvedSymbol getSymbolEntry(long address) {
        Iterable symbols = this.fSymbolStore.getIntersectingElements(address);
        Iterator iterator = symbols.iterator();
        TmfResolvedSymbol symbol = null;
        while (iterator.hasNext()) {
            TmfResolvedSizedSymbol current = (TmfResolvedSizedSymbol)iterator.next();
            if (symbol != null && symbol.getBaseAddress() >= current.getBaseAddress()) continue;
            symbol = current;
        }
        return symbol;
    }

    @Override
    public int getPid() {
        return this.fPid;
    }
}

