/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.Platform;

public class CommandLineUtil {
    private static boolean isWindows() {
        boolean osWin;
        try {
            osWin = Platform.getOS().equals("win32");
        }
        catch (Exception e) {
            osWin = false;
        }
        return osWin;
    }

    public static String[] argumentsToArray(String line) {
        if (CommandLineUtil.isWindows()) {
            return CommandLineUtil.argumentsToArrayWindowsStyle(line);
        }
        return CommandLineUtil.argumentsToArrayUnixStyle(line);
    }

    public static String[] argumentsToArrayUnixStyle(String line) {
        boolean INITIAL = false;
        boolean IN_DOUBLE_QUOTES = true;
        int IN_DOUBLE_QUOTES_ESCAPED = 2;
        int ESCAPED = 3;
        int IN_SINGLE_QUOTES = 4;
        int IN_ARG = 5;
        if (line == null) {
            line = "";
        }
        char[] array = line.trim().toCharArray();
        ArrayList<String> aList = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        int state = 0;
        int i = 0;
        while (i < array.length) {
            char c = array[i];
            block0 : switch (state) {
                case 0: 
                case 5: {
                    if (Character.isWhitespace(c)) {
                        if (state == 0) break;
                        state = 0;
                        String arg = buffer.toString();
                        buffer = new StringBuilder();
                        aList.add(arg);
                        break;
                    }
                    switch (c) {
                        case '\\': {
                            state = 3;
                            break block0;
                        }
                        case '\'': {
                            state = 4;
                            break block0;
                        }
                        case '\"': {
                            state = 1;
                            break block0;
                        }
                    }
                    state = 5;
                    buffer.append(c);
                    break;
                }
                case 1: {
                    switch (c) {
                        case '\\': {
                            state = 2;
                            break block0;
                        }
                        case '\"': {
                            state = 5;
                            break block0;
                        }
                    }
                    buffer.append(c);
                    break;
                }
                case 4: {
                    switch (c) {
                        case '\'': {
                            state = 5;
                            break block0;
                        }
                    }
                    buffer.append(c);
                    break;
                }
                case 2: {
                    switch (c) {
                        case '\"': 
                        case '\\': {
                            buffer.append(c);
                            break;
                        }
                        case 'n': {
                            buffer.append("\n");
                            break;
                        }
                        default: {
                            buffer.append('\\');
                            buffer.append(c);
                        }
                    }
                    state = 1;
                    break;
                }
                case 3: {
                    buffer.append(c);
                    state = 5;
                }
            }
            ++i;
        }
        if (state != 0) {
            aList.add(buffer.toString());
        }
        return aList.toArray(new String[aList.size()]);
    }

    public static String[] argumentsToArrayWindowsStyle(String line) {
        boolean INITIAL = false;
        boolean IN_DOUBLE_QUOTES = true;
        int IN_DOUBLE_QUOTES_ESCAPED = 2;
        int ESCAPED = 3;
        int IN_ARG = 5;
        if (line == null) {
            line = "";
        }
        char[] array = line.trim().toCharArray();
        ArrayList<String> aList = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        int state = 0;
        int i = 0;
        while (i < array.length) {
            char c = array[i];
            block0 : switch (state) {
                case 0: 
                case 5: {
                    if (Character.isWhitespace(c)) {
                        if (state == 0) break;
                        state = 0;
                        String arg = buffer.toString();
                        buffer = new StringBuilder();
                        aList.add(arg);
                        break;
                    }
                    switch (c) {
                        case '\\': {
                            state = 3;
                            break block0;
                        }
                        case '\"': {
                            state = 1;
                            break block0;
                        }
                    }
                    state = 5;
                    buffer.append(c);
                    break;
                }
                case 1: {
                    switch (c) {
                        case '\\': {
                            state = 2;
                            break block0;
                        }
                        case '\"': {
                            state = 5;
                            break block0;
                        }
                    }
                    buffer.append(c);
                    break;
                }
                case 2: {
                    switch (c) {
                        case '\"': {
                            buffer.append(c);
                            break;
                        }
                        default: {
                            buffer.append('\\');
                            buffer.append(c);
                        }
                    }
                    state = 1;
                    break;
                }
                case 3: {
                    state = 5;
                    switch (c) {
                        case ' ': 
                        case '\"': {
                            buffer.append(c);
                            break block0;
                        }
                    }
                    buffer.append('\\');
                    buffer.append(c);
                }
            }
            ++i;
        }
        if (state != 0) {
            aList.add(buffer.toString());
        }
        return aList.toArray(new String[aList.size()]);
    }

    public static String argumentsToString(Collection<String> args, boolean encodeNewline) {
        return CommandLineUtil.argumentsToString((String[])args.toArray(String[]::new), encodeNewline);
    }

    public static String argumentsToString(String[] args, boolean encodeNewline) {
        if (CommandLineUtil.isWindows()) {
            return CommandLineUtil.argumentsToStringWindowsCreateProcess(args, encodeNewline);
        }
        return CommandLineUtil.argumentsToStringBash(args, encodeNewline);
    }

    public static String argumentsToStringBash(String[] args, boolean encodeNewline) {
        StringBuilder builder = new StringBuilder();
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (builder.length() > 0) {
                builder.append(' ');
            }
            if (CommandLineUtil.needsQuoting(arg)) {
                builder.append('\'');
                int j = 0;
                while (j < arg.length()) {
                    char c = arg.charAt(j);
                    if (c == '\'') {
                        builder.append("'\"'\"'");
                    } else if (c == '\r' && encodeNewline) {
                        builder.append("'$'\\r''");
                    } else if (c == '\n' && encodeNewline) {
                        builder.append("'$'\\n''");
                    } else {
                        builder.append(c);
                    }
                    ++j;
                }
                builder.append('\'');
            } else {
                builder.append(arg);
            }
            ++n2;
        }
        return builder.toString();
    }

    public static String argumentsToStringWindowsCreateProcess(String[] args, boolean encodeNewline) {
        StringBuilder builder = new StringBuilder();
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (builder.length() > 0) {
                builder.append(' ');
            }
            if (CommandLineUtil.needsQuoting(arg)) {
                builder.append('\"');
                int j = 0;
                while (j < arg.length()) {
                    int numBackslashes = 0;
                    while (j < arg.length() && arg.charAt(j) == '\\') {
                        ++numBackslashes;
                        ++j;
                    }
                    if (j == arg.length()) {
                        CommandLineUtil.appendNBackslashes(builder, numBackslashes * 2);
                    } else if (arg.charAt(j) == '\"') {
                        CommandLineUtil.appendNBackslashes(builder, numBackslashes * 2);
                        builder.append('\\');
                        builder.append('\"');
                    } else if ((arg.charAt(j) == '\n' || arg.charAt(j) == '\r') && encodeNewline) {
                        builder.append(' ');
                    } else {
                        CommandLineUtil.appendNBackslashes(builder, numBackslashes);
                        builder.append(arg.charAt(j));
                    }
                    ++j;
                }
                builder.append('\"');
            } else {
                builder.append(arg);
            }
            ++n2;
        }
        return builder.toString();
    }

    private static boolean needsQuoting(String arg) {
        boolean needsQuoting = arg.isBlank() || arg.chars().mapToObj(i -> Character.valueOf((char)i)).anyMatch(c1 -> Character.isWhitespace(c1.charValue()) || c1.charValue() == '\"' || c1.charValue() == '\'');
        return needsQuoting;
    }

    private static void appendNBackslashes(StringBuilder builder, int numBackslashes) {
        int i = 0;
        while (i < numBackslashes) {
            builder.append('\\');
            ++i;
        }
    }
}

