/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.CExternalSetting;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.extension.CExternalSettingProvider;
import org.eclipse.cdt.internal.core.settings.model.CExternalSettingContainerFactory;
import org.eclipse.cdt.internal.core.settings.model.CExternalSettingContainerFactoryWithListener;
import org.eclipse.cdt.internal.core.settings.model.CExternalSettingsContainer;
import org.eclipse.cdt.internal.core.settings.model.CExternalSettingsContainerChangeInfo;
import org.eclipse.cdt.internal.core.settings.model.CExternalSettingsManager;
import org.eclipse.cdt.internal.core.settings.model.ExceptionFactory;
import org.eclipse.cdt.internal.core.settings.model.SettingsModelMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class ExtensionContainerFactory
extends CExternalSettingContainerFactoryWithListener {
    static final String FACTORY_ID = "org.eclipse.cdt.core.extension.container.factory";
    private static final String EXTENSION_ID = "org.eclipse.cdt.core.externalSettingsProvider";
    private static ExtensionContainerFactory fInstance;
    private Map<String, CExtensionSettingProviderDescriptor> fDescriptorMap;

    private Map<String, CExtensionSettingProviderDescriptor> getProviderDescriptorMap() {
        if (this.fDescriptorMap == null) {
            this.initProviderInfoSynch();
        }
        return this.fDescriptorMap;
    }

    private synchronized void initProviderInfoSynch() {
        if (this.fDescriptorMap != null) {
            return;
        }
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_ID);
        IExtension[] exts = extensionPoint.getExtensions();
        this.fDescriptorMap = new HashMap<String, CExtensionSettingProviderDescriptor>();
        IExtension[] iExtensionArray = exts;
        int n = exts.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension ext = iExtensionArray[n2];
            CExtensionSettingProviderDescriptor dr = new CExtensionSettingProviderDescriptor(ext);
            this.fDescriptorMap.put(dr.getId(), dr);
            ++n2;
        }
    }

    private ExtensionContainerFactory() {
    }

    public static ExtensionContainerFactory getInstance() {
        if (fInstance == null) {
            fInstance = new ExtensionContainerFactory();
        }
        return fInstance;
    }

    public static ExtensionContainerFactory getInstanceInitialized() {
        CExternalSettingContainerFactory f = CExternalSettingsManager.getInstance().getFactory(FACTORY_ID);
        if (f instanceof ExtensionContainerFactory) {
            return (ExtensionContainerFactory)f;
        }
        return ExtensionContainerFactory.getInstance();
    }

    @Override
    public CExternalSettingsContainer createContainer(String id, IProject project, ICConfigurationDescription cfgDes, CExternalSetting[] previousSettings) throws CoreException {
        CExtensionSettingProviderDescriptor dr = this.getProviderDescriptorMap().get(id);
        if (dr != null) {
            return dr.getContainer(project, cfgDes, previousSettings);
        }
        throw new CoreException(CCorePlugin.createStatus("External settings provider: \"" + id + "\" couldn't be found for " + String.valueOf(cfgDes.getProjectDescription().getProject()) + ":" + cfgDes.getName()));
    }

    public static String[] getReferencedProviderIds(ICConfigurationDescription cfg) {
        CExternalSettingsManager.CContainerRef[] refs = CExternalSettingsManager.getInstance().getReferences(cfg, FACTORY_ID);
        String[] ids = new String[refs.length];
        int i = 0;
        while (i < refs.length) {
            ids[i] = refs[i].getContainerId();
            ++i;
        }
        return ids;
    }

    public static void setReferencedProviderIds(ICConfigurationDescription cfg, String[] ids) {
        HashSet<String> newIdsSet = new HashSet<String>(Arrays.asList(ids));
        HashSet<String> oldIdsSet = new HashSet<String>(Arrays.asList(ExtensionContainerFactory.getReferencedProviderIds(cfg)));
        HashSet<String> newIdsSetCopy = new HashSet<String>(newIdsSet);
        newIdsSet.removeAll(oldIdsSet);
        oldIdsSet.removeAll(newIdsSetCopy);
        if (oldIdsSet.size() != 0) {
            for (String string : oldIdsSet) {
                ExtensionContainerFactory.removeReference(cfg, string);
            }
        }
        if (newIdsSet.size() != 0) {
            for (String string : newIdsSet) {
                ExtensionContainerFactory.createReference(cfg, string);
            }
        }
    }

    public static void updateReferencedProviderIds(String[] ids, IProgressMonitor monitor) {
        ExtensionContainerFactory instance = ExtensionContainerFactory.getInstanceInitialized();
        CExternalSettingsContainerChangeInfo[] changeInfos = new CExternalSettingsContainerChangeInfo[ids.length];
        int i = 0;
        while (i < changeInfos.length) {
            changeInfos[i] = new CExternalSettingsContainerChangeInfo(2, new CExternalSettingsManager.CContainerRef(FACTORY_ID, ids[i]), null);
            ++i;
        }
        instance.notifySettingsChange(null, null, changeInfos);
        if (monitor != null) {
            monitor.done();
        }
    }

    public static void updateReferencedProviderIds(ICConfigurationDescription cfg, String[] ids) {
        HashSet<String> newIdsSet = new HashSet<String>(Arrays.asList(ids));
        HashSet<String> oldIdsSet = new HashSet<String>(Arrays.asList(ExtensionContainerFactory.getReferencedProviderIds(cfg)));
        HashSet<String> newIdsSetCopy = new HashSet<String>(newIdsSet);
        newIdsSetCopy.removeAll(oldIdsSet);
        newIdsSet.removeAll(newIdsSetCopy);
        if (newIdsSet.size() != 0) {
            for (String string : newIdsSet) {
                ExtensionContainerFactory.providerChanged(cfg, string);
            }
        }
    }

    private static void createReference(ICConfigurationDescription cfg, String id) {
        CExternalSettingsManager.CContainerRef cr = ExtensionContainerFactory.createContainerRef(id);
        CExternalSettingsManager.getInstance().addContainer(cfg, cr);
    }

    private static void providerChanged(ICConfigurationDescription cfg, String id) {
        CExternalSettingsManager.CContainerRef cr = ExtensionContainerFactory.createContainerRef(id);
        CExternalSettingsManager.getInstance().containerContentsChanged(cfg, cr);
    }

    private static void removeReference(ICConfigurationDescription cfg, String id) {
        CExternalSettingsManager.CContainerRef cr = ExtensionContainerFactory.createContainerRef(id);
        CExternalSettingsManager.getInstance().removeContainer(cfg, cr);
    }

    private static CExternalSettingsManager.CContainerRef createContainerRef(String id) {
        return new CExternalSettingsManager.CContainerRef(FACTORY_ID, id);
    }

    private static class CESContainer
    extends CExternalSettingsContainer {
        private CExternalSetting[] fSettings;

        CESContainer(CExternalSetting[] settings) {
            this.fSettings = (CExternalSetting[])settings.clone();
        }

        @Override
        public CExternalSetting[] getExternalSettings() {
            return (CExternalSetting[])this.fSettings.clone();
        }
    }

    private static class CExtensionSettingProviderDescriptor {
        private static final String PROVIDER = "provider";
        private static final String CLASS = "class";
        private IExtension fExtension;
        private IConfigurationElement fProviderElement;
        private String fId;
        private String fName;
        private CExternalSettingProvider fProvider;

        CExtensionSettingProviderDescriptor(IExtension extension) {
            this.fId = extension.getUniqueIdentifier();
            this.fName = extension.getLabel();
            this.fExtension = extension;
        }

        public String getId() {
            return this.fId;
        }

        public String getName() {
            return this.fName;
        }

        private CExternalSettingProvider getProvider() {
            if (this.fProvider == null) {
                try {
                    this.fProvider = this.createProvider();
                }
                catch (CoreException e) {
                    CCorePlugin.log(e);
                }
                if (this.fProvider == null) {
                    this.fProvider = NullProvider.INSTANCE;
                }
            }
            return this.fProvider;
        }

        CExternalSettingsContainer getContainer(IProject project, ICConfigurationDescription cfg, CExternalSetting[] previousSettings) {
            return new CESContainer(this.getProvider().getSettings(project, cfg, previousSettings));
        }

        CExternalSettingProvider createProvider() throws CoreException {
            IConfigurationElement el = this.getProviderElement();
            if (el != null) {
                Object obj = el.createExecutableExtension(CLASS);
                if (obj instanceof CExternalSettingProvider) {
                    return (CExternalSettingProvider)obj;
                }
                throw ExceptionFactory.createCoreException(SettingsModelMessages.getString("ExtensionContainerFactory.4"));
            }
            throw ExceptionFactory.createCoreException(SettingsModelMessages.getString("ExtensionContainerFactory.5"));
        }

        private IConfigurationElement getProviderElement() {
            if (this.fProviderElement == null) {
                this.fProviderElement = CExtensionSettingProviderDescriptor.getProviderElement(this.fExtension);
            }
            return this.fProviderElement;
        }

        private static IConfigurationElement getProviderElement(IExtension ext) {
            IConfigurationElement[] els;
            IConfigurationElement[] iConfigurationElementArray = els = ext.getConfigurationElements();
            int n = els.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement el = iConfigurationElementArray[n2];
                String name = el.getName();
                if (PROVIDER.equals(name)) {
                    return el;
                }
                ++n2;
            }
            return null;
        }
    }

    private static class NullProvider
    extends CExternalSettingProvider {
        private static final NullProvider INSTANCE = new NullProvider();

        private NullProvider() {
        }

        @Override
        public CExternalSetting[] getSettings(IProject project, ICConfigurationDescription cfg) {
            return new CExternalSetting[0];
        }
    }
}

