/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorUndefStatement;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDirective;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespaceAlias;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPVariable;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.index.IIndexSymbols;
import org.eclipse.cdt.core.index.IPDOMASTProcessor;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.parser.FileContent;
import org.eclipse.cdt.core.parser.ISignificantMacros;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalDeclaredVariable;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.index.FileContentKey;
import org.eclipse.cdt.internal.core.index.IIndexFragmentFile;
import org.eclipse.cdt.internal.core.index.IWritableIndex;
import org.eclipse.cdt.internal.core.parser.scanner.LocationMap;
import org.eclipse.cdt.internal.core.pdom.FailedToReAcquireLockException;
import org.eclipse.cdt.internal.core.pdom.IndexerInputAdapter;
import org.eclipse.cdt.internal.core.pdom.IndexerStatistics;
import org.eclipse.cdt.internal.core.pdom.Messages;
import org.eclipse.cdt.internal.core.pdom.YieldableIndexLock;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMASTAdapter;
import org.eclipse.cdt.internal.core.pdom.indexer.IndexerASTVisitor;
import org.eclipse.cdt.internal.core.util.Canceler;
import org.eclipse.cdt.internal.core.util.ICanceler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public abstract class PDOMWriter
implements IPDOMASTProcessor {
    private static final boolean REPORT_UNKNOWN_BUILTINS = false;
    public static int SKIP_ALL_REFERENCES = -1;
    public static int SKIP_TYPE_REFERENCES = 1;
    public static int SKIP_MACRO_REFERENCES = 2;
    public static int SKIP_IMPLICIT_REFERENCES = 4;
    public static int SKIP_NO_REFERENCES = 0;
    protected boolean fShowProblems;
    protected boolean fShowInclusionProblems;
    private boolean fShowScannerProblems;
    private boolean fShowSyntaxProblems;
    protected boolean fShowActivity;
    protected final IndexerStatistics fStatistics;
    protected final IndexerInputAdapter fResolver;
    protected final ICanceler fCancelState = new Canceler();
    private int fSkipReferences = SKIP_NO_REFERENCES;

    public PDOMWriter(IndexerInputAdapter resolver) {
        this.fStatistics = new IndexerStatistics();
        this.fResolver = resolver;
    }

    protected IndexerInputAdapter getInputAdapter() {
        return this.fResolver;
    }

    public void setShowActivity(boolean val) {
        this.fShowActivity = val;
    }

    public void setShowInclusionProblems(boolean val) {
        this.fShowInclusionProblems = val;
    }

    public void setShowScannerProblems(boolean val) {
        this.fShowScannerProblems = val;
    }

    public void setShowSyntaxProblems(boolean val) {
        this.fShowSyntaxProblems = val;
    }

    public void setShowProblems(boolean val) {
        this.fShowProblems = val;
    }

    public void setSkipReferences(int options) {
        this.fSkipReferences = options;
    }

    public int getSkipReferences() {
        return this.fSkipReferences;
    }

    protected final void addSymbols(Data data, int storageLinkageID, FileContext ctx, IProgressMonitor monitor) throws InterruptedException, CoreException {
        if (data.isEmpty() || storageLinkageID == 0) {
            return;
        }
        if (this.fShowProblems) {
            this.fShowInclusionProblems = true;
            this.fShowScannerProblems = true;
            this.fShowSyntaxProblems = true;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        this.resolveNames(data, (IProgressMonitor)progress.split(1));
        this.storeSymbolsInIndex(data, storageLinkageID, ctx, (IProgressMonitor)progress.split(1));
        if (!data.fStatuses.isEmpty()) {
            List<IStatus> statuses = data.fStatuses;
            String path = null;
            path = data.fSelectedFiles.length > 0 ? data.fSelectedFiles[data.fSelectedFiles.length - 1].fileContentKey.getLocation().getURI().getPath() : data.fAST.getFilePath().toString();
            String msg = NLS.bind((String)Messages.PDOMWriter_errorWhileParsing, (Object)path);
            if (statuses.size() == 1) {
                IStatus status = statuses.get(0);
                if (msg.equals(status.getMessage())) {
                    throw new CoreException(status);
                }
                throw new CoreException((IStatus)new Status(status.getSeverity(), status.getPlugin(), status.getCode(), msg + ":" + status.getMessage(), status.getException()));
            }
            throw new CoreException((IStatus)new MultiStatus("org.eclipse.cdt.core", 0, statuses.toArray(new IStatus[statuses.size()]), msg, null));
        }
    }

    /*
     * Exception decompiling
     */
    private void storeSymbolsInIndex(Data data, int storageLinkageID, FileContext ctx, IProgressMonitor monitor) throws InterruptedException, CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void resolveNames(Data data, IProgressMonitor monitor) {
        long start = System.currentTimeMillis();
        HashSet<ICPPInternalDeclaredVariable> variables = new HashSet<ICPPInternalDeclaredVariable>();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)data.fSelectedFiles.length);
        FileInAST[] fileInASTArray = data.fSelectedFiles;
        int n = data.fSelectedFiles.length;
        int n2 = 0;
        while (n2 < n) {
            FileInAST file = fileInASTArray[n2];
            Symbols symbols = data.fSymbolMap.get(file.includeStatement);
            ArrayList<IASTName[]> names = symbols.fNames;
            SubMonitor progress2 = SubMonitor.convert((IProgressMonitor)progress, (int)names.size());
            boolean reported = false;
            Iterator<IASTName[]> j = names.iterator();
            while (j.hasNext()) {
                IASTName[] na = j.next();
                IASTName name = na[0];
                progress2.split(1);
                if (name == null) continue;
                try {
                    ICPPInternalDeclaredVariable variable;
                    IBinding binding = name.resolveBinding();
                    if (binding instanceof ICPPInternalDeclaredVariable && variables.add(variable = (ICPPInternalDeclaredVariable)binding)) {
                        variable.allDeclarationsDefinitionsAdded();
                    }
                    if (name.getPropertyInParent() == ICPPASTTemplateId.TEMPLATE_NAME && (((IASTName)name.getParent()).getBinding() == binding || binding instanceof ICPPFunctionTemplate)) {
                        na[0] = null;
                        continue;
                    }
                    if (binding instanceof IProblemBinding) {
                        IProblemBinding problemBinding = (IProblemBinding)binding;
                        if (problemBinding.getID() == 1 && CharArrayUtils.startsWith(problemBinding.getNameCharArray(), "__builtin_")) continue;
                        ++this.fStatistics.fProblemBindingCount;
                        if (!this.fShowProblems) continue;
                        this.reportProblem(problemBinding);
                        continue;
                    }
                    if (name.isReference()) {
                        if (binding instanceof ICPPTemplateParameter || binding instanceof ICPPUnknownBinding || (this.fSkipReferences & SKIP_TYPE_REFERENCES) != 0 && this.isTypeReferenceBinding(binding)) {
                            if (!this.isRequiredReference(name)) {
                                na[0] = null;
                                continue;
                            }
                            ++this.fStatistics.fReferenceCount;
                            continue;
                        }
                        ++this.fStatistics.fReferenceCount;
                        continue;
                    }
                    ++this.fStatistics.fDeclarationCount;
                }
                catch (RuntimeException | StackOverflowError e) {
                    if (!reported) {
                        data.fStatuses.add(CCorePlugin.createStatus(NLS.bind((String)Messages.PDOMWriter_errorResolvingName, (Object)name.toString(), (Object)file.fileContentKey.getLocation().getURI().getPath()), e));
                    }
                    reported = true;
                    j.remove();
                }
            }
            ++n2;
        }
        for (ICPPInternalDeclaredVariable variable : variables) {
            if (!this.isVariableIndexed(variable)) continue;
            IASTNode lookupPoint = variable.getDefinition() != null ? variable.getDefinition() : (variable.getDeclarations() != null && variable.getDeclarations().length > 0 ? variable.getDeclarations()[0] : data.fAST);
            CPPSemantics.pushLookupPoint(lookupPoint);
            try {
                variable.getType();
                variable.getInitialValue();
            }
            finally {
                CPPSemantics.popLookupPoint();
            }
        }
        this.fStatistics.fResolutionTime = (int)((long)this.fStatistics.fResolutionTime + (System.currentTimeMillis() - start));
    }

    private boolean isVariableIndexed(ICPPVariable variable) {
        if (variable instanceof ICPPField) {
            return true;
        }
        IBinding owner = variable.getOwner();
        if (owner == null || owner instanceof ICPPNamespace) {
            return true;
        }
        return owner instanceof ICPPFunction && ((ICPPFunction)owner).isConstexpr();
    }

    @Override
    public int process(IASTTranslationUnit ast, final IIndexSymbols symbols) throws CoreException {
        if (!(symbols instanceof Data)) {
            CCorePlugin.log(4, "Default processor must receive expected Data type");
            return 0;
        }
        int unresolvedIncludes = 0;
        Data data = (Data)symbols;
        Map<IASTPreprocessorIncludeStatement, Symbols> symbolMap = data.fSymbolMap;
        IASTPreprocessorStatement[] stmts = ast.getAllPreprocessorStatements();
        IASTPreprocessorStatement[] iASTPreprocessorStatementArray = stmts;
        int n = stmts.length;
        int n2 = 0;
        while (n2 < n) {
            IASTFileLocation sourceLoc;
            IASTPreprocessorStatement stmt = iASTPreprocessorStatementArray[n2];
            if (stmt instanceof IASTPreprocessorIncludeStatement) {
                IASTPreprocessorIncludeStatement include = (IASTPreprocessorIncludeStatement)stmt;
                IASTFileLocation astLoc = include.getFileLocation();
                IASTPreprocessorIncludeStatement owner = astLoc.getContextInclusionStatement();
                boolean updateSource = symbolMap.containsKey(owner);
                if (updateSource) {
                    symbols.add(owner, include);
                }
                if (include.isActive()) {
                    if (!include.isResolved()) {
                        ++unresolvedIncludes;
                    } else if (updateSource && symbolMap.containsKey(include)) {
                        data.fContextIncludes.add(include);
                    }
                }
            } else if (stmt.isActive() && (stmt instanceof IASTPreprocessorUndefStatement || stmt instanceof IASTPreprocessorMacroDefinition) && (sourceLoc = stmt.getFileLocation()) != null) {
                IASTPreprocessorIncludeStatement owner = sourceLoc.getContextInclusionStatement();
                symbols.add(owner, stmt);
            }
            ++n2;
        }
        IndexerASTVisitor visitor = new IndexerASTVisitor((this.fSkipReferences & SKIP_IMPLICIT_REFERENCES) == 0){
            private int cancelationCheckThrottler;

            @Override
            public void visit(IASTName name, IASTName caller) {
                IASTFileLocation nameLoc;
                this.checkForCancellation();
                if (PDOMWriter.this.fSkipReferences == SKIP_ALL_REFERENCES && name.isReference() && !PDOMWriter.this.isRequiredReference(name)) {
                    return;
                }
                if ((name = PDOMASTAdapter.getAdapterIfAnonymous(name)) != null && (nameLoc = name.getFileLocation()) != null) {
                    IASTPreprocessorIncludeStatement owner = nameLoc.getContextInclusionStatement();
                    symbols.add(owner, name, caller);
                }
            }

            private void checkForCancellation() {
                if (this.cancelationCheckThrottler <= 0) {
                    if (PDOMWriter.this.fCancelState.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    this.cancelationCheckThrottler = 100;
                } else {
                    --this.cancelationCheckThrottler;
                }
            }
        };
        CPPSemantics.pushLookupPoint(ast);
        try {
            ast.accept(visitor);
        }
        finally {
            CPPSemantics.popLookupPoint();
        }
        if ((this.fSkipReferences & SKIP_MACRO_REFERENCES) == 0) {
            IndexerASTVisitor.Definition definitionTree = visitor.getDefinitionTree();
            LocationMap lm = (LocationMap)ast.getAdapter(LocationMap.class);
            if (lm != null) {
                IASTName[] refs;
                IASTName[] iASTNameArray = refs = lm.getMacroReferences();
                int n3 = refs.length;
                int n4 = 0;
                while (n4 < n3) {
                    IASTName name = iASTNameArray[n4];
                    IASTFileLocation nameLoc = name.getFileLocation();
                    if (nameLoc != null) {
                        IASTPreprocessorIncludeStatement owner = nameLoc.getContextInclusionStatement();
                        IASTName enclosingDefinition = definitionTree.search(nameLoc.getNodeOffset(), nameLoc.getNodeLength());
                        symbols.add(owner, name, enclosingDefinition);
                    }
                    ++n4;
                }
            }
        }
        this.fStatistics.fUnresolvedIncludesCount += unresolvedIncludes;
        this.fStatistics.fPreprocessorProblemCount += ast.getPreprocessorProblemsCount() - unresolvedIncludes;
        if (this.fShowScannerProblems || this.fShowInclusionProblems) {
            IASTProblem[] scannerProblems;
            boolean reportAll = this.fShowScannerProblems && this.fShowInclusionProblems;
            IASTProblem[] iASTProblemArray = scannerProblems = ast.getPreprocessorProblems();
            int n5 = scannerProblems.length;
            int n6 = 0;
            while (n6 < n5) {
                IASTProblem problem = iASTProblemArray[n6];
                if (reportAll || problem.getID() == 0x2000002 == this.fShowInclusionProblems) {
                    this.reportProblem(problem);
                }
                ++n6;
            }
        }
        List<IASTProblem> problems = visitor.getProblems();
        this.fStatistics.fSyntaxProblemsCount += problems.size();
        if (this.fShowSyntaxProblems) {
            for (IASTProblem problem : problems) {
                this.reportProblem(problem);
            }
        }
        return ast.getLinkage().getLinkageID();
    }

    protected final boolean isRequiredReference(IASTName name) {
        IASTNode parentNode = name.getParent();
        if (parentNode instanceof ICPPASTQualifiedName) {
            if (name != ((ICPPASTQualifiedName)parentNode).getLastName()) {
                return false;
            }
            parentNode = parentNode.getParent();
        }
        if (parentNode instanceof ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier) {
            return true;
        }
        if (parentNode instanceof IASTDeclSpecifier) {
            IASTDeclSpecifier ds = (IASTDeclSpecifier)parentNode;
            return ds.getStorageClass() == 1;
        }
        return parentNode instanceof ICPPASTUsingDirective;
    }

    private boolean isTypeReferenceBinding(IBinding binding) {
        return binding instanceof ICompositeType || binding instanceof IEnumeration || binding instanceof ITypedef || binding instanceof ICPPNamespace || binding instanceof ICPPNamespaceAlias || binding instanceof ICPPClassTemplate;
    }

    private IIndexFragmentFile storeFileInIndex(Data data, FileInAST astFile, int storageLinkageID, YieldableIndexLock lock, IProgressMonitor monitor) throws CoreException, FailedToReAcquireLockException {
        IWritableIndex index = data.fIndex;
        FileContentKey fileKey = astFile.fileContentKey;
        IASTPreprocessorIncludeStatement owner = astFile.includeStatement;
        IIndexFileLocation location = fileKey.getLocation();
        ISignificantMacros significantMacros = fileKey.getSignificantMacros();
        IIndexFragmentFile oldFile = index.getWritableFile(storageLinkageID, location, significantMacros);
        IIndexFragmentFile file = index.addUncommittedFile(storageLinkageID, location, significantMacros);
        boolean hasLock = true;
        try {
            try {
                Symbols lists;
                String headerKey;
                String replacementHeader;
                boolean pragmaOnce = owner != null ? owner.hasPragmaOnceSemantics() : data.fAST.hasPragmaOnceSemantics();
                file.setPragmaOnceSemantics(pragmaOnce);
                if (data.fReplacementHeaders != null && (replacementHeader = data.fReplacementHeaders.get(headerKey = IndexLocationFactory.getAbsolutePath(location).toOSString())) != null) {
                    file.setReplacementHeader(replacementHeader);
                }
                if ((lists = data.fSymbolMap.get(owner)) != null) {
                    IASTName[][] names;
                    IASTPreprocessorStatement[] macros = lists.fMacros.toArray(new IASTPreprocessorStatement[lists.fMacros.size()]);
                    IASTName[][] iASTNameArray = names = (IASTName[][])lists.fNames.toArray((T[])new IASTName[lists.fNames.size()][]);
                    int n = names.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IASTName[] name2 = iASTNameArray[n2];
                        IASTName name = name2[0];
                        if (name != null) {
                            ASTInternal.setFullyResolved(name.getBinding(), true);
                        }
                        ++n2;
                    }
                    ArrayList<IWritableIndex.IncludeInformation> includeInfos = new ArrayList<IWritableIndex.IncludeInformation>();
                    int i = 0;
                    while (i < lists.fIncludes.size()) {
                        IASTPreprocessorIncludeStatement stmt = lists.fIncludes.get(i);
                        if (!stmt.isResolved()) {
                            includeInfos.add(new IWritableIndex.IncludeInformation(stmt, null, ISignificantMacros.NONE, false));
                        } else {
                            IIndexFileLocation targetLoc = this.fResolver.resolveASTPath(stmt.getPath());
                            ISignificantMacros mainSig = stmt.getSignificantMacros();
                            ISignificantMacros[] iSignificantMacrosArray = stmt.getLoadedVersions();
                            int n3 = iSignificantMacrosArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                ISignificantMacros sig = iSignificantMacrosArray[n4];
                                if (!sig.equals(mainSig)) {
                                    includeInfos.add(new IWritableIndex.IncludeInformation(stmt, targetLoc, sig, false));
                                }
                                ++n4;
                            }
                            boolean isContext = stmt.isActive() && stmt.isResolved() && (data.fContextIncludes.contains(stmt) || this.isContextFor(oldFile, stmt));
                            includeInfos.add(new IWritableIndex.IncludeInformation(stmt, targetLoc, mainSig, isContext));
                        }
                        ++i;
                    }
                    IWritableIndex.IncludeInformation[] includeInfoArray = includeInfos.toArray(new IWritableIndex.IncludeInformation[includeInfos.size()]);
                    index.setFileContent(file, storageLinkageID, includeInfoArray, macros, names, this.fResolver, lock);
                }
                file.setTimestamp(astFile.hasError ? 0L : astFile.timestamp);
                file.setSourceReadTime(astFile.sourceReadTime);
                file.setSizeAndEncodingHashcode(this.computeFileSizeAndEncodingHashcode(astFile.fileSize, location));
                file.setContentsHash(astFile.contentsHash);
                file = index.commitUncommittedFile();
            }
            catch (FailedToReAcquireLockException e) {
                hasLock = false;
                throw e;
            }
        }
        finally {
            block19: {
                try {
                    index.clearUncommittedFile();
                }
                catch (Throwable e) {
                    if (!hasLock) break block19;
                    throw e;
                }
            }
        }
        return file;
    }

    protected int computeFileSizeAndEncodingHashcode(IIndexFileLocation location) {
        return this.computeFileSizeAndEncodingHashcode((int)this.fResolver.getFileSize(location), location);
    }

    private int computeFileSizeAndEncodingHashcode(long size, IIndexFileLocation location) {
        return (int)size + 31 * this.fResolver.getEncoding(location).hashCode();
    }

    private boolean isContextFor(IIndexFragmentFile oldFile, IASTPreprocessorIncludeStatement stmt) throws CoreException {
        IIndexInclude ctxInclude;
        IIndexFile target = stmt.getImportedIndexFile();
        return oldFile != null && target != null && (ctxInclude = target.getParsedInContext()) != null && oldFile.equals(ctxInclude.getIncludedBy());
    }

    protected abstract void reportFileWrittenToIndex(FileInAST var1, IIndexFragmentFile var2) throws CoreException;

    private String getLocationInfo(String filename, int lineNumber) {
        return " at " + filename + "(" + lineNumber + ")";
    }

    private void reportProblem(IProblemBinding problem) {
        String msg = "Indexer: unresolved name" + this.getLocationInfo(problem.getFileName(), problem.getLineNumber());
        String pmsg = problem.getMessage();
        if (pmsg != null && pmsg.length() > 0) {
            msg = msg + "; " + problem.getMessage();
        }
        this.trace(msg);
    }

    private void reportProblem(IASTProblem problem) {
        String msg = "Indexer: " + problem.getMessageWithLocation();
        this.trace(msg);
    }

    protected void reportException(Throwable th) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        th.printStackTrace(pw);
        String msg = "Indexer: exception: " + sw.toString();
        this.trace(msg);
    }

    protected void trace(String message) {
        System.out.println(message);
    }

    protected IStatus createStatus(String msg) {
        return CCorePlugin.createStatus(msg);
    }

    protected IStatus createStatus(String msg, Throwable e) {
        return CCorePlugin.createStatus(msg, e);
    }

    public void cancel() {
        this.fCancelState.setCanceled(true);
    }

    protected static class Data
    implements IIndexSymbols {
        final IASTTranslationUnit fAST;
        final FileInAST[] fSelectedFiles;
        final IWritableIndex fIndex;
        final Map<IASTPreprocessorIncludeStatement, Symbols> fSymbolMap = new HashMap<IASTPreprocessorIncludeStatement, Symbols>();
        final Set<IASTPreprocessorIncludeStatement> fContextIncludes = new HashSet<IASTPreprocessorIncludeStatement>();
        final List<IStatus> fStatuses = new ArrayList<IStatus>();
        Map<String, String> fReplacementHeaders;

        public Data(IASTTranslationUnit ast, FileInAST[] selectedFiles, IWritableIndex index) {
            this.fAST = ast;
            this.fSelectedFiles = selectedFiles;
            this.fIndex = index;
            FileInAST[] fileInASTArray = selectedFiles;
            int n = selectedFiles.length;
            int n2 = 0;
            while (n2 < n) {
                FileInAST file = fileInASTArray[n2];
                this.fSymbolMap.put(file.includeStatement, new Symbols());
                ++n2;
            }
        }

        @Override
        public boolean isEmpty() {
            if (this.fSymbolMap.isEmpty()) {
                return true;
            }
            for (Symbols symbols : this.fSymbolMap.values()) {
                if (symbols.fNames.isEmpty() && symbols.fIncludes.isEmpty() && symbols.fMacros.isEmpty()) continue;
                return false;
            }
            return true;
        }

        @Override
        public void add(IASTPreprocessorIncludeStatement owner, IASTName name, IASTName caller) {
            Symbols lists = this.fSymbolMap.get(owner);
            if (lists != null) {
                lists.fNames.add(new IASTName[]{name, caller});
            }
        }

        @Override
        public void add(IASTPreprocessorIncludeStatement owner, IASTPreprocessorIncludeStatement thing) {
            Symbols lists = this.fSymbolMap.get(owner);
            if (lists != null) {
                lists.fIncludes.add(thing);
            }
        }

        @Override
        public void add(IASTPreprocessorIncludeStatement owner, IASTPreprocessorStatement thing) {
            Symbols lists = this.fSymbolMap.get(owner);
            if (lists != null) {
                lists.fMacros.add(thing);
            }
        }
    }

    public static class FileContext {
        final IIndexFragmentFile fContext;
        final IIndexFragmentFile fOldFile;
        IIndexFragmentFile fNewFile;
        public boolean fLostPragmaOnceSemantics;

        public FileContext(IIndexFragmentFile context, IIndexFragmentFile oldFile) {
            this.fContext = context;
            this.fOldFile = oldFile;
            this.fNewFile = null;
        }
    }

    public static class FileInAST {
        final IASTPreprocessorIncludeStatement includeStatement;
        final FileContentKey fileContentKey;
        final long timestamp;
        final long fileSize;
        final long contentsHash;
        final long sourceReadTime;
        final boolean hasError;

        public FileInAST(IASTPreprocessorIncludeStatement includeStmt, FileContentKey key) {
            this.includeStatement = includeStmt;
            this.fileContentKey = key;
            this.timestamp = includeStmt.getIncludedFileTimestamp();
            this.fileSize = includeStmt.getIncludedFileSize();
            this.contentsHash = includeStmt.getIncludedFileContentsHash();
            this.sourceReadTime = includeStmt.getIncludedFileReadTime();
            this.hasError = includeStmt.isErrorInIncludedFile();
        }

        public FileInAST(FileContentKey key, FileContent codeReader) {
            this.includeStatement = null;
            this.fileContentKey = key;
            this.timestamp = codeReader.getTimestamp();
            this.fileSize = codeReader.getFileSize();
            this.contentsHash = codeReader.getContentsHash();
            this.sourceReadTime = codeReader.getReadTime();
            this.hasError = codeReader.hasError();
        }

        public String toString() {
            return this.fileContentKey.toString();
        }
    }

    private static class Symbols {
        final ArrayList<IASTName[]> fNames = new ArrayList();
        final ArrayList<IASTPreprocessorStatement> fMacros = new ArrayList();
        final ArrayList<IASTPreprocessorIncludeStatement> fIncludes = new ArrayList();

        private Symbols() {
        }
    }
}

