/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPExecution;
import org.eclipse.cdt.internal.core.dom.parser.cpp.InstantiationContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ActivationRecord;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecBreak;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecIncomplete;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecReturn;
import org.eclipse.core.runtime.CoreException;

public class ExecDo
implements ICPPExecution {
    private final ICPPEvaluation conditionEval;
    private final ICPPExecution bodyExec;

    public ExecDo(ICPPEvaluation conditionEval, ICPPExecution bodyExec) {
        this.conditionEval = conditionEval;
        this.bodyExec = bodyExec;
    }

    @Override
    public ICPPExecution executeForFunctionCall(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        ICPPExecution result;
        do {
            if (context.getStepsPerformed() >= 1024) {
                return ExecIncomplete.INSTANCE;
            }
            result = EvalUtil.executeStatement(this.bodyExec, record, context);
            if (!(result instanceof ExecReturn)) continue;
            return result;
        } while (!(result instanceof ExecBreak) && EvalUtil.conditionExprSatisfied(this.conditionEval, record, context));
        return null;
    }

    @Override
    public ICPPExecution instantiate(InstantiationContext context, int maxDepth) {
        ICPPEvaluation newConditionEval = this.conditionEval.instantiate(context, maxDepth);
        ICPPExecution newBodyExec = this.bodyExec.instantiate(context, maxDepth);
        if (newConditionEval == this.conditionEval && newBodyExec == this.bodyExec) {
            return this;
        }
        return new ExecDo(newConditionEval, newBodyExec);
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        buffer.putShort((short)13);
        buffer.marshalEvaluation(this.conditionEval, includeValue);
        buffer.marshalExecution(this.bodyExec, includeValue);
    }

    public static ICPPExecution unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        ICPPEvaluation conditionEval = buffer.unmarshalEvaluation();
        ICPPExecution bodyExec = buffer.unmarshalExecution();
        return new ExecDo(conditionEval, bodyExec);
    }
}

