/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.EScopeKind;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameterPackType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDeclaration;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPClassSpecializationScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.InstantiationContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class AbstractCPPClassSpecializationScope
implements ICPPClassSpecializationScope {
    private final ICPPClassSpecialization specialClass;
    private volatile ICPPBase[] fBases;
    private volatile ICPPMethod[] ownInheritedConstructors;
    private final ThreadLocal<Boolean> fComputingBases = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public AbstractCPPClassSpecializationScope(ICPPClassSpecialization specialization) {
        this.specialClass = specialization;
    }

    @Override
    public ICPPClassType getOriginalClassType() {
        return this.specialClass.getSpecializedBinding();
    }

    @Override
    public final IBinding getBinding(IASTName name, boolean resolve) {
        return this.getBinding(name, resolve, IIndexFileSet.EMPTY);
    }

    @Override
    public final IBinding[] getBindings(IASTName name, boolean resolve, boolean prefix) {
        return this.getBindings(new IScope.ScopeLookupData(name, resolve, prefix));
    }

    @Override
    public IBinding getBinding(IASTName name, boolean resolve, IIndexFileSet fileSet) {
        IBinding[] bindings;
        char[] c = name.getLookupKey();
        if (CharArrayUtils.equals(c, this.specialClass.getNameCharArray()) && !CPPClassScope.shallReturnConstructors(name, false)) {
            return this.specialClass;
        }
        ICPPClassType specialized = this.specialClass.getSpecializedBinding();
        IScope classScope = specialized.getCompositeScope();
        IBinding[] iBindingArray = bindings = classScope != null ? classScope.getBindings(new IScope.ScopeLookupData(name, resolve, false)) : null;
        if (bindings == null) {
            return null;
        }
        Object[] specs = IBinding.EMPTY_BINDING_ARRAY;
        CPPSemantics.pushLookupPoint(name);
        try {
            IBinding[] iBindingArray2 = bindings;
            int n = bindings.length;
            int n2 = 0;
            while (n2 < n) {
                IBinding binding = iBindingArray2[n2];
                specs = ArrayUtil.append(specs, this.specialClass.specializeMember(binding));
                ++n2;
            }
        }
        finally {
            CPPSemantics.popLookupPoint();
        }
        specs = ArrayUtil.trim(specs);
        return CPPSemantics.resolveAmbiguities(name, specs);
    }

    @Override
    @Deprecated
    public final IBinding[] getBindings(IASTName name, boolean resolve, boolean prefixLookup, IIndexFileSet fileSet) {
        return this.getBindings(new IScope.ScopeLookupData(name, resolve, prefixLookup));
    }

    @Override
    public final IBinding[] getBindings(IScope.ScopeLookupData lookup) {
        ICPPClassType specialized = this.specialClass.getSpecializedBinding();
        IScope classScope = specialized.getCompositeScope();
        if (classScope == null) {
            return IBinding.EMPTY_BINDING_ARRAY;
        }
        IBinding[] bindings = classScope.getBindings(lookup);
        IBinding[] result = IBinding.EMPTY_BINDING_ARRAY;
        if (bindings == null) {
            return result;
        }
        int n = 0;
        IBinding[] iBindingArray = bindings;
        int n2 = bindings.length;
        int n3 = 0;
        while (n3 < n2) {
            IBinding binding = iBindingArray[n3];
            binding = binding == specialized || binding instanceof ICPPClassType && AbstractCPPClassSpecializationScope.areSameTypesModuloPartialSpecialization(specialized, (IType)((Object)binding)) ? this.specialClass : this.specialClass.specializeMember(binding);
            if (binding != null) {
                result = ArrayUtil.appendAt(result, n++, binding);
            }
            ++n3;
        }
        return ArrayUtil.trim(result, n);
    }

    private static boolean areSameTypesModuloPartialSpecialization(IType type1, IType type2) {
        while (type1 instanceof ICPPClassTemplatePartialSpecialization) {
            type1 = ((ICPPClassTemplatePartialSpecialization)type1).getPrimaryClassTemplate();
        }
        while (type2 instanceof ICPPClassTemplatePartialSpecialization) {
            type2 = ((ICPPClassTemplatePartialSpecialization)type2).getPrimaryClassTemplate();
        }
        return type1.isSameType(type2);
    }

    @Override
    public ICPPClassSpecialization getClassType() {
        return this.specialClass;
    }

    @Override
    public ICPPBase[] getBases() {
        block16: {
            if (this.fBases == null) {
                if (this.fComputingBases.get().booleanValue()) {
                    return ICPPBase.EMPTY_BASE_ARRAY;
                }
                this.fComputingBases.set(true);
                try {
                    ICPPBase[] result = ICPPBase.EMPTY_BASE_ARRAY;
                    ICPPBase[] bases = this.specialClass.getSpecializedBinding().getBases();
                    if (bases.length == 0) {
                        this.fBases = bases;
                        break block16;
                    }
                    ICPPTemplateParameterMap tpmap = this.specialClass.getTemplateParameterMap();
                    ICPPBase[] iCPPBaseArray = bases;
                    int n = bases.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICPPBase base = iCPPBaseArray[n2];
                        IType baseType = base.getBaseClassType();
                        if (baseType instanceof ICPPParameterPackType) {
                            IType[] specClasses = CPPTemplates.instantiateTypes(new IType[]{baseType}, new InstantiationContext(tpmap, this.specialClass));
                            if (specClasses.length == 1 && specClasses[0] instanceof ICPPParameterPackType) {
                                result = ArrayUtil.append(result, base);
                            } else {
                                IType[] iTypeArray = specClasses;
                                int n3 = specClasses.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    IType specClass = iTypeArray[n4];
                                    ICPPBase specBase = base.clone();
                                    if ((specClass = SemanticUtil.getUltimateType(specClass, false)) instanceof IBinding && !(specClass instanceof IProblemBinding)) {
                                        specBase.setBaseClass((IBinding)((Object)specClass));
                                        result = ArrayUtil.append(result, specBase);
                                    }
                                    ++n4;
                                }
                            }
                        } else if (baseType != null) {
                            ICPPBase specBase = base.clone();
                            ICPPClassSpecialization specializationContext = this.specialClass;
                            IBinding owner = this.specialClass.getOwner();
                            if (owner instanceof ICPPClassSpecialization) {
                                specializationContext = (ICPPClassSpecialization)owner;
                            }
                            IType specClass = CPPTemplates.instantiateType(baseType, new InstantiationContext(tpmap, specializationContext));
                            if ((specClass = SemanticUtil.getUltimateType(specClass, false)) instanceof IBinding && !(specClass instanceof IProblemBinding)) {
                                specBase.setBaseClass((IBinding)((Object)specClass));
                            }
                            result = ArrayUtil.append(result, specBase);
                        }
                        ++n2;
                    }
                    result = ArrayUtil.trim(result);
                    this.fBases = result;
                    ICPPBase[] iCPPBaseArray2 = result;
                    return iCPPBaseArray2;
                }
                finally {
                    this.fComputingBases.set(false);
                }
            }
        }
        return this.fBases;
    }

    private <T extends IBinding> T[] specializeMembers(T[] array) {
        if (array == null || array.length == 0) {
            return array;
        }
        IBinding[] newArray = (IBinding[])array.clone();
        int i = 0;
        while (i < newArray.length) {
            IBinding specializedMember;
            newArray[i] = specializedMember = this.specialClass.specializeMember((IBinding)array[i]);
            ++i;
        }
        return newArray;
    }

    @Override
    public ICPPField[] getDeclaredFields() {
        IBinding[] fields = this.specialClass.getSpecializedBinding().getDeclaredFields();
        return (ICPPField[])this.specializeMembers(fields);
    }

    @Override
    public ICPPMethod[] getImplicitMethods() {
        ICPPClassType origClass = this.specialClass.getSpecializedBinding();
        IBinding[] methods = ClassTypeHelper.getImplicitMethods(origClass);
        ICPPMethod[] specializedMembers = (ICPPMethod[])this.specializeMembers(methods);
        Object[] inheritedConstructors = this.getOwnInheritedConstructors();
        return ArrayUtil.addAll(specializedMembers, inheritedConstructors);
    }

    @Override
    public IName getScopeName() {
        if (this.specialClass instanceof ICPPInternalBinding) {
            return (IASTName)((ICPPInternalBinding)((Object)this.specialClass)).getDefinition();
        }
        return null;
    }

    @Override
    public ICPPConstructor[] getConstructors() {
        IBinding[] ctors = this.specialClass.getSpecializedBinding().getConstructors();
        ICPPConstructor[] specializedCtors = (ICPPConstructor[])this.specializeMembers(ctors);
        Object[] inheritedConstructors = this.getOwnInheritedConstructors(specializedCtors);
        return ArrayUtil.addAll(specializedCtors, inheritedConstructors);
    }

    private ICPPMethod[] getOwnInheritedConstructors(ICPPConstructor[] existingConstructors) {
        if (this.ownInheritedConstructors == null) {
            if (!this.hasInheritedConstructorsSources()) {
                return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
            }
            IType[][] existingConstructorParamTypes = new IType[existingConstructors.length][];
            int i = 0;
            while (i < existingConstructors.length) {
                ICPPParameter[] params = existingConstructors[i].getParameters();
                IType[] types = new IType[params.length];
                int j = 0;
                while (j < params.length) {
                    types[j] = params[j].getType();
                    ++j;
                }
                existingConstructorParamTypes[i] = types;
                ++i;
            }
            ICPPConstructor[] constructors = ClassTypeHelper.getInheritedConstructors(this, this.getBases(), existingConstructorParamTypes);
            this.ownInheritedConstructors = constructors;
        }
        return this.ownInheritedConstructors;
    }

    private ICPPMethod[] getOwnInheritedConstructors() {
        if (this.ownInheritedConstructors != null) {
            return this.ownInheritedConstructors;
        }
        IBinding[] ctors = this.specialClass.getSpecializedBinding().getConstructors();
        ICPPConstructor[] specializedCtors = (ICPPConstructor[])this.specializeMembers(ctors);
        return this.getOwnInheritedConstructors(specializedCtors);
    }

    private boolean hasInheritedConstructorsSources() {
        ICPPBase[] iCPPBaseArray = this.getBases();
        int n = iCPPBaseArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPBase base = iCPPBaseArray[n2];
            if (base.isInheritedConstructorsSource()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public ICPPMethod[] getDeclaredMethods() {
        IBinding[] bindings = this.specialClass.getSpecializedBinding().getDeclaredMethods();
        return (ICPPMethod[])this.specializeMembers(bindings);
    }

    @Override
    public ICPPClassType[] getNestedClasses() {
        IBinding[] bindings = this.specialClass.getSpecializedBinding().getNestedClasses();
        return (ICPPClassType[])this.specializeMembers(bindings);
    }

    @Override
    public ICPPUsingDeclaration[] getUsingDeclarations() {
        IBinding[] bindings = this.specialClass.getSpecializedBinding().getUsingDeclarations();
        return (ICPPUsingDeclaration[])this.specializeMembers(bindings);
    }

    @Override
    public IBinding[] getFriends() {
        IBinding[] friends = this.specialClass.getSpecializedBinding().getFriends();
        return this.specializeMembers(friends);
    }

    @Override
    public IScope getParent() throws DOMException {
        IBinding binding = this.specialClass.getOwner();
        if (binding instanceof ICPPClassType) {
            return ((ICPPClassType)binding).getCompositeScope();
        }
        if (binding instanceof ICPPNamespace) {
            return ((ICPPNamespace)binding).getNamespaceScope();
        }
        return this.getOriginalClassType().getScope();
    }

    @Override
    public IBinding[] find(String name, IASTTranslationUnit tu) {
        return this.find(name);
    }

    @Override
    public IBinding[] find(String name) {
        return CPPSemantics.findBindings((IScope)this, name, false);
    }

    @Override
    public EScopeKind getKind() {
        return EScopeKind.eClassType;
    }

    public String toString() {
        IName name = this.getScopeName();
        return name != null ? name.toString() : String.valueOf(this.specialClass);
    }

    public boolean equals(Object other) {
        if (other instanceof ICPPClassSpecializationScope) {
            return this.getClassType().equals(((ICPPClassSpecializationScope)other).getClassType());
        }
        return false;
    }

    public int hashCode() {
        return this.specialClass.hashCode();
    }
}

