/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.webapp;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphArrow;
import org.eclipse.tracecompass.traceeventlogger.LogUtils;

public class TimeGraphArrowSerializer
extends StdSerializer<ITimeGraphArrow> {
    private static final long serialVersionUID = -8967973449240455869L;
    private static final @NonNull Logger LOGGER = TraceCompassLog.getLogger(TimeGraphArrowSerializer.class);

    protected TimeGraphArrowSerializer() {
        super(ITimeGraphArrow.class);
    }

    public void serialize(@NonNull ITimeGraphArrow value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (LogUtils.ScopeLog sl = new LogUtils.ScopeLog(LOGGER, Level.FINE, "TimeGraphArrowSerialize", new Object[0]);){
            gen.writeStartObject();
            gen.writeNumberField("start", value.getStartTime());
            gen.writeNumberField("end", value.getStartTime() + value.getDuration());
            gen.writeNumberField("sourceId", value.getSourceId());
            gen.writeNumberField("targetId", value.getDestinationId());
            if (value.getStyle() != null) {
                gen.writeObjectField("style", (Object)value.getStyle());
            }
            gen.writeEndObject();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

