/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Map;
import java.util.UUID;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.IndexingStatus;

@Schema(description="Trace model")
public interface Trace {
    @Schema(description="User defined name for the trace", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getName();

    @Schema(description="Path to the trace on the server's file system", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getPath();

    @JsonProperty(value="UUID")
    @Schema(description="The trace's unique identifier", requiredMode=Schema.RequiredMode.REQUIRED)
    public UUID getUUID();

    @Schema(description="Current number of indexed events in the trace", requiredMode=Schema.RequiredMode.REQUIRED)
    public long getNbEvents();

    @Schema(description="The trace's start time", requiredMode=Schema.RequiredMode.REQUIRED)
    public long getStart();

    @Schema(description="The trace's end time", requiredMode=Schema.RequiredMode.REQUIRED)
    public long getEnd();

    @Schema(description="The trace's properties", requiredMode=Schema.RequiredMode.REQUIRED)
    public Map<String, String> getProperties();

    @Schema(description="Status of the trace indexing", requiredMode=Schema.RequiredMode.REQUIRED)
    public IndexingStatus getIndexingStatus();
}

