/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.traceeventlogger.beans;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.tracecompass.traceeventlogger.beans.TraceEventLoggerBean;

public final class TraceEventLoggerManager {
    private final Map<String, TraceEventLoggerBean> fCounters = new LinkedHashMap<String, TraceEventLoggerBean>();
    private static TraceEventLoggerManager sInstance = null;
    private boolean fEnabled = false;

    private TraceEventLoggerManager() {
        String loggingProperty = System.getProperty("enableMonitoring", "false");
        this.fEnabled = Boolean.parseBoolean(loggingProperty);
    }

    public synchronized void update(String label, long value) {
        if (this.fEnabled) {
            this.fCounters.computeIfAbsent(label, TraceEventLoggerBean::new).accept(value);
        }
    }

    public static synchronized TraceEventLoggerManager getInstance() {
        TraceEventLoggerManager instance = sInstance;
        if (instance == null) {
            sInstance = instance = new TraceEventLoggerManager();
        }
        return instance;
    }
}

