/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.traceeventlogger.beans;

import java.lang.management.ManagementFactory;
import java.util.LongSummaryStatistics;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import org.eclipse.tracecompass.traceeventlogger.beans.ITraceEventLoggerBean;

public final class TraceEventLoggerBean
extends NotificationBroadcasterSupport
implements ITraceEventLoggerBean {
    private final LongSummaryStatistics fStats = new LongSummaryStatistics();
    private final String fLabel;

    public TraceEventLoggerBean(String label) {
        this.fLabel = label;
        Logger.getLogger("javax.management").setLevel(Level.FINE);
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        String beanName = "org.eclipse.tracecompass.log:type=TraceEventLoggerBean,name=" + label.replace(':', '-');
        try {
            ObjectName name = new ObjectName(beanName);
            mbs.registerMBean(this, name);
        }
        catch (JMException e) {
            Logger.getAnonymousLogger().log(Level.WARNING, "Cannot create bean", e);
        }
    }

    @Override
    public String getObservedElementName() {
        return this.fLabel;
    }

    @Override
    public double getMeanTime() {
        return this.fStats.getAverage();
    }

    @Override
    public long getMinTime() {
        return this.fStats.getMin();
    }

    @Override
    public long getMaxTime() {
        return this.fStats.getMax();
    }

    @Override
    public long getTotalTime() {
        return this.fStats.getSum();
    }

    @Override
    public long getCount() {
        return this.fStats.getCount();
    }

    public void accept(long value) {
        this.fStats.accept(value);
    }
}

