/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.kernelmemoryusage;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelTidAspect;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.Activator;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.StateSystemBuilderUtils;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class KernelMemoryStateProvider
extends AbstractTmfStateProvider {
    public static final String OTHER_TID = "other";
    private static final int VERSION = 2;
    private static final int PAGE_SIZE = 4096;
    private static final long MAX_ORDER = 62L;
    private IKernelAnalysisEventLayout fLayout;

    public KernelMemoryStateProvider(@NonNull ITmfTrace trace, IKernelAnalysisEventLayout layout) {
        super(trace, "Kernel:Memory");
        this.fLayout = layout;
    }

    public int getVersion() {
        return 2;
    }

    public ITmfStateProvider getNewInstance() {
        return new KernelMemoryStateProvider(this.getTrace(), this.fLayout);
    }

    protected void eventHandle(@NonNull ITmfEvent event) {
        long inc;
        String name = event.getName();
        if (name.equals(this.fLayout.eventKmemPageAlloc())) {
            inc = 4096L;
        } else if (name.equals(this.fLayout.eventKmemPageFree())) {
            inc = -4096L;
        } else {
            return;
        }
        try {
            long previousLowest;
            Long value;
            String fieldOrder = this.fLayout.fieldOrder();
            if (fieldOrder != null && (value = (Long)event.getContent().getFieldValue(Long.class, new String[]{fieldOrder})) != null) {
                if (value > 62L || value < 0L) {
                    Activator.getDefault().logWarning("Order of alloc is outside of acceptable range : " + String.valueOf(value));
                    return;
                }
                inc <<= (int)value.longValue();
            }
            ITmfStateSystemBuilder ss = (ITmfStateSystemBuilder)NonNullUtils.checkNotNull((Object)this.getStateSystemBuilder());
            long ts = event.getTimestamp().toNanos();
            Integer tidField = KernelTidAspect.INSTANCE.resolve(event, true, (IProgressMonitor)new NullProgressMonitor());
            String tid = tidField == null ? OTHER_TID : tidField.toString();
            int tidQuark = ss.getQuarkAbsoluteAndAdd(new String[]{tid});
            StateSystemBuilderUtils.incrementAttributeLong((ITmfStateSystemBuilder)ss, (long)ts, (int)tidQuark, (long)inc);
            long currentMemoryValue = ss.queryOngoingState(tidQuark).unboxLong();
            int lowestMemoryQuark = ss.getQuarkRelativeAndAdd(tidQuark, new String[]{"lowestMemory"});
            ITmfStateValue lowestMemoryValue = ss.queryOngoingState(lowestMemoryQuark);
            long l = previousLowest = lowestMemoryValue.isNull() ? 0L : lowestMemoryValue.unboxLong();
            if (previousLowest > currentMemoryValue) {
                ss.modifyAttribute(ts, (Object)currentMemoryValue, lowestMemoryQuark);
            }
        }
        catch (InterruptedException e) {
            Activator.getDefault().logError(String.valueOf(e.getMessage()), e);
        }
    }
}

