/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.db;

import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.core.runtime.CoreException;

public class ListItem {
    protected final Database db;
    protected final long record;
    protected static final int NEXT = 0;
    protected static final int PREV = 4;
    protected static final int ITEM = 8;
    protected static final int RECORD_SIZE = 12;

    public ListItem(Database db, long record) {
        this.db = db;
        this.record = record;
    }

    public ListItem(Database db) throws CoreException {
        this.db = db;
        this.record = db.malloc(12);
    }

    public long getRecord() {
        return this.record;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ListItem) {
            return this.record == ((ListItem)obj).record;
        }
        return false;
    }

    public void setItem(long item) throws CoreException {
        this.db.putRecPtr(this.record + 8L, item);
    }

    public long getItem() throws CoreException {
        return this.db.getRecPtr(this.record + 8L);
    }

    public void setNext(ListItem next) throws CoreException {
        this.db.putRecPtr(this.record + 0L, next.getRecord());
    }

    public ListItem getNext() throws CoreException {
        long next = this.db.getRecPtr(this.record + 0L);
        return next != 0L ? new ListItem(this.db, next) : null;
    }

    public void setPrev(ListItem prev) throws CoreException {
        this.db.putRecPtr(this.record + 4L, prev.getRecord());
    }

    public ListItem getPrev() throws CoreException {
        long prev = this.db.getRecPtr(this.record + 4L);
        return prev != 0L ? new ListItem(this.db, prev) : null;
    }

    public void delete() throws CoreException {
        this.db.free(this.record);
    }
}

