/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.InstantiationContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalPackExpansion;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SignatureBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.PlatformObject;

public abstract class CPPDependentEvaluation
extends CPPEvaluation {
    private IBinding fTemplateDefinition;
    private IScope fTemplateDefinitionScope;

    CPPDependentEvaluation(IBinding templateDefinition) {
        this.fTemplateDefinition = templateDefinition;
    }

    @Override
    public IBinding getTemplateDefinition() {
        if (this.fTemplateDefinition instanceof DeferredResolutionBinding) {
            IBinding toResolve = this.fTemplateDefinition;
            this.fTemplateDefinition = null;
            this.fTemplateDefinition = ((DeferredResolutionBinding)toResolve).resolve();
        }
        return this.fTemplateDefinition;
    }

    protected IScope getTemplateDefinitionScope() {
        IBinding templateDefinition;
        if (this.fTemplateDefinitionScope == null && (templateDefinition = this.getTemplateDefinition()) != null) {
            if (templateDefinition instanceof ICPPClassType) {
                this.fTemplateDefinitionScope = ((ICPPClassType)templateDefinition).getCompositeScope();
            }
            try {
                this.fTemplateDefinitionScope = templateDefinition.getScope();
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
        return this.fTemplateDefinitionScope;
    }

    protected static IBinding findEnclosingTemplate(IASTNode node) {
        while (node != null) {
            if (node instanceof ICPPASTTemplateDeclaration) {
                ICPPASTTemplateDeclaration templateDecl = (ICPPASTTemplateDeclaration)node;
                IASTName templateName = CPPTemplates.getTemplateName(templateDecl);
                if (templateName == null) {
                    return null;
                }
                return new DeferredResolutionBinding(templateName);
            }
            node = node.getParent();
        }
        return null;
    }

    protected void marshalTemplateDefinition(ITypeMarshalBuffer buffer) throws CoreException {
        if (!(buffer instanceof SignatureBuilder)) {
            buffer.marshalBinding(this.getTemplateDefinition());
        }
    }

    protected static ICPPEvaluation[] instantiateExpressions(ICPPEvaluation[] expressions, InstantiationContext context, int maxDepth) {
        ICPPEvaluation[] result = expressions;
        int resultShift = 0;
        int i = 0;
        while (i < expressions.length) {
            block12: {
                ICPPEvaluation newEval;
                ICPPEvaluation origEval;
                block9: {
                    block7: {
                        int packSize;
                        ICPPEvaluation pattern;
                        block11: {
                            block10: {
                                block8: {
                                    origEval = expressions[i];
                                    if (!(origEval instanceof EvalPackExpansion)) break block7;
                                    pattern = ((EvalPackExpansion)origEval).getExpansionPattern();
                                    if (pattern != null) break block8;
                                    newEval = EvalFixed.INCOMPLETE;
                                    break block9;
                                }
                                packSize = pattern.determinePackSize(context.getParameterMap());
                                if (packSize != -2 && packSize != Integer.MAX_VALUE) break block10;
                                newEval = EvalFixed.INCOMPLETE;
                                break block9;
                            }
                            if (packSize != -1) break block11;
                            newEval = origEval.instantiate(context, maxDepth);
                            break block9;
                        }
                        int shift = packSize - 1;
                        ICPPEvaluation[] newResult = new ICPPEvaluation[expressions.length + resultShift + shift];
                        System.arraycopy(result, 0, newResult, 0, i + resultShift);
                        context.setExpandPack(true);
                        int oldPackOffset = context.getPackOffset();
                        int j = 0;
                        while (j < packSize) {
                            context.setPackOffset(j);
                            newEval = pattern.instantiate(context, maxDepth);
                            if (context.isPackExpanded()) {
                                newEval = new EvalPackExpansion(newEval, newEval.getTemplateDefinition());
                                context.setPackExpanded(false);
                            }
                            newResult[i + resultShift + j] = newEval;
                            ++j;
                        }
                        context.setPackOffset(oldPackOffset);
                        context.setExpandPack(false);
                        result = newResult;
                        resultShift += shift;
                        break block12;
                    }
                    newEval = origEval.instantiate(context, maxDepth);
                }
                if (result != expressions) {
                    result[i + resultShift] = newEval;
                } else if (newEval != origEval) {
                    assert (resultShift == 0);
                    result = new ICPPEvaluation[expressions.length];
                    System.arraycopy(expressions, 0, result, 0, i);
                    result[i] = newEval;
                }
            }
            ++i;
        }
        return result;
    }

    private static class DeferredResolutionBinding
    extends PlatformObject
    implements IBinding {
        private final IASTName fName;

        public DeferredResolutionBinding(IASTName name) {
            this.fName = name;
        }

        public IBinding resolve() {
            return this.fName.resolveBinding();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public char[] getNameCharArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ILinkage getLinkage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IBinding getOwner() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IScope getScope() throws DOMException {
            throw new UnsupportedOperationException();
        }
    }
}

