/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.analysis.callsite;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.internal.tmf.core.analysis.callsite.StateSystemStringInterner;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCallsiteAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfDeviceAspect;
import org.eclipse.tracecompass.tmf.core.event.lookup.ITmfCallsite;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class CallsiteStateProvider
extends AbstractTmfStateProvider {
    public static final String ID = "org.eclipse.tracecompass.tmf.core.analysis.callsite";
    public static final String DEVICES = "Devices";
    public static final String FILES = "Files";
    public static final String LINES = "Lines";
    public static final int UNKNOWN_LINE_NO = -1;
    public static final Iterable<String> DEFAULT_CATEGORY = Arrays.asList("UNKNOWN");
    public static final String STRING_POOL = "Sources";
    private int fSourceQuark;
    private int fDevicesQuark;
    private final StateSystemStringInterner fInterner;
    private Iterable<ITmfEventAspect<?>> fCsAspects;

    public CallsiteStateProvider(ITmfTrace trace, String id, StateSystemStringInterner interner) {
        super(trace, id);
        this.fInterner = interner;
        this.fCsAspects = TmfTraceUtils.getEventAspects(trace, TmfCallsiteAspect.class);
    }

    @Override
    public int getVersion() {
        return 2;
    }

    @Override
    public void assignTargetStateSystem(ITmfStateSystemBuilder ssb) {
        super.assignTargetStateSystem(ssb);
        this.fSourceQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{STRING_POOL});
        this.fDevicesQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{DEVICES});
    }

    @Override
    protected void eventHandle(@NonNull ITmfEvent event) {
        ITmfStateSystemBuilder ssb = Objects.requireNonNull(this.getStateSystemBuilder());
        List callsites = null;
        for (ITmfEventAspect<?> aspect : this.fCsAspects) {
            Object result = aspect.resolve(event);
            if (!(result instanceof List)) continue;
            callsites = (List)result;
            break;
        }
        if (callsites == null || callsites.isEmpty()) {
            return;
        }
        int root = this.getRootAttribute(event);
        if (root == -2) {
            return;
        }
        int filesQuark = ssb.getQuarkRelativeAndAdd(root, new String[]{FILES});
        int linesQuark = ssb.getQuarkRelativeAndAdd(root, new String[]{LINES});
        long time = event.getTimestamp().toNanos();
        try {
            Integer nextLine;
            Integer prevFile = (Integer)ssb.queryOngoing(filesQuark);
            ssb.modifyAttribute(time, (Object)((int)(this.fInterner.intern(ssb, ((ITmfCallsite)callsites.get(0)).getFileName(), this.fSourceQuark) - ssb.getStartTime())), filesQuark);
            Integer nextFile = (Integer)ssb.queryOngoing(filesQuark);
            Long lineNo = ((ITmfCallsite)callsites.get(0)).getLineNo();
            Integer prevLine = (Integer)ssb.queryOngoing(filesQuark);
            Integer n = nextLine = lineNo == null ? null : Integer.valueOf(lineNo.intValue());
            if (Objects.equals(prevLine, nextLine) && Objects.equals(prevFile, nextFile)) {
                ssb.modifyAttribute(time, null, linesQuark);
            }
            ssb.modifyAttribute(time, (Object)nextLine, linesQuark);
        }
        catch (IndexOutOfBoundsException | StateValueTypeException | TimeRangeException e) {
            Activator.logError(e.getMessage(), e);
        }
    }

    protected int getRootAttribute(ITmfEvent event) {
        String deviceId = null;
        String deviceType = null;
        ITmfTrace trace = event.getTrace();
        for (ITmfEventAspect<?> aspect : trace.getEventAspects()) {
            TmfDeviceAspect deviceAspect;
            Object result;
            if (!(aspect instanceof TmfDeviceAspect) || (result = (deviceAspect = (TmfDeviceAspect)aspect).resolve(event)) == null) continue;
            deviceId = result.toString();
            deviceType = deviceAspect.getDeviceType();
            break;
        }
        if (deviceId == null) {
            return -2;
        }
        ITmfStateSystemBuilder ssb = Objects.requireNonNull(this.getStateSystemBuilder());
        return ssb.getQuarkRelativeAndAdd(this.fDevicesQuark, new String[]{String.valueOf(trace.getUUID()), deviceType, deviceId});
    }

    @Override
    public @NonNull ITmfStateProvider getNewInstance() {
        return new CallsiteStateProvider(this.getTrace(), ID, new StateSystemStringInterner());
    }
}

