/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.tag;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.core.pdom.db.BTree;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeVisitor;
import org.eclipse.core.runtime.CoreException;

public class BTreeIterable<T>
implements Iterable<T> {
    private final BTree btree;
    private final Descriptor<T> descriptor;

    public BTreeIterable(BTree btree, Descriptor<T> descriptor) {
        this.btree = btree;
        this.descriptor = descriptor;
    }

    @Override
    public Iterator<T> iterator() {
        Visitor v = new Visitor();
        try {
            this.btree.accept(v);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return Collections.emptyList().iterator();
        }
        return new BTreeIterator(v.records);
    }

    private class BTreeIterator
    implements Iterator<T> {
        private final Iterator<Long> records;

        public BTreeIterator(Iterable<Long> records) {
            this.records = records.iterator();
        }

        @Override
        public void remove() {
        }

        @Override
        public boolean hasNext() {
            return this.records.hasNext();
        }

        @Override
        public T next() {
            return BTreeIterable.this.descriptor.create(this.records.next());
        }
    }

    public static interface Descriptor<T> {
        public int compare(long var1) throws CoreException;

        public T create(long var1);
    }

    private class Visitor
    implements IBTreeVisitor {
        public final List<Long> records = new ArrayList<Long>();

        private Visitor() {
        }

        @Override
        public int compare(long record) throws CoreException {
            return BTreeIterable.this.descriptor.compare(record);
        }

        @Override
        public boolean visit(long record) throws CoreException {
            this.records.add(record);
            return true;
        }
    }
}

