/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.ast.tag;

import java.util.Arrays;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.tag.IBindingTagger;
import org.eclipse.cdt.core.dom.ast.tag.ITag;
import org.eclipse.cdt.core.dom.ast.tag.ITagWriter;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class TaggerDescriptor {
    private static final String Attr_LocalId = "local-id";
    private static final String Attr_Class = "class";
    private final IConfigurationElement element;
    private final Expression enablementExpression;
    private Boolean fStatus = null;
    private String id;
    private IBindingTagger tagger;
    private static final String VAR_PROJECTNATURES = "projectNatures";
    private static final String VAR_LANGUAGEID = "languageId";
    private static final IBindingTagger NULL_TAGGER = new IBindingTagger(){

        @Override
        public ITag process(ITagWriter tagWriter, IBinding binding, IASTName ast) {
            return null;
        }
    };

    public TaggerDescriptor(IConfigurationElement element) {
        this.element = element;
        Expression expr = null;
        IConfigurationElement[] children = element.getChildren("enablement");
        switch (children.length) {
            case 0: {
                this.fStatus = Boolean.TRUE;
                break;
            }
            case 1: {
                try {
                    ExpressionConverter parser = ExpressionConverter.getDefault();
                    expr = parser.perform(children[0]);
                }
                catch (CoreException e) {
                    CCorePlugin.log("Error in enablement expression of " + this.id, e);
                }
                break;
            }
            default: {
                CCorePlugin.log("Too many enablement expressions for " + this.id);
                this.fStatus = Boolean.FALSE;
            }
        }
        this.enablementExpression = expr;
    }

    public String getId() {
        if (this.id != null) {
            return this.id;
        }
        String globalId = this.element.getContributor().getName();
        String localId = this.element.getAttribute(Attr_LocalId);
        if (localId == null) {
            String extId = this.element.getDeclaringExtension().getSimpleIdentifier();
            CCorePlugin.log("Invalid extension " + globalId + "." + extId + " must provide tagger's local-id");
            return null;
        }
        if (localId.startsWith(globalId) && localId.length() > globalId.length()) {
            return localId;
        }
        if (localId.isEmpty()) {
            String extId = this.element.getDeclaringExtension().getSimpleIdentifier();
            CCorePlugin.log("Invalid extension " + globalId + "." + extId + " must provide value for tagger's local-id");
            return null;
        }
        if (localId.charAt(0) == '.') {
            return globalId + localId;
        }
        return globalId + "." + localId;
    }

    private boolean matches(ITranslationUnit tu) {
        if (this.fStatus != null) {
            return this.fStatus;
        }
        if (tu == null) {
            return true;
        }
        if (this.enablementExpression != null) {
            try {
                ILanguage language;
                IProject project = null;
                ICProject cProject = tu.getCProject();
                if (cProject != null) {
                    project = cProject.getProject();
                }
                EvaluationContext evalContext = new EvaluationContext(null, (Object)project);
                if (project != null) {
                    String[] natures = project.getDescription().getNatureIds();
                    evalContext.addVariable(VAR_PROJECTNATURES, Arrays.asList(natures));
                }
                if ((language = tu.getLanguage()) != null) {
                    evalContext.addVariable(VAR_LANGUAGEID, (Object)language.getId());
                }
                return this.enablementExpression.evaluate((IEvaluationContext)evalContext) == EvaluationResult.TRUE;
            }
            catch (CoreException e) {
                CCorePlugin.log("Error while evaluating enablement expression for " + this.id, e);
            }
        }
        this.fStatus = Boolean.FALSE;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IBindingTagger getTagger() {
        if (this.tagger == null) {
            TaggerDescriptor taggerDescriptor = this;
            synchronized (taggerDescriptor) {
                if (this.tagger == null) {
                    try {
                        this.tagger = (IBindingTagger)this.element.createExecutableExtension(Attr_Class);
                    }
                    catch (CoreException e) {
                        String id = this.element.getDeclaringExtension().getNamespaceIdentifier() + "." + this.element.getDeclaringExtension().getSimpleIdentifier();
                        CCorePlugin.log("Error in class attribute of " + id, e);
                        this.tagger = NULL_TAGGER;
                    }
                }
            }
        }
        return this.tagger;
    }

    public IBindingTagger getBindingTaggerFor(IBinding binding, IASTName ast) {
        if (ast == null) {
            return this.getTagger();
        }
        IASTTranslationUnit astTU = ast.getTranslationUnit();
        if (astTU == null) {
            return this.getTagger();
        }
        return this.matches(astTU.getOriginatingTranslationUnit()) ? this.getTagger() : null;
    }
}

