/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.platform.resources;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.ease.tools.RunnableWithResult;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.views.navigator.ResourceComparator;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public final class WorkspaceTools {
    @Deprecated
    private WorkspaceTools() {
        throw new IllegalArgumentException("Not intended to be instantiated");
    }

    public static IContainer createFolder(IResource resource) throws IOException {
        IFolder folder = null;
        if (resource instanceof IFile) {
            if (resource.exists()) {
                throw new IOException(String.format("A file with the name '%s' already exists", resource.toString()));
            }
            folder = resource.getProject().getFolder(resource.getProjectRelativePath());
        } else if (resource instanceof IFolder) {
            folder = (IFolder)resource;
        }
        if (folder != null) {
            if (!folder.exists()) {
                if (!folder.getParent().exists()) {
                    WorkspaceTools.createFolder((IResource)folder.getParent());
                }
                try {
                    folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    throw new IOException(e);
                }
            }
            return folder;
        }
        throw new IOException(String.format("Location '%s' cannot be cast to a folder", folder.toString()));
    }

    public static IFile createFile(IFile file) throws IOException {
        if (file.getParent() instanceof IFolder) {
            WorkspaceTools.createFolder((IResource)file.getParent());
        }
        try {
            file.create((InputStream)new ByteArrayInputStream(new byte[0]), false, null);
            return file;
        }
        catch (CoreException e) {
            throw new IOException(e);
        }
    }

    public static void deleteFile(IResource file) throws IOException {
        if (file instanceof IFile) {
            try {
                file.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                throw new IOException(String.format("Cannot delete file '%s'", file), e);
            }
        } else {
            throw new IOException(String.format("Cannot delete file '%s' as it is not a file", file));
        }
    }

    public static void deleteFolder(IResource folder) throws IOException {
        if (folder.exists()) {
            if (folder instanceof IFolder) {
                try {
                    ((IFolder)folder).delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    throw new IOException(e);
                }
            } else {
                throw new IOException(String.format("Cannot delete folder '%s' as it is not a folder", folder));
            }
        }
    }

    public static IWorkspaceRoot getWorkspace() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static String openFileSelectionDialog(final IContainer dialogRoot, final int mode, final String title, final String message) {
        RunnableWithResult<String> runnable = new RunnableWithResult<String>(){

            public String runWithTry() throws Throwable {
                if (mode == 8192) {
                    SaveAsDialog dialog = new SaveAsDialog(Display.getDefault().getActiveShell());
                    if (!dialogRoot.equals((Object)WorkspaceTools.getWorkspace())) {
                        dialog.setOriginalFile(dialogRoot.getFile((IPath)new Path("newFile")));
                    }
                    dialog.setTitle(title);
                    dialog.setMessage(message);
                    if (dialog.open() == 0) {
                        return "workspace:/" + dialog.getResult().toPortableString();
                    }
                } else {
                    ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(Display.getDefault().getActiveShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                    dialog.setTitle(title);
                    dialog.setMessage(message);
                    dialog.setInput((Object)dialogRoot);
                    dialog.setComparator((ViewerComparator)new ResourceComparator(1));
                    if (dialog.open() == 0) {
                        return "workspace:/" + ((IResource)dialog.getFirstResult()).getFullPath().toPortableString();
                    }
                }
                return null;
            }
        };
        Display.getDefault().syncExec((Runnable)runnable);
        return (String)runnable.getResult();
    }

    public static String openFolderSelectionDialog(final IContainer dialogRoot, final String title, final String message) {
        RunnableWithResult<String> runnable = new RunnableWithResult<String>(){

            public String runWithTry() throws Throwable {
                ContainerSelectionDialog dialog = new ContainerSelectionDialog(Display.getDefault().getActiveShell(), dialogRoot, true, message);
                dialog.setTitle(title);
                if (dialog.open() == 0) {
                    return "workspace:/" + ((IPath)dialog.getResult()[0]).toPortableString();
                }
                return null;
            }
        };
        Display.getDefault().syncExec((Runnable)runnable);
        return (String)runnable.getResult();
    }

    public static String[] findFiles(Pattern regExp, IContainer root, boolean recursive) throws IOException {
        try {
            ArrayList result = new ArrayList();
            root.accept(resource -> {
                if (resource instanceof IFile && regExp.matcher(resource.getName()).matches()) {
                    result.add("workspace:/" + resource.getFullPath());
                }
                return true;
            }, recursive ? 2 : 1, 8);
            return result.toArray(new String[0]);
        }
        catch (CoreException e) {
            throw new IOException(e);
        }
    }

    public static IProject linkProject(File folder) throws IOException {
        if (folder.isDirectory()) {
            try {
                IProjectDescription description = WorkspaceTools.getProjectDescription(folder);
                IProject project = WorkspaceTools.getProject(description.getName());
                project.create(description, null);
                project.open(null);
                return project;
            }
            catch (CoreException e) {
                throw new IOException("Cannot read project description", e);
            }
        }
        throw new IOException(String.format("'%s' is not a directory", folder));
    }

    public static IProject importProject(File resolvedFile) throws IOException {
        if (resolvedFile.isDirectory()) {
            try {
                IProjectDescription projectDescription = WorkspaceTools.getProjectDescription(resolvedFile);
                IProject project = WorkspaceTools.createProject(projectDescription.getName());
                ImportOperation importOperation = new ImportOperation(project.getFullPath(), (Object)resolvedFile, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, file -> "ALL");
                importOperation.setCreateContainerStructure(false);
                importOperation.run((IProgressMonitor)new NullProgressMonitor());
                return project;
            }
            catch (InvocationTargetException e) {
                throw new IOException("Import failed", e);
            }
            catch (CoreException e) {
                throw new IOException("Cannot read project description", e);
            }
            catch (InterruptedException e) {
                throw new IOException("Import got interrupted", e);
            }
        }
        throw new IOException("location is not a directory");
    }

    public static IProject createProject(String name) throws IOException {
        IProject project = WorkspaceTools.getProject(name);
        if (!project.exists()) {
            try {
                project.create((IProgressMonitor)new NullProgressMonitor());
                project.open((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                throw new IOException(e);
            }
        }
        return project;
    }

    private static IProjectDescription getProjectDescription(File folder) throws CoreException {
        Path projectPath = new Path(folder.getAbsoluteFile() + File.separator + ".project");
        return ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)projectPath);
    }

    private static IProject getProject(String name) {
        return WorkspaceTools.getWorkspace().getProject(name);
    }

    public static void createProblemMarker(IFile file, String type, int lineNumber, int intSeverity, String message, boolean permanent) throws IOException {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("lineNumber", lineNumber);
        attributes.put("severity", intSeverity);
        attributes.put("message", message);
        attributes.put("transient", !permanent);
        try {
            MarkerUtilities.createMarker((IResource)file, attributes, (String)type);
        }
        catch (CoreException e) {
            throw new IOException(e);
        }
    }
}

