/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.event.types;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.SimpleDatatypeDefinition;

public final class IntegerDefinition
extends SimpleDatatypeDefinition {
    private static final int INT_BASE_10 = 10;
    private static final int INT_BASE_16 = 16;
    private static final int INT_BASE_8 = 8;
    private static final int INT_BASE_2 = 2;
    private final long fValue;
    private String fMapping;

    public IntegerDefinition(@NonNull IntegerDeclaration declaration, IDefinitionScope definitionScope, @NonNull String fieldName, long value) {
        super(declaration, definitionScope, fieldName);
        this.fValue = value;
        this.fMapping = null;
    }

    public IntegerDefinition(@NonNull IntegerDeclaration declaration, IDefinitionScope definitionScope, @NonNull String fieldName, long value, String mappings) {
        super(declaration, definitionScope, fieldName);
        this.fMapping = mappings;
        this.fValue = value;
    }

    public long getValue() {
        return this.fValue;
    }

    public String getMappings() {
        if (this.fMapping == null) {
            this.fMapping = this.getDeclaration().getMappingForValue(this.fValue);
        }
        return this.fMapping;
    }

    @Override
    public IntegerDeclaration getDeclaration() {
        return (IntegerDeclaration)super.getDeclaration();
    }

    @Override
    public Long getIntegerValue() {
        return this.getValue();
    }

    @Override
    public long size() {
        return this.getDeclaration().getMaximumSize();
    }

    @Override
    public String getStringValue() {
        return this.toString();
    }

    @Override
    public String toString() {
        if (this.getDeclaration().isCharacter()) {
            char c = (char)this.fValue;
            return Character.toString(c);
        }
        return IntegerDefinition.formatNumber(this.fValue, this.getDeclaration().getBase(), this.getDeclaration().isSigned());
    }

    public static String formatNumber(long value, int base, boolean signed) {
        return switch (base) {
            case 2 -> "0b" + Long.toBinaryString(value);
            case 8 -> "0" + Long.toOctalString(value);
            case 16 -> "0x" + Long.toHexString(value);
            default -> {
                if (!signed && value < 0L) {
                    BigInteger bigInteger = BigInteger.valueOf(value);
                    bigInteger = bigInteger.add(BigInteger.valueOf(1L).shiftLeft(64));
                    yield bigInteger.toString();
                }
                yield Long.toString(value);
            }
        };
    }

    @Override
    public byte[] getBytes() {
        byte[] data = new byte[(int)Math.ceil((double)this.getDeclaration().getLength() / 8.0)];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.order(this.getDeclaration().getByteOrder());
        bb.putLong(this.fValue);
        return data;
    }
}

