/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header;

import java.util.Map;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceEventFormat;

public class BinaryFTraceEventSystem {
    private final String fSystemName;
    private final Map<Integer, BinaryFTraceEventFormat> fEventFormats;

    public BinaryFTraceEventSystem(String systemName, Map<Integer, BinaryFTraceEventFormat> eventFormats) {
        this.fSystemName = systemName;
        this.fEventFormats = eventFormats;
    }

    public String getSystemName() {
        return this.fSystemName;
    }

    public void addEventFormat(BinaryFTraceEventFormat eventFormat) {
        this.fEventFormats.put(eventFormat.getEventFormatID(), eventFormat);
    }

    public Map<Integer, BinaryFTraceEventFormat> getMapEventFormat() {
        return this.fEventFormats;
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("===Event System===").append('\n');
        strBuilder.append("Event system name: ").append(this.fSystemName).append('\n');
        strBuilder.append("List of events: ").append('\n');
        for (BinaryFTraceEventFormat value : this.fEventFormats.values()) {
            strBuilder.append(value).append('\n');
        }
        return strBuilder.toString();
    }
}

