/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring;

import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ContentStamp;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.UndoTextFileChange;
import org.eclipse.ltk.internal.core.refactoring.BufferValidationState;
import org.eclipse.ltk.internal.core.refactoring.Changes;
import org.eclipse.ltk.internal.core.refactoring.ContentStamps;
import org.eclipse.ltk.internal.core.refactoring.Lock;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.UndoEdit;

public class TextFileChange
extends TextChange {
    public static final int KEEP_SAVE_STATE = 1;
    public static final int FORCE_SAVE = 2;
    public static final int LEAVE_DIRTY = 4;
    private final IFile fFile;
    private volatile int fSaveMode = 1;
    private AtomicInteger fAcquireCount = new AtomicInteger();
    private volatile ITextFileBuffer fBuffer;
    private volatile BufferValidationState fValidationState;
    private volatile ContentStamp fContentStamp;

    public TextFileChange(String name, IFile file) {
        super(name);
        Assert.isNotNull((Object)file);
        this.fFile = file;
        String extension = file.getFileExtension();
        if (extension != null && extension.length() > 0) {
            this.setTextType(extension);
        }
    }

    public void setSaveMode(int saveMode) {
        this.fSaveMode = saveMode;
    }

    public int getSaveMode() {
        return this.fSaveMode;
    }

    public IFile getFile() {
        return this.fFile;
    }

    protected Change createUndoChange(UndoEdit edit, ContentStamp stampToRestore) {
        return new UndoTextFileChange(this.getName(), this.fFile, edit, stampToRestore, this.fSaveMode);
    }

    @Override
    public Object getModifiedElement() {
        return this.fFile;
    }

    @Override
    public Object[] getAffectedObjects() {
        Object modifiedElement = this.getModifiedElement();
        if (modifiedElement == null) {
            return null;
        }
        return new Object[]{modifiedElement};
    }

    @Override
    public void initializeValidationData(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask("", 1);
            this.fValidationState = BufferValidationState.create(this.fFile);
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public RefactoringStatus isValid(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask("", 1);
            if (this.fValidationState == null) {
                throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), "TextFileChange has not been initialialized"));
            }
            boolean needsSaving = this.needsSaving();
            RefactoringStatus result = this.fValidationState.isValid(needsSaving);
            if (needsSaving) {
                result.merge(Changes.validateModifiesFiles(new IFile[]{this.fFile}));
            } else {
                result.merge(Changes.checkInSync(new IFile[]{this.fFile}));
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void dispose() {
        if (this.fValidationState != null) {
            this.fValidationState.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IDocument acquireDocument(IProgressMonitor pm) throws CoreException {
        AtomicInteger atomicInteger = this.fAcquireCount;
        synchronized (atomicInteger) {
            if (this.fAcquireCount.incrementAndGet() > 1) {
                return this.fBuffer.getDocument();
            }
            ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
            IPath path = this.fFile.getFullPath();
            manager.connect(path, LocationKind.IFILE, pm);
            this.fBuffer = manager.getTextFileBuffer(path, LocationKind.IFILE);
            IDocument result = this.fBuffer.getDocument();
            this.fContentStamp = ContentStamps.get(this.fFile, result);
            return result;
        }
    }

    @Override
    protected void commit(IDocument document, IProgressMonitor pm) throws CoreException {
        if (this.needsSaving()) {
            this.fBuffer.commit(pm, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void releaseDocument(IDocument document, IProgressMonitor pm) throws CoreException {
        AtomicInteger atomicInteger = this.fAcquireCount;
        synchronized (atomicInteger) {
            int acquireCount = this.fAcquireCount.decrementAndGet();
            Assert.isTrue((acquireCount >= 0 ? 1 : 0) != 0);
            if (acquireCount == 0) {
                ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
                manager.disconnect(this.fFile.getFullPath(), LocationKind.IFILE, pm);
            }
        }
    }

    @Override
    protected final Change createUndoChange(UndoEdit edit) {
        return this.createUndoChange(edit, this.fContentStamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected UndoEdit performEdits(IDocument document) throws BadLocationException, MalformedTreeException {
        if (!this.fBuffer.isSynchronizationContextRequested()) {
            return super.performEdits(document);
        }
        ITextFileBufferManager fileBufferManager = FileBuffers.getTextFileBufferManager();
        Lock completionLock = new Lock();
        UndoEdit[] result = new UndoEdit[1];
        BadLocationException[] exception = new BadLocationException[1];
        Runnable runnable = () -> {
            Lock lock2 = completionLock;
            synchronized (lock2) {
                block8: {
                    try {
                        try {
                            undoEditArray[0] = TextFileChange.super.performEdits(document);
                        }
                        catch (BadLocationException e) {
                            badLocationExceptionArray[0] = e;
                            lock.fDone = true;
                            completionLock.notifyAll();
                            break block8;
                        }
                    }
                    catch (Throwable throwable) {
                        lock.fDone = true;
                        completionLock.notifyAll();
                        throw throwable;
                    }
                    lock.fDone = true;
                    completionLock.notifyAll();
                }
            }
        };
        Lock lock = completionLock;
        synchronized (lock) {
            fileBufferManager.execute(runnable);
            while (!completionLock.fDone) {
                try {
                    completionLock.wait(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (exception[0] != null) {
            throw exception[0];
        }
        return result[0];
    }

    protected boolean isDocumentAcquired() {
        return this.fAcquireCount.get() > 0;
    }

    protected boolean isDocumentModified() {
        if (this.isDocumentAcquired()) {
            ContentStamp currentStamp = ContentStamps.get(this.fFile, this.fBuffer.getDocument());
            return !currentStamp.equals(this.fContentStamp);
        }
        return false;
    }

    protected boolean needsSaving() {
        if ((this.fSaveMode & 2) != 0) {
            return true;
        }
        if ((this.fSaveMode & 1) != 0) {
            return this.fValidationState == null || !this.fValidationState.wasDirty();
        }
        return false;
    }
}

