/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.modules.ui;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.eclipse.ease.modules.ModuleDefinition;
import org.eclipse.ease.modules.ModuleHelper;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ease.ui.modules.ui.ModulesTools;
import org.eclipse.ease.ui.tools.AbstractVirtualTreeProvider;
import org.eclipse.ui.PlatformUI;

public class ModulesContentProvider
extends AbstractVirtualTreeProvider {
    private final boolean fModulesOnly;

    public ModulesContentProvider(boolean modulesOnly) {
        this.fModulesOnly = modulesOnly;
    }

    @Override
    public Object getParent(Object element) {
        return null;
    }

    @Override
    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ModuleDefinition && !this.fModulesOnly) {
            ArrayList<ModulesTools.ModuleEntry<AccessibleObject>> children = new ArrayList<ModulesTools.ModuleEntry<AccessibleObject>>();
            for (Field field : ModuleHelper.getFields((Class)((ModuleDefinition)parentElement).getModuleClass())) {
                children.add(new ModulesTools.ModuleEntry<Field>((ModuleDefinition)parentElement, field));
            }
            for (Method method : ModuleHelper.getMethods((Class)((ModuleDefinition)parentElement).getModuleClass())) {
                children.add(new ModulesTools.ModuleEntry<Method>((ModuleDefinition)parentElement, method));
            }
            return children.toArray();
        }
        return super.getChildren(parentElement);
    }

    @Override
    protected void populateElements(Object inputElement) {
        IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
        ArrayList modules = new ArrayList(scriptService.getAvailableModules());
        for (ModuleDefinition module : modules) {
            this.registerElement(module.getPath().removeLastSegments(1), module);
        }
    }

    @Override
    public boolean hasChildren(Object element) {
        if (element instanceof ModuleDefinition && !this.fModulesOnly) {
            Class clazz = ((ModuleDefinition)element).getModuleClass();
            if (clazz == null) {
                return false;
            }
            return !ModuleHelper.getMethods((Class)clazz).isEmpty() || !ModuleHelper.getFields((Class)clazz).isEmpty();
        }
        return super.hasChildren(element);
    }
}

