/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.sign;

import java.io.InputStream;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.ease.service.ScriptType;
import org.eclipse.ease.sign.ScriptSignatureException;
import org.eclipse.ease.sign.VerifySignature;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.PlatformUI;

public class SignatureCheck {
    public static final String PLUGIN_EASE_UI_SCRIPTS_ID = "org.eclipse.ease.ui.scripts";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean canExecute(ScriptType scriptType, InputStream inputStream, boolean remote) {
        try {
            VerifySignature verifySignature = VerifySignature.getInstance(scriptType, inputStream);
            IPreferencesService prefs = Platform.getPreferencesService();
            if (remote) {
                boolean executeRemote = prefs.getBoolean(PLUGIN_EASE_UI_SCRIPTS_ID, "runWithoutSignRemote", false, null);
                if (!executeRemote) {
                    return SignatureCheck.checkSignature(verifySignature);
                }
                if (verifySignature == null) {
                    return true;
                }
                return SignatureCheck.checkSignature(verifySignature);
            }
            boolean executeLocal = prefs.getBoolean(PLUGIN_EASE_UI_SCRIPTS_ID, "runWithoutSignLocal", false, null);
            if (!executeLocal) {
                return SignatureCheck.checkSignature(verifySignature);
            }
            if (verifySignature == null) {
                return true;
            }
            return SignatureCheck.checkSignature(verifySignature);
        }
        catch (ScriptSignatureException e) {
            return SignatureCheck.showErrorMessage(e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean checkSignature(VerifySignature verifySignature) {
        block3: {
            try {
                if (!verifySignature.verify()) return SignatureCheck.showErrorMessage("File modified after applying signature");
                if (verifySignature.isSelfSignedCertificate()) break block3;
                if (verifySignature.isCertChainValid()) return true;
                return SignatureCheck.showErrorMessage("Certificate chain is invalid. Either not signed by trusted certificate or there are incorrect certificates.");
            }
            catch (ScriptSignatureException e) {
                return SignatureCheck.showErrorMessage("Signature can't be verified. " + e.getMessage());
            }
        }
        return SignatureCheck.showErrorMessage("Signature is valid. Attached certificate is Self-Signed. Do you want to execute?");
    }

    private static boolean showErrorMessage(String msg) {
        MessageDialog messageDialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Error checking signature", null, msg, 3, new String[]{"Don't Execute", "Execute"}, 0);
        switch (messageDialog.open()) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }
}

