/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.examples.logicdesigner.figures.GateFigure;
import org.eclipse.gef.examples.logicdesigner.figures.LogicColorConstants;

public class OrGateFigure
extends GateFigure {
    public static final Dimension SIZE = new Dimension(30, 34);
    protected static final PointList GATE_OUTLINE = new PointList();

    static {
        GATE_OUTLINE.addPoint(4, 20);
        GATE_OUTLINE.addPoint(4, 4);
        GATE_OUTLINE.addPoint(8, 8);
        GATE_OUTLINE.addPoint(12, 10);
        GATE_OUTLINE.addPoint(14, 10);
        GATE_OUTLINE.addPoint(16, 10);
        GATE_OUTLINE.addPoint(20, 8);
        GATE_OUTLINE.addPoint(24, 4);
        GATE_OUTLINE.addPoint(24, 20);
    }

    public OrGateFigure() {
        this.setBackgroundColor(LogicColorConstants.orGate);
        this.setForegroundColor(LogicColorConstants.outlineColor);
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        return SIZE;
    }

    protected void paintFigure(Graphics g) {
        Rectangle r = this.getBounds().getCopy();
        r.translate(4, 4);
        r.setSize(22, 18);
        g.setAntialias(1);
        g.setLineWidth(2);
        g.drawLine(r.x + 4, r.y + 4, r.x + 4, r.y - 4);
        g.drawLine(r.right() - 6, r.y + 4, r.right() - 6, r.y - 4);
        r.y += 8;
        --r.width;
        g.fillOval(r);
        --r.width;
        --r.height;
        g.drawOval(r);
        g.drawLine(r.x + r.width / 2, r.bottom(), r.x + r.width / 2, r.bottom() + 4);
        g.translate(this.getLocation());
        g.fillPolygon(GATE_OUTLINE);
        g.drawPolyline(GATE_OUTLINE);
        g.translate(this.getLocation().getNegated());
    }
}

