/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text.model.commands;

import org.eclipse.gef.examples.text.GraphicalTextViewer;
import org.eclipse.gef.examples.text.SelectionRange;
import org.eclipse.gef.examples.text.model.Container;
import org.eclipse.gef.examples.text.model.ModelElement;
import org.eclipse.gef.examples.text.model.ModelLocation;
import org.eclipse.gef.examples.text.model.TextRun;
import org.eclipse.gef.examples.text.model.commands.ExampleTextCommand;

public class ConvertElementCommand
extends ExampleTextCommand {
    private final TextRun text;
    private final char[] removed;
    private final int offset;
    private final ModelElement converted;
    private final ModelLocation caret;

    public ConvertElementCommand(TextRun text, int begin, int end, ModelElement converted, ModelLocation caret) {
        super("bogus");
        this.text = text;
        this.offset = begin;
        this.converted = converted;
        this.caret = caret;
        this.removed = text.getText().substring(begin, end).toCharArray();
    }

    public void execute() {
        this.text.removeRange(this.offset, this.removed.length);
        Container container = this.text.getContainer();
        container.remove(this.text);
        container.add(this.converted);
    }

    @Override
    public SelectionRange getRedoSelectionRange(GraphicalTextViewer viewer) {
        return null;
    }

    @Override
    public SelectionRange getExecuteSelectionRange(GraphicalTextViewer viewer) {
        return new SelectionRange(ConvertElementCommand.lookupModel(viewer, this.caret.model), this.caret.offset);
    }

    @Override
    public SelectionRange getUndoSelectionRange(GraphicalTextViewer viewer) {
        return null;
    }
}

