/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text.figures;

import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class TreeBorder
extends AbstractBorder {
    private final Image image;
    private final String text;
    private Insets insets;

    public TreeBorder(Image image, String text) {
        this.image = image;
        this.text = text;
    }

    public Insets getInsets(IFigure figure) {
        if (this.insets == null) {
            FigureUtilities.getTextExtents((String)this.text, (Font)figure.getFont(), (Dimension)Dimension.SINGLETON);
            this.insets = new Insets(Math.max(16, Dimension.SINGLETON.height), 9, 0, 0);
        }
        return this.insets;
    }

    public void paint(IFigure figure, Graphics g, Insets insets) {
        Rectangle where = TreeBorder.getPaintRectangle((IFigure)figure, (Insets)insets);
        g.translate(where.x, where.y);
        int i = 16;
        while (i < where.height - 10) {
            g.drawPoint(9, i);
            i += 2;
        }
        g.drawImage(this.image, 0, 0);
        int h = FigureUtilities.getFontMetrics((Font)g.getFont()).getHeight();
        g.drawText(this.text, 19, 16 - h);
    }
}

