/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.internal.caching;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.equinox.service.weaving.ICachingServiceFactory;
import org.eclipse.equinox.weaving.internal.caching.CachingServiceFactory;
import org.eclipse.equinox.weaving.internal.caching.Log;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    private static boolean verbose = Boolean.getBoolean("org.aspectj.osgi.verbose");
    private CachingServiceFactory cachingServiceFactory;
    private ServiceRegistration<?> cachingServiceFactoryRegistration;

    public void start(BundleContext bundleContext) {
        this.setDebugEnabled(bundleContext);
        if (this.shouldRegister()) {
            if (verbose) {
                System.err.println("[org.eclipse.equinox.weaving.caching] info starting standard caching service ...");
            }
            this.registerCachingServiceFactory(bundleContext);
        } else if (verbose) {
            System.err.println("[org.eclipse.equinox.weaving.caching] warning cannot start standard caching service on J9 VM");
        }
    }

    public void stop(BundleContext bundleContext) {
        this.cachingServiceFactory.stop();
        this.cachingServiceFactoryRegistration.unregister();
        if (Log.isDebugEnabled()) {
            Log.debug("Shut down and unregistered SingletonCachingService.");
        }
    }

    private void registerCachingServiceFactory(BundleContext bundleContext) {
        this.cachingServiceFactory = new CachingServiceFactory(bundleContext);
        this.cachingServiceFactoryRegistration = bundleContext.registerService(ICachingServiceFactory.class.getName(), (Object)this.cachingServiceFactory, null);
        if (Log.isDebugEnabled()) {
            Log.debug("Created and registered SingletonCachingService.");
        }
    }

    private void setDebugEnabled(BundleContext bundleContext) {
        DebugOptions debugOptions;
        ServiceReference serviceReference = bundleContext.getServiceReference(DebugOptions.class.getName());
        if (serviceReference != null && (debugOptions = (DebugOptions)bundleContext.getService(serviceReference)) != null) {
            Log.debugEnabled = debugOptions.getBooleanOption("org.eclipse.equinox.weaving.caching/debug", false);
        }
        if (serviceReference != null) {
            bundleContext.ungetService(serviceReference);
        }
    }

    private boolean shouldRegister() {
        boolean bl = true;
        try {
            Boolean bl2;
            Class.forName("com.ibm.oti.vm.VM");
            Class<?> clazz = Class.forName("com.ibm.oti.shared.Shared");
            Method method = clazz.getMethod("isSharingEnabled", null);
            if (method != null && (bl2 = (Boolean)method.invoke(null, null)) != null && bl2.booleanValue()) {
                bl = false;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        return bl;
    }
}

