/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.launching;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.internal.launching.LTWAspectPathTab;
import org.eclipse.ajdt.internal.launching.LTWUtils;
import org.eclipse.ajdt.internal.ui.ras.UIFFDC;
import org.eclipse.ajdt.internal.ui.text.UIMessages;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.JavaLaunchDelegate;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;

public class LTWApplicationLaunchConfigurationDelegate
extends JavaLaunchDelegate {
    private static final String classLoaderOption = "-Djava.system.class.loader";
    private static final String ajClasspathOption = "-Daj.class.path";
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(NLS.bind((String)"{0}...", (Object[])new String[]{configuration.getName()}), 3);
        if (monitor.isCanceled()) {
            return;
        }
        this.generateAOPConfigFiles(configuration);
        monitor.subTask(LaunchingMessages.JavaLocalApplicationLaunchConfigurationDelegate_Verifying_launch_attributes____1);
        String mainTypeName = this.verifyMainTypeName(configuration);
        IVMRunner runner = this.getVMRunner(configuration, mode);
        boolean isJava5OrLater = this.isJava5OrLater(configuration);
        File workingDir = this.verifyWorkingDirectory(configuration);
        String workingDirName = null;
        if (workingDir != null) {
            workingDirName = workingDir.getAbsolutePath();
        }
        String[] envp = this.getEnvironment(configuration);
        String[] classpath = this.getClasspath(configuration);
        String[] ltwClasspath = null;
        try {
            ltwClasspath = this.getLTWClasspath(classpath, isJava5OrLater);
        }
        catch (MalformedURLException malformedURLException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(malformedURLException, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
            MalformedURLException e = malformedURLException;
            throw new CoreException((IStatus)new ResourceStatus(4, null, UIMessages.LTW_error_launching, (Throwable)e));
        }
        catch (IOException iOException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(iOException, (Object)this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_1);
            IOException e = iOException;
            throw new CoreException((IStatus)new ResourceStatus(4, null, UIMessages.LTW_error_launching, (Throwable)e));
        }
        String pgmArgs = this.getProgramArguments(configuration);
        String vmArgs = this.getVMArguments(configuration);
        vmArgs = this.addExtraVMArgs(vmArgs, classpath, ltwClasspath[0], isJava5OrLater);
        ExecutionArguments execArgs = new ExecutionArguments(vmArgs, pgmArgs);
        Map vmAttributesMap = this.getVMSpecificAttributesMap(configuration);
        VMRunnerConfiguration runConfig = new VMRunnerConfiguration(mainTypeName, ltwClasspath);
        runConfig.setProgramArguments(execArgs.getProgramArgumentsArray());
        runConfig.setEnvironment(envp);
        runConfig.setVMArguments(execArgs.getVMArgumentsArray());
        runConfig.setWorkingDirectory(workingDirName);
        runConfig.setVMSpecificAttributesMap(vmAttributesMap);
        runConfig.setBootClassPath(this.getBootpath(configuration));
        if (monitor.isCanceled()) {
            return;
        }
        this.prepareStopInMain(configuration);
        monitor.worked(1);
        monitor.subTask(LaunchingMessages.JavaLocalApplicationLaunchConfigurationDelegate_Creating_source_locator____2);
        this.setDefaultSourceLocator(launch, configuration);
        monitor.worked(1);
        runner.run(runConfig, launch, monitor);
        if (monitor.isCanceled()) {
            return;
        }
        monitor.done();
    }

    public boolean isJava5OrLater(ILaunchConfiguration configuration) throws CoreException {
        String version;
        IVMInstall install = this.getVMInstall(configuration);
        if (install instanceof IVMInstall2 && (version = ((IVMInstall2)install).getJavaVersion()) != null) {
            Version osgiVersion;
            int dashIndex = version.indexOf(45);
            if (dashIndex >= 0) {
                version = version.substring(0, dashIndex);
            }
            return (osgiVersion = new Version(version)).getMinor() > 4;
        }
        return false;
    }

    private void generateAOPConfigFiles(ILaunchConfiguration configuration) throws CoreException {
        IProject project;
        IProject[] workspaceProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        IRuntimeClasspathEntry[] aspectPathEntries = this.getAspectPathEntries(configuration);
        int i = 0;
        while (i < aspectPathEntries.length) {
            String location = aspectPathEntries[i].getLocation();
            int j = 0;
            while (j < workspaceProjects.length) {
                IRuntimeClasspathEntry entry;
                String projectLocation;
                IProject project2 = workspaceProjects[j];
                if (project2.isOpen() && (projectLocation = (entry = JavaRuntime.newProjectRuntimeClasspathEntry((IJavaProject)JavaCore.create((IProject)project2))).getLocation()) != null && projectLocation.equals(location)) {
                    LTWUtils.generateLTWConfigFile(JavaCore.create((IProject)project2));
                }
                ++j;
            }
            ++i;
        }
        String projectName = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
        if (projectName != null && !projectName.trim().equals("") && (project = AspectJPlugin.getWorkspace().getRoot().getProject(projectName)).isOpen() && project.hasNature("org.eclipse.ajdt.ui.ajnature")) {
            LTWUtils.generateLTWConfigFile(JavaCore.create((IProject)project));
        }
    }

    public String[] getClasspath(ILaunchConfiguration configuration) throws CoreException {
        String location;
        IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)configuration);
        IRuntimeClasspathEntry[] aspectPathEntries = this.getAspectPathEntries(configuration);
        entries = JavaRuntime.resolveRuntimeClasspath((IRuntimeClasspathEntry[])entries, (ILaunchConfiguration)configuration);
        ArrayList<String> userEntries = new ArrayList<String>(entries.length + aspectPathEntries.length);
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getClasspathProperty() == 3 && (location = entries[i].getLocation()) != null) {
                userEntries.add(location);
            }
            ++i;
        }
        i = 0;
        while (i < aspectPathEntries.length) {
            location = aspectPathEntries[i].getLocation();
            if (location != null) {
                userEntries.add(location);
            }
            ++i;
        }
        return userEntries.toArray(new String[userEntries.size()]);
    }

    private IRuntimeClasspathEntry[] getAspectPathEntries(ILaunchConfiguration configuration) throws CoreException {
        List entries = configuration.getAttribute(LTWAspectPathTab.ATTR_ASPECTPATH, Collections.EMPTY_LIST);
        IRuntimeClasspathEntry[] rtes = new IRuntimeClasspathEntry[entries.size()];
        Iterator iter = entries.iterator();
        int i = 0;
        while (iter.hasNext()) {
            rtes[i] = JavaRuntime.newRuntimeClasspathEntry((String)((String)iter.next()));
            ++i;
        }
        return rtes;
    }

    private String[] getLTWClasspath(String[] classpath, boolean isJava5OrLater) throws IOException {
        URL resolvedaspectjWeaverJar = FileLocator.resolve((URL)new URL(Platform.getBundle((String)"org.aspectj.weaver").getEntry("/"), "aspectjweaver.jar"));
        URL resolvedaspectjRTJar = FileLocator.resolve((URL)new URL(Platform.getBundle((String)"org.aspectj.runtime").getEntry("/"), "aspectjrt.jar"));
        String weaverPath = new Path(resolvedaspectjWeaverJar.getFile()).toOSString();
        String rtPath = new Path(resolvedaspectjRTJar.getFile()).toOSString();
        ArrayList<String> fullPath = new ArrayList<String>();
        fullPath.add(weaverPath);
        fullPath.add(rtPath);
        if (isJava5OrLater) {
            String[] stringArray = classpath;
            int n = classpath.length;
            int n2 = 0;
            while (n2 < n) {
                String pathEntry = stringArray[n2];
                fullPath.add(pathEntry);
                ++n2;
            }
        }
        return fullPath.toArray(new String[0]);
    }

    private String addExtraVMArgs(String vmArgs, String[] ajClasspath, String pathToWeaver, boolean isJava5OrLater) {
        StringBuffer sb = new StringBuffer(vmArgs);
        if (!isJava5OrLater) {
            sb.append(' ');
            sb.append(classLoaderOption);
            sb.append('=');
            sb.append("org.aspectj.weaver.loadtime.WeavingURLClassLoader");
        }
        sb.append(' ');
        sb.append(ajClasspathOption);
        sb.append('=');
        sb.append('\"');
        int i = 0;
        while (i < ajClasspath.length) {
            if (i != 0) {
                sb.append(File.pathSeparator);
            }
            sb.append(ajClasspath[i]);
            ++i;
        }
        sb.append('\"');
        if (isJava5OrLater) {
            sb.append(" \"-javaagent:" + pathToWeaver + "\"");
        }
        return sb.toString();
    }

    static {
        LTWApplicationLaunchConfigurationDelegate.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("LTWApplicationLaunchConfigurationDelegate.java", LTWApplicationLaunchConfigurationDelegate.class);
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.launching.LTWApplicationLaunchConfigurationDelegate", "java.net.MalformedURLException", "e"), 98);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "launch", "org.eclipse.ajdt.internal.launching.LTWApplicationLaunchConfigurationDelegate", "org.eclipse.debug.core.ILaunchConfiguration:java.lang.String:org.eclipse.debug.core.ILaunch:org.eclipse.core.runtime.IProgressMonitor", "configuration:mode:launch:monitor", "org.eclipse.core.runtime.CoreException", "void"), 63);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.launching.LTWApplicationLaunchConfigurationDelegate", "java.io.IOException", "e"), 100);
    }
}

