/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core.codeconversion;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.ajdt.core.ReflectionUtils;
import org.eclipse.ajdt.core.parserbridge.ITDInserter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.core.search.matching.PossibleMatch;

public class ITDAwareLookupEnvironment
extends LookupEnvironment {
    private List<ITDInserter> cusToRevert;
    private boolean insertITDs = true;

    public ITDAwareLookupEnvironment(LookupEnvironment wrapper, INameEnvironment nameEnvironment) {
        super(wrapper.typeRequestor, wrapper.globalOptions, wrapper.problemReporter, nameEnvironment);
    }

    public void completeTypeBindings() {
        if (this.insertITDs) {
            this.cusToRevert = new LinkedList<ITDInserter>();
            CompilationUnitDeclaration[] units = this.getUnits();
            int i = 0;
            while (i < units.length) {
                ICompilationUnit cunit;
                if (units[i] != null && (cunit = this.findCU(units[i])) != null) {
                    ITDInserter visitor = new ITDInserter(cunit, this, this.problemReporter);
                    units[i].traverse((ASTVisitor)visitor, units[i].scope);
                    this.cusToRevert.add(visitor);
                }
                ++i;
            }
        }
        this.insertITDs = false;
        super.completeTypeBindings();
    }

    private ICompilationUnit findCU(CompilationUnitDeclaration unit) {
        String fileName = new String(unit.getFileName());
        Path path = new Path(fileName);
        if (path.segmentCount() > 1) {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            return (ICompilationUnit)JavaCore.create((IFile)file);
        }
        if (unit.compilationResult.compilationUnit instanceof PossibleMatch && ((PossibleMatch)unit.compilationResult.compilationUnit).openable instanceof ICompilationUnit) {
            return (ICompilationUnit)((PossibleMatch)unit.compilationResult.compilationUnit).openable;
        }
        return null;
    }

    private CompilationUnitDeclaration[] getUnits() {
        return (CompilationUnitDeclaration[])ReflectionUtils.getPrivateField(LookupEnvironment.class, "units", this);
    }

    public void revertCompilationUnits() {
        if (this.cusToRevert != null) {
            for (ITDInserter visitor : this.cusToRevert) {
                visitor.revert();
            }
        }
    }
}

