/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.ajde;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.aspectj.ajde.core.IBuildMessageHandler;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AJLog;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.internal.ui.ajde.AJDTErrorHandler;
import org.eclipse.ajdt.internal.ui.editor.AspectJEditor;
import org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences;
import org.eclipse.ajdt.internal.ui.ras.UIFFDC;
import org.eclipse.ajdt.internal.ui.text.UIMessages;
import org.eclipse.ajdt.internal.ui.tracing.DebugTracing;
import org.eclipse.ajdt.internal.utils.AJDTUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModelManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIMessageHandler
implements IBuildMessageHandler {
    private static Set<IResource> affectedResources;
    private static Map<String, List<?>> otherProjectMarkers;
    private static boolean lastBuildWasFull;
    private List<IMessage.Kind> ignoring;
    private List<ProblemTracker> problems = new ArrayList<ProblemTracker>();
    private static final int MAX_MESSAGE_LENGTH;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_7;

    static {
        UIMessageHandler.ajc$preClinit();
        affectedResources = new HashSet<IResource>();
        otherProjectMarkers = new HashMap();
        MAX_MESSAGE_LENGTH = (int)Math.pow(2.0, 16.0);
    }

    public UIMessageHandler(IProject project) {
        this.ignoring = new ArrayList<IMessage.Kind>();
        if (!AspectJPreferences.getBooleanPrefValue(project, "org.aspectj.ajdt.core.compiler.weaver.verbose")) {
            this.ignore(IMessage.INFO);
        }
        if (!AspectJPreferences.getShowWeaveMessagesOption(project)) {
            this.ignore(IMessage.WEAVEINFO);
        }
    }

    public boolean handleMessage(IMessage message) {
        IMessage.Kind kind = message.getKind();
        if (kind == IMessage.ABORT || message.getThrown() != null) {
            AJDTErrorHandler.handleInternalError(UIMessages.ajErrorDialogTitle, message.getMessage(), message.getThrown());
            return true;
        }
        if (this.isIgnoring(kind)) {
            return true;
        }
        if (message.getSourceLocation() == null) {
            AJLog.log((int)5, (String)message.getMessage());
            this.problems.add(new ProblemTracker(message.getMessage(), null, message.getKind()));
        } else {
            if (DebugTracing.DEBUG_COMPILER_MESSAGES) {
                AJLog.log((int)5, (String)("addSourcelineTask message=" + message.getMessage() + " file=" + message.getSourceLocation().getSourceFile().getPath() + " line=" + message.getSourceLocation().getLine()));
            } else {
                AJLog.log((int)5, (String)message.getMessage());
            }
            this.problems.add(new ProblemTracker(message.getMessage(), message.getSourceLocation(), message.getKind(), message.getDeclared(), message.getExtraSourceLocations(), message.getID(), message.getSourceStart(), message.getSourceEnd(), message.getThrown()));
        }
        return true;
    }

    public void dontIgnore(IMessage.Kind kind) {
        if (kind != null) {
            this.ignoring.remove(kind);
        }
    }

    public boolean isIgnoring(IMessage.Kind kind) {
        return kind != null && this.ignoring.contains(kind);
    }

    public void ignore(IMessage.Kind kind) {
        if (kind != null && !this.ignoring.contains(kind)) {
            this.ignoring.add(kind);
        }
    }

    protected void addAffectedResource(IResource res) {
        affectedResources.add(res);
    }

    public List<ProblemTracker> getErrors() {
        ArrayList<ProblemTracker> errors = new ArrayList<ProblemTracker>();
        for (ProblemTracker prob : this.problems) {
            if (!prob.kind.equals(IMessage.ERROR)) continue;
            errors.add(prob);
        }
        return errors;
    }

    public void showOutstandingProblems(IProject project) {
        if (this.problems.size() > 0 || affectedResources.size() > 0) {
            this.showMessages(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showMessages(final IProject project) {
        Collection activeEditorList;
        IWorkspaceRunnable r = new IWorkspaceRunnable(){
            private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
            private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
            private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
            private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

            public void run(IProgressMonitor monitor) {
                try {
                    Iterator affectedResourceIterator = affectedResources.iterator();
                    AJLog.log((int)1, (String)("Types affected during build = " + affectedResources.size()));
                    IResource ir = null;
                    while (affectedResourceIterator.hasNext()) {
                        ir = (IResource)affectedResourceIterator.next();
                        try {
                            if (!ir.exists()) continue;
                            ir.deleteMarkers("org.eclipse.jdt.core.problem", false, 2);
                            ir.deleteMarkers("org.eclipse.ajdt.ui.problemmarker", true, 2);
                            ir.deleteMarkers("org.eclipse.core.resources.taskmarker", true, 2);
                            HashSet managedMarkers = JavaModelManager.getJavaModelManager().compilationParticipants.managedMarkerTypes();
                            for (String managedMarker : managedMarkers) {
                                ir.deleteMarkers(managedMarker, true, 2);
                            }
                        }
                        catch (CoreException coreException) {
                            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
                            CoreException re = coreException;
                            AJLog.log((String)("Failed marker deletion: resource=" + ir.getLocation()));
                            throw re;
                        }
                    }
                    Iterator problemIterator = UIMessageHandler.this.problems.iterator();
                    ProblemTracker p = null;
                    while (problemIterator.hasNext()) {
                        p = (ProblemTracker)problemIterator.next();
                        ir = null;
                        IMarker marker = null;
                        try {
                            if (p.location != null) {
                                ir = UIMessageHandler.this.locationToResource(p.location, project);
                                if (ir != null && ir.exists()) {
                                    if (lastBuildWasFull || affectedResources.contains(ir) || ir.getProject() != project) {
                                        int prio = UIMessageHandler.this.getTaskPriority(p);
                                        if (prio != -1) {
                                            marker = ir.createMarker("org.eclipse.core.resources.taskmarker");
                                            marker.setAttribute("priority", prio);
                                        } else if (p.declaredErrorOrWarning) {
                                            marker = ir.createMarker("org.eclipse.ajdt.ui.problemmarker");
                                        } else {
                                            marker = ir.createMarker("org.eclipse.jdt.core.problem");
                                            marker.setAttribute("id", p.id);
                                        }
                                        if (p.start >= 0 && p.end >= 0) {
                                            marker.setAttribute("charStart", (Object)new Integer(p.start));
                                            marker.setAttribute("charEnd", (Object)new Integer(p.end + 1));
                                        }
                                        if (!ir.getProject().equals((Object)project)) {
                                            UIMessageHandler.this.addOtherProjectMarker(project, marker);
                                        }
                                        if (p.location.getLine() > 0) {
                                            marker.setAttribute("lineNumber", (Object)new Integer(p.location.getLine()));
                                        }
                                    } else {
                                        AJLog.log((int)5, (String)("Not adding marker for problem because it's against a resource which is not in the list of affected resources provided by the compiler. Resource=" + ir + " Problem message=" + p.message + " line=" + p.location.getLine()));
                                    }
                                }
                            } else {
                                marker = project.createMarker("org.eclipse.jdt.core.problem");
                            }
                            if (marker == null) continue;
                            UIMessageHandler.this.setSeverity(marker, p.kind);
                            if (p.extraLocs != null && p.extraLocs.size() > 0) {
                                int relCount = 0;
                                for (ISourceLocation sLoc : p.extraLocs) {
                                    StringBuffer attrData = new StringBuffer();
                                    attrData.append(sLoc.getSourceFile().getAbsolutePath());
                                    attrData.append(":::");
                                    attrData.append(sLoc.getLine());
                                    attrData.append(":::");
                                    attrData.append(sLoc.getEndLine());
                                    attrData.append(":::");
                                    attrData.append(sLoc.getColumn());
                                    marker.setAttribute("relatedLocations-" + relCount++, (Object)attrData.toString());
                                }
                            }
                            UIMessageHandler.this.setMessage(marker, p.message);
                        }
                        catch (CoreException coreException) {
                            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_1);
                            CoreException re = coreException;
                            AJLog.log((String)("Failed marker creation: resource=" + p.location.getSourceFile().getPath() + " line=" + p.location.getLine() + " message=" + p.message));
                            throw re;
                        }
                    }
                    UIMessageHandler.this.clearMessages();
                }
                catch (CoreException coreException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_3, (JoinPoint.StaticPart)ajc$tjp_1);
                    CoreException e = coreException;
                    AJDTErrorHandler.handleAJDTError(UIMessages.CompilerTaskListManager_Error_creating_marker, e);
                }
            }

            static {
                1.ajc$preClinit();
            }

            private static /* synthetic */ void ajc$preClinit() {
                Factory factory = new Factory("UIMessageHandler.java", 1.class);
                ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.ajde.UIMessageHandler$1", "org.eclipse.core.runtime.CoreException", "re"), 244);
                ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "run", "org.eclipse.ajdt.internal.ui.ajde.UIMessageHandler$1", "org.eclipse.core.runtime.IProgressMonitor", "monitor", "", "void"), 220);
                ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.ajde.UIMessageHandler$1", "org.eclipse.core.runtime.CoreException", "re"), 327);
                ajc$tjp_3 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.ajde.UIMessageHandler$1", "org.eclipse.core.runtime.CoreException", "e"), 338);
            }
        };
        try {
            AspectJPlugin.getWorkspace().run(r, null);
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
            CoreException cEx = coreException;
            AJDTErrorHandler.handleAJDTError(UIMessages.CompilerTaskListManager_Error_adding_problem_markers, cEx);
        }
        Collection collection = activeEditorList = AspectJEditor.getActiveEditorList();
        synchronized (collection) {
            for (AspectJEditor editor : activeEditorList) {
                editor.resetTitleImage();
            }
        }
    }

    private void clearMessages() {
        affectedResources.clear();
        this.problems.clear();
    }

    private IResource locationToResource(ISourceLocation isl, IProject project) {
        IResource ir = null;
        File file = isl.getSourceFile();
        String loc = file.getPath();
        if (!file.exists()) {
            loc = loc.replace('!', File.separatorChar);
        }
        if ((ir = AJDTUtils.findResource(loc, project)) == null) {
            ir = AJDTUtils.findResource(loc);
            if (ir == null) {
                ir = this.tryToFindResource(loc, project);
            }
            if (ir == null) {
                AJLog.log((int)1, (String)("Whilst adding post compilation markers to resources, cannot locate valid eclipse resource for file " + loc));
            }
        }
        return ir;
    }

    private IResource tryToFindResource(String fileName, IProject project) {
        IProject ret = null;
        String toFind = fileName.replace('\\', '/');
        IJavaProject jProject = JavaCore.create((IProject)project);
        try {
            IClasspathEntry[] classpathEntries = jProject.getResolvedClasspath(false);
            int i = 0;
            while (i < classpathEntries.length) {
                IClasspathEntry cpEntry = classpathEntries[i];
                if (cpEntry.getEntryKind() == 3) {
                    IPath sourcePath = cpEntry.getPath();
                    IResource memberResource = project.findMember(sourcePath = sourcePath.removeFirstSegments(1));
                    if (memberResource != null) {
                        IResource[] srcContainer = new IResource[]{memberResource};
                        ret = this.findFile(srcContainer, toFind);
                    }
                } else if (cpEntry.getEntryKind() == 2) {
                    IPath projPath = cpEntry.getPath();
                    IResource projResource = AspectJPlugin.getWorkspace().getRoot().findMember(projPath);
                    if (projResource != null) {
                        ret = this.findFile(new IResource[]{projResource}, toFind);
                    }
                }
                if (ret == null) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (JavaModelException javaModelException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_3);
            JavaModelException jmEx = javaModelException;
            AJDTErrorHandler.handleAJDTError(UIMessages.jmCoreException, jmEx);
        }
        if (ret == null) {
            ret = project;
        }
        return ret;
    }

    private IResource findFile(IResource[] srcContainer, String name) {
        IResource ret = null;
        try {
            int i = 0;
            while (i < srcContainer.length) {
                IResource ir = srcContainer[i];
                if (ir != null) {
                    if (ir.getFullPath().toString().endsWith(name)) {
                        ret = ir;
                        break;
                    }
                    if (ir instanceof IContainer && (ret = this.findFile(((IContainer)ir).members(), name)) != null) break;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(exception, this, ajc$tjp_4, (JoinPoint.StaticPart)ajc$tjp_5);
        }
        return ret;
    }

    private int getTaskPriority(ProblemTracker p) {
        if (p == null) {
            return -1;
        }
        String message = p.message;
        Preferences pref = JavaCore.getPlugin().getPluginPreferences();
        String tags = pref.getString("org.eclipse.jdt.core.compiler.taskTags");
        String caseSens = pref.getString("org.eclipse.jdt.core.compiler.taskCaseSensitive");
        String priorities = pref.getString("org.eclipse.jdt.core.compiler.taskPriorities");
        boolean caseSensitive = !caseSens.equals("disabled");
        StringTokenizer tagTokens = new StringTokenizer(tags, ",");
        StringTokenizer priorityTokens = new StringTokenizer(priorities, ",");
        while (tagTokens.hasMoreTokens()) {
            String temp;
            String prio = priorityTokens.nextToken();
            String token = tagTokens.nextToken();
            if (!(caseSensitive ? message.startsWith(token) : token.length() <= message.length() && token.compareToIgnoreCase(temp = message.substring(0, token.length())) == 0)) continue;
            return this.getPrioritiyFlag(prio);
        }
        return -1;
    }

    private int getPrioritiyFlag(String prio) {
        if (prio.equals("NORMAL")) {
            return 1;
        }
        if (prio.equals("HIGH")) {
            return 2;
        }
        return 0;
    }

    private void addOtherProjectMarker(IProject p, IMarker m) {
        if (!otherProjectMarkers.containsKey(p.getName())) {
            otherProjectMarkers.put(p.getName(), new ArrayList());
        }
        List<?> l = otherProjectMarkers.get(p.getName());
        l.add(m);
    }

    private void setSeverity(IMarker marker, IMessage.Kind kind) throws CoreException {
        if (kind == IMessage.ERROR) {
            marker.setAttribute("severity", (Object)new Integer(2));
        } else if (kind == IMessage.WARNING) {
            marker.setAttribute("severity", (Object)new Integer(1));
        } else {
            marker.setAttribute("severity", (Object)new Integer(0));
        }
    }

    private void setMessage(IMarker marker, String message) throws CoreException {
        if (message == null) {
            return;
        }
        if (message.indexOf("\":") != -1 && message.indexOf(", at line") != -1) {
            String hackedMessage = message.substring(message.indexOf("\":") + 2);
            message = hackedMessage.substring(0, hackedMessage.indexOf(", at line"));
        }
        if (message.length() >= MAX_MESSAGE_LENGTH) {
            message = message.substring(0, MAX_MESSAGE_LENGTH - 1);
        }
        marker.setAttribute("message", (Object)message);
    }

    protected void setLastBuildType(boolean wasFullBuild) {
        lastBuildWasFull = wasFullBuild;
    }

    void clearProblems() {
        Iterator<ProblemTracker> probIter = this.problems.iterator();
        while (probIter.hasNext()) {
            ProblemTracker problem = probIter.next();
            if (problem.location == null) continue;
            probIter.remove();
        }
    }

    public static void clearOtherProjectMarkers(IProject p) {
        List<?> l = otherProjectMarkers.get(p.getName());
        if (l != null) {
            ListIterator<?> li = l.listIterator();
            while (li.hasNext()) {
                IMarker m = (IMarker)li.next();
                try {
                    m.delete();
                }
                catch (CoreException coreException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(coreException, ajc$tjp_6, (JoinPoint.StaticPart)ajc$tjp_7);
                }
            }
            l.clear();
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("UIMessageHandler.java", UIMessageHandler.class);
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.ajde.UIMessageHandler", "org.eclipse.core.runtime.CoreException", "cEx"), 347);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "showMessages", "org.eclipse.ajdt.internal.ui.ajde.UIMessageHandler", "org.eclipse.core.resources.IProject", "project", "", "void"), 214);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.ajde.UIMessageHandler", "org.eclipse.jdt.core.JavaModelException", "jmEx"), 438);
        ajc$tjp_3 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "tryToFindResource", "org.eclipse.ajdt.internal.ui.ajde.UIMessageHandler", "java.lang.String:org.eclipse.core.resources.IProject", "fileName:project", "", "org.eclipse.core.resources.IResource"), 406);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.ajde.UIMessageHandler", "java.lang.Exception", "<missing>"), 464);
        ajc$tjp_5 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "findFile", "org.eclipse.ajdt.internal.ui.ajde.UIMessageHandler", "[Lorg.eclipse.core.resources.IResource;:java.lang.String", "srcContainer:name", "", "org.eclipse.core.resources.IResource"), 447);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.ajde.UIMessageHandler", "org.eclipse.core.runtime.CoreException", "<missing>"), 622);
        ajc$tjp_7 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("9", "clearOtherProjectMarkers", "org.eclipse.ajdt.internal.ui.ajde.UIMessageHandler", "org.eclipse.core.resources.IProject", "p", "", "void"), 614);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ProblemTracker {
        public ISourceLocation location;
        public String message;
        public IMessage.Kind kind;
        public boolean declaredErrorOrWarning = false;
        public List<ISourceLocation> extraLocs;
        public Throwable thrown;
        public int id;
        public int start;
        public int end;

        public ProblemTracker(String m, ISourceLocation l, IMessage.Kind k) {
            this(m, l, k, false, null, -1, -1, -1, null);
        }

        public ProblemTracker(String m, ISourceLocation l, IMessage.Kind k, boolean deow, List<ISourceLocation> extraLocs, int id, int start, int end, Throwable thrown) {
            this.location = l;
            this.message = m;
            this.kind = k;
            this.declaredErrorOrWarning = deow;
            this.extraLocs = extraLocs;
            this.id = id;
            this.start = start;
            this.end = end;
            this.thrown = thrown;
        }
    }
}

