/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.visualiser.views;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import org.eclipse.contribution.visualiser.VisualiserPlugin;
import org.eclipse.contribution.visualiser.core.ProviderManager;
import org.eclipse.contribution.visualiser.core.RendererManager;
import org.eclipse.contribution.visualiser.core.Stripe;
import org.eclipse.contribution.visualiser.interfaces.IGroup;
import org.eclipse.contribution.visualiser.interfaces.IMarkupKind;
import org.eclipse.contribution.visualiser.interfaces.IMarkupProvider;
import org.eclipse.contribution.visualiser.interfaces.IMember;
import org.eclipse.contribution.visualiser.interfaces.IVisualiserRenderer;
import org.eclipse.contribution.visualiser.internal.preference.VisualiserPreferences;
import org.eclipse.contribution.visualiser.jdtImpl.JDTContentProvider;
import org.eclipse.contribution.visualiser.renderers.PatternVisualiserRenderer;
import org.eclipse.contribution.visualiser.text.VisualiserMessages;
import org.eclipse.contribution.visualiser.utils.ColorConstants;
import org.eclipse.contribution.visualiser.views.Visualiser;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;

public class VisualiserCanvas
extends Canvas {
    public static Color VIS_BG_COLOUR = ColorConstants.menuBackground;
    private float vScale;
    private static final int zoomMax = 20;
    private static final int zoomSc = 10;
    private int zoomFactor = 10;
    private boolean zoomChanged = false;
    private List data;
    private int maxSize;
    private int colWidth;
    private int reqWidth;
    private int reqHeight;
    private boolean dataChanged = true;
    private boolean scrollToSelection = false;
    private Image screenImg;
    private Image cImg;
    private SoftReference[] colImgDataSR;
    private ColumnGeom[] columns;
    private Visualiser visualiser;
    private ISelectable selectedItem;
    private ISelectable lastSelected;
    private Timer timer = new Timer();
    private TimerTask dismissToolTipTask;
    private TimerTask postToolTipTask;
    private Shell toolTip;
    private Menu contextMenu;

    public VisualiserCanvas(Composite parent, Visualiser vis) {
        super(parent, 264960);
        this.visualiser = vis;
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                if (VisualiserCanvas.this.visualiser.isFitToView()) {
                    VisualiserCanvas.this.redraw(VisualiserCanvas.this.data);
                } else {
                    VisualiserCanvas.this.configScrollBars();
                }
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                VisualiserCanvas.this.paint(event.gc);
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                Object o = VisualiserCanvas.this.locationToObject(e.x, e.y);
                if (o != null && o instanceof ISelectable) {
                    ISelectable is = (ISelectable)o;
                    Stripe s = null;
                    if (is instanceof StripeGeom) {
                        s = ((StripeGeom)is).stripe;
                    }
                    VisualiserCanvas.this.visualiser.handleClick(is.getMember(), s, e.button);
                }
            }

            public void mouseDown(MouseEvent e) {
                VisualiserCanvas.this.cancelToolTip();
                Object o = VisualiserCanvas.this.locationToObject(e.x, e.y);
                if (o != null && o instanceof ISelectable) {
                    VisualiserCanvas.this.setSelectedItem((ISelectable)o);
                    VisualiserCanvas.this.scrollToSelection = true;
                    VisualiserCanvas.this.redraw();
                } else if (VisualiserCanvas.this.selectedItem != null) {
                    VisualiserCanvas.this.setSelectedItem(null);
                    VisualiserCanvas.this.redraw();
                }
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (VisualiserCanvas.this.postToolTipTask != null) {
                    VisualiserCanvas.this.postToolTipTask.cancel();
                }
                VisualiserCanvas.this.postToolTipTask = new ToolTipTimerTask(e);
                VisualiserCanvas.this.timer.schedule(VisualiserCanvas.this.postToolTipTask, 750L);
            }
        });
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                VisualiserCanvas.this.handleKeyPress(e);
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (VisualiserCanvas.this.lastSelected != null) {
                    VisualiserCanvas.this.setSelectedItem(VisualiserCanvas.this.lastSelected);
                    VisualiserCanvas.this.redraw();
                }
            }

            public void focusLost(FocusEvent e) {
                VisualiserCanvas.this.lastSelected = VisualiserCanvas.this.selectedItem;
                if (VisualiserCanvas.this.selectedItem != null) {
                    VisualiserCanvas.this.setSelectedItem(null);
                    VisualiserCanvas.this.redraw();
                }
            }
        });
        this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                VisualiserCanvas.this.cancelToolTip();
            }
        });
        this.setupScrollbarListeners();
        this.setupContextMenu();
    }

    private void setSelectedItem(ISelectable newItem) {
        if (this.selectedItem == null && newItem != null) {
            this.setMenu(this.contextMenu);
        } else if (this.selectedItem != null && newItem == null) {
            this.setMenu(null);
        }
        this.selectedItem = newItem;
    }

    private void setupContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        Action onlyShowAction = new Action(){

            public void run() {
                if (VisualiserCanvas.this.selectedItem != null) {
                    VisualiserPlugin.visualiser.onlyShowColorsAffecting(VisualiserCanvas.this.selectedItem.getMember().getFullname());
                }
            }
        };
        onlyShowAction.setText(VisualiserMessages.OnlyShow);
        menuMgr.add((IAction)onlyShowAction);
        this.contextMenu = menuMgr.createContextMenu((Control)this);
    }

    private void showToolTip(String text, Point point) {
        this.cancelToolTip();
        this.toolTip = new Shell(this.getDisplay(), 16388);
        this.toolTip.setLayout((Layout)new FillLayout());
        Label tipLabel = new Label((Composite)this.toolTip, 0);
        tipLabel.setForeground(this.getDisplay().getSystemColor(28));
        tipLabel.setBackground(this.getDisplay().getSystemColor(29));
        tipLabel.setText(text);
        Point size = this.toolTip.computeSize(-1, -1);
        this.toolTip.setBounds(point.x, point.y + 20, size.x, size.y);
        this.toolTip.setVisible(true);
        this.dismissToolTipTask = new TimerTask(){

            public void run() {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        VisualiserCanvas.this.cancelToolTip();
                    }
                });
            }
        };
        this.timer.schedule(this.dismissToolTipTask, 5000L);
    }

    private void cancelToolTip() {
        if (this.postToolTipTask != null) {
            this.postToolTipTask.cancel();
            this.postToolTipTask = null;
        }
        if (this.dismissToolTipTask != null) {
            this.dismissToolTipTask.cancel();
            this.dismissToolTipTask = null;
        }
        if (this.toolTip != null && !this.toolTip.isDisposed()) {
            this.toolTip.dispose();
            this.toolTip = null;
        }
    }

    private void handleKeyPress(KeyEvent ke) {
        if (this.data == null || this.data.size() == 0) {
            return;
        }
        this.lastSelected = this.selectedItem;
        if (ke.character == ' ') {
            if (this.selectedItem != null) {
                Stripe s = null;
                if (this.selectedItem instanceof StripeGeom) {
                    s = ((StripeGeom)this.selectedItem).stripe;
                }
                this.visualiser.handleClick(this.selectedItem.getMember(), s, 1);
            }
        } else if (ke.character == '\t') {
            this.scrollToSelection = true;
            this.cancelToolTip();
            if (this.selectedItem == null) {
                this.setSelectedItem(this.columns[0]);
            } else if ((ke.stateMask & 0x20000) == 0) {
                this.moveSelectionForward();
            } else {
                this.moveSelectionBack();
            }
        } else if (ke.keyCode == 0x1000001) {
            this.scrollToSelection = true;
            this.cancelToolTip();
            this.moveSelectionUp();
        } else if (ke.keyCode == 0x1000002) {
            this.scrollToSelection = true;
            this.cancelToolTip();
            this.moveSelectionDown();
        } else if (ke.keyCode == 0x1000003) {
            this.scrollToSelection = true;
            this.cancelToolTip();
            this.moveSelectionLeft();
        } else if (ke.keyCode == 0x1000004) {
            this.scrollToSelection = true;
            this.cancelToolTip();
            this.moveSelectionRight();
        } else if (ke.keyCode == 0x100000B) {
            if (this.selectedItem != null) {
                this.cancelToolTip();
                String label = this.selectedItem instanceof StripeGeom ? ((StripeGeom)this.selectedItem).stripe.getToolTip() : this.selectedItem.getMember().getToolTip();
                int x = this.selectedItem.getBounds().x;
                Point dp = this.toDisplay(x += this.selectedItem.getIndex() * this.colWidth, this.selectedItem.getBounds().y);
                this.showToolTip(label, dp);
            }
        } else if (ke.keyCode == 27) {
            this.cancelToolTip();
        } else if (ke.character == '+') {
            if (!this.visualiser.isFitToView()) {
                this.zoomIn();
            }
        } else if (ke.character == '-' && !this.visualiser.isFitToView()) {
            this.zoomOut();
        }
        if (this.selectedItem != this.lastSelected) {
            this.redraw();
        }
    }

    private void moveSelectionForward() {
        int ni;
        this.moveSelectionDown();
        if (this.selectedItem == this.lastSelected && (ni = this.selectedItem.getIndex() + 1) < this.columns.length) {
            this.setSelectedItem(this.columns[ni]);
        }
    }

    private void moveSelectionBack() {
        if (this.selectedItem instanceof ColumnGeom) {
            int ni = this.selectedItem.getIndex() - 1;
            if (ni >= 0) {
                BarGeom bg = (BarGeom)this.columns[ni].barList.get(this.columns[ni].barList.size() - 1);
                if (bg.stripeList.size() > 0) {
                    this.setSelectedItem((StripeGeom)bg.stripeList.get(bg.stripeList.size() - 1));
                } else {
                    this.setSelectedItem(bg);
                }
            }
        } else if (this.selectedItem instanceof BarGeom) {
            int ind = ((BarGeom)this.selectedItem).index;
            int ni = this.columns[ind].barList.indexOf(this.selectedItem) - 1;
            if (ni >= 0) {
                BarGeom bg = (BarGeom)this.columns[ind].barList.get(ni);
                if (bg.stripeList.size() > 0) {
                    this.setSelectedItem((StripeGeom)bg.stripeList.get(bg.stripeList.size() - 1));
                } else {
                    this.setSelectedItem(bg);
                }
            } else {
                this.setSelectedItem(this.columns[ind]);
            }
        } else {
            this.moveSelectionUp();
        }
    }

    private void moveSelectionUp() {
        if (this.selectedItem == null) {
            this.setSelectedItem(this.columns[0]);
        } else if (this.selectedItem instanceof BarGeom) {
            int ind = ((BarGeom)this.selectedItem).index;
            int ni = this.columns[ind].barList.indexOf(this.selectedItem) - 1;
            if (ni >= 0) {
                this.setSelectedItem((BarGeom)this.columns[ind].barList.get(ni));
            } else {
                this.setSelectedItem(this.columns[ind]);
            }
        } else if (this.selectedItem instanceof StripeGeom) {
            StripeGeom sg = (StripeGeom)this.selectedItem;
            int ni = sg.parent.stripeList.indexOf(sg) - 1;
            if (ni >= 0) {
                this.setSelectedItem((StripeGeom)sg.parent.stripeList.get(ni));
            } else {
                this.setSelectedItem(sg.parent);
            }
        }
    }

    private void moveSelectionDown() {
        if (this.selectedItem == null) {
            this.setSelectedItem(this.columns[0]);
        } else if (this.selectedItem instanceof ColumnGeom) {
            this.setSelectedItem((BarGeom)((ColumnGeom)this.selectedItem).barList.get(0));
        } else if (this.selectedItem instanceof BarGeom) {
            BarGeom bg = (BarGeom)this.selectedItem;
            if (bg.stripeList.size() > 0) {
                this.setSelectedItem((StripeGeom)bg.stripeList.get(0));
            } else {
                int ind = ((BarGeom)this.selectedItem).index;
                int ni = this.columns[ind].barList.indexOf(this.selectedItem) + 1;
                if (ni < this.columns[ind].barList.size()) {
                    this.setSelectedItem((BarGeom)this.columns[ind].barList.get(ni));
                }
            }
        } else if (this.selectedItem instanceof StripeGeom) {
            StripeGeom sg = (StripeGeom)this.selectedItem;
            int ni = sg.parent.stripeList.indexOf(sg) + 1;
            if (ni < sg.parent.stripeList.size()) {
                this.setSelectedItem((StripeGeom)sg.parent.stripeList.get(ni));
            } else {
                ni = this.columns[sg.index].barList.indexOf(sg.parent) + 1;
                if (ni < this.columns[sg.index].barList.size()) {
                    this.setSelectedItem((BarGeom)this.columns[sg.index].barList.get(ni));
                }
            }
        }
    }

    private void moveSelectionLeft() {
        int ni;
        if (this.selectedItem == null) {
            this.setSelectedItem(this.columns[0]);
        }
        if (this.selectedItem instanceof ColumnGeom) {
            int ni2 = ((ColumnGeom)this.selectedItem).index - 1;
            if (ni2 >= 0) {
                this.setSelectedItem(this.columns[ni2]);
            }
        } else if (this.selectedItem instanceof BarGeom) {
            int ni3 = ((BarGeom)this.selectedItem).index - 1;
            if (ni3 >= 0) {
                if (this.columns[ni3].barList.size() > 1) {
                    this.setSelectedItem(this.closestVertically(this.selectedItem, this.columns[ni3].barList));
                } else {
                    this.setSelectedItem((BarGeom)this.columns[ni3].barList.get(0));
                }
            }
        } else if (this.selectedItem instanceof StripeGeom && (ni = ((StripeGeom)this.selectedItem).index - 1) >= 0) {
            ArrayList allStripes = new ArrayList();
            for (BarGeom bg : this.columns[ni].barList) {
                allStripes.addAll(bg.stripeList);
            }
            if (allStripes.size() > 0) {
                this.setSelectedItem(this.closestVertically(this.selectedItem, allStripes));
            } else if (this.columns[ni].barList.size() > 1) {
                this.setSelectedItem(this.closestVertically(this.selectedItem, this.columns[ni].barList));
            } else {
                this.setSelectedItem((BarGeom)this.columns[ni].barList.get(0));
            }
        }
    }

    private void moveSelectionRight() {
        int ni;
        if (this.selectedItem == null) {
            this.setSelectedItem(this.columns[0]);
        }
        if (this.selectedItem instanceof ColumnGeom) {
            int ni2 = ((ColumnGeom)this.selectedItem).index + 1;
            if (ni2 < this.columns.length) {
                this.setSelectedItem(this.columns[ni2]);
            }
        } else if (this.selectedItem instanceof BarGeom) {
            int ni3 = ((BarGeom)this.selectedItem).index + 1;
            if (ni3 < this.columns.length) {
                if (this.columns[ni3].barList.size() > 1) {
                    this.setSelectedItem(this.closestVertically(this.selectedItem, this.columns[ni3].barList));
                } else {
                    this.setSelectedItem((BarGeom)this.columns[ni3].barList.get(0));
                }
            }
        } else if (this.selectedItem instanceof StripeGeom && (ni = ((StripeGeom)this.selectedItem).index + 1) < this.columns.length) {
            ArrayList allStripes = new ArrayList();
            for (BarGeom bg : this.columns[ni].barList) {
                allStripes.addAll(bg.stripeList);
            }
            if (allStripes.size() > 0) {
                this.setSelectedItem(this.closestVertically(this.selectedItem, allStripes));
            } else if (this.columns[ni].barList.size() > 1) {
                this.setSelectedItem(this.closestVertically(this.selectedItem, this.columns[ni].barList));
            } else {
                this.setSelectedItem((BarGeom)this.columns[ni].barList.get(0));
            }
        }
    }

    private ISelectable closestVertically(ISelectable from, List candList) {
        int y = from.getBounds().y;
        int offset = Integer.MAX_VALUE;
        ISelectable closest = null;
        for (ISelectable is : candList) {
            int d = Math.abs(y - is.getBounds().y);
            if (d >= offset) continue;
            closest = is;
            offset = d;
        }
        return closest;
    }

    private Object locationToObject(int ex, int ey) {
        int col;
        if (this.data == null || this.data.size() == 0) {
            return null;
        }
        if (this.isDisposed()) {
            return null;
        }
        int x = ex + this.getHorizontalBar().getSelection();
        int y = ey + this.getVerticalBar().getSelection();
        int mh = this.getRenderer().getMarginSize();
        int hh = this.getRenderer().getColumnHeaderHeight();
        int width = this.scale(this.colWidth);
        int spacing = this.getScaledSpacing();
        if ((x -= mh) >= 0 && y >= 0 && x <= (col = x / (width + spacing)) * (width + spacing) + width && col < this.columns.length) {
            if (y <= mh) {
                return null;
            }
            if (y <= mh + hh) {
                return this.columns[col];
            }
            if (y <= this.columns[col].bounds.y + this.scale(this.columns[col].bounds.height - this.getRenderer().getColumnHeaderHeight()) + this.getRenderer().getColumnHeaderHeight()) {
                List bars = this.columns[col].barList;
                int i = 0;
                while (i < bars.size()) {
                    BarGeom bg = (BarGeom)bars.get(i);
                    if (y <= this.scaleExH(bg.bounds.y) + this.scale(bg.bounds.height)) {
                        List stripes = bg.stripeList;
                        int j = 0;
                        while (j < stripes.size()) {
                            StripeGeom sg = (StripeGeom)stripes.get(j);
                            if (y >= this.scaleExH(sg.bounds.y) && y <= this.scaleExH(sg.bounds.y) + this.scaleStripeHeight(sg.bounds.height)) {
                                return sg;
                            }
                            ++j;
                        }
                        return bg;
                    }
                    ++i;
                }
                return this.columns[col];
            }
        }
        return null;
    }

    public void redraw(List data) {
        this.data = data;
        if (data == null || data.size() == 0) {
            this.redraw();
            return;
        }
        this.maxSize = 0;
        this.lastSelected = null;
        if (this.toolTip != null && !this.toolTip.isDisposed()) {
            this.toolTip.dispose();
        }
        this.calculateGeom();
        this.dataChanged = true;
        this.redraw();
    }

    private int zoomValidRange(int f) {
        if (f > 20) {
            f = 20;
        } else if (f * this.colWidth / 10 < this.visualiser.getMinBarSize()) {
            f = this.visualiser.getMinBarSize() * 10 / this.colWidth;
        }
        return f;
    }

    public void zoomIn() {
        int newZoom = this.zoomValidRange(this.zoomFactor + 1);
        if (this.zoomFactor != newZoom) {
            this.visualiser.zoomoutSetEnabled(true);
            this.zoomFactor = newZoom;
            this.zoomChanged = true;
            this.visualiser.setZoomString(String.valueOf(this.zoomFactor * 10) + "%");
            this.redraw();
        }
        if (this.zoomFactor < 20) {
            this.visualiser.zoominSetEnabled(true);
        } else {
            this.visualiser.zoominSetEnabled(false);
        }
    }

    public void zoomOut() {
        int newZoom = this.zoomValidRange(this.zoomFactor - 1);
        if (this.zoomFactor != newZoom) {
            this.visualiser.zoominSetEnabled(true);
            this.zoomFactor = newZoom;
            this.zoomChanged = true;
            this.visualiser.setZoomString(String.valueOf(this.zoomFactor * 10) + "%");
            this.redraw();
        }
        if ((this.zoomFactor - 1) * this.colWidth / 10 < this.visualiser.getMinBarSize()) {
            this.visualiser.zoomoutSetEnabled(false);
        } else {
            this.visualiser.zoomoutSetEnabled(true);
        }
    }

    public void dispose() {
        this.cancelToolTip();
        super.dispose();
    }

    private void calculateGeom() {
        this.columns = new ColumnGeom[this.data.size()];
        this.calculateWidth();
        if (this.visualiser.isGroupView()) {
            int i = 0;
            while (i < this.data.size()) {
                int y = this.getRenderer().getMarginSize() + this.getRenderer().getColumnHeaderHeight();
                IGroup ig = (IGroup)this.data.get(i);
                List mems = ig.getMembers();
                int size = 0;
                this.columns[i] = new ColumnGeom(i);
                this.columns[i].member = ig;
                int j = 0;
                while (j < mems.size()) {
                    IMember m = (IMember)mems.get(j);
                    int h = this.heightOfMember(m);
                    size += h;
                    BarGeom b = new BarGeom(i);
                    b.member = m;
                    b.bounds = new Rectangle(0, y, this.colWidth, h);
                    this.columns[i].barList.add(b);
                    this.calculateStripeGeom(m, b);
                    y += h;
                    ++j;
                }
                this.columns[i].bounds = new Rectangle(0, this.getRenderer().getMarginSize(), this.colWidth, size + this.getRenderer().getColumnHeaderHeight());
                if (size > this.maxSize) {
                    this.maxSize = size;
                }
                ++i;
            }
        } else {
            int y = this.getRenderer().getMarginSize() + this.getRenderer().getColumnHeaderHeight();
            int i = 0;
            while (i < this.data.size()) {
                IMember m = (IMember)this.data.get(i);
                this.columns[i] = new ColumnGeom(i);
                this.columns[i].member = m;
                int h = this.heightOfMember(m);
                this.columns[i].bounds = new Rectangle(0, this.getRenderer().getMarginSize(), this.colWidth, h + this.getRenderer().getColumnHeaderHeight());
                if (h > this.maxSize) {
                    this.maxSize = h;
                }
                BarGeom b = new BarGeom(i);
                b.member = m;
                b.bounds = new Rectangle(0, y, this.colWidth, h);
                this.columns[i].barList.add(b);
                this.calculateStripeGeom(m, b);
                ++i;
            }
        }
        if (this.visualiser.isFitToView()) {
            int mh = this.getRenderer().getMarginSize();
            int hh = this.getRenderer().getColumnHeaderHeight();
            Rectangle clientRect = this.getClientArea();
            int viewH = clientRect.height - hh - 2 * mh;
            this.vScale = (float)this.maxSize / (float)viewH;
            this.maxSize = viewH;
            int i = 0;
            while (i < this.columns.length) {
                this.columns[i].bounds.height = (int)((float)(this.columns[i].bounds.height - hh) / this.vScale + (float)hh);
                List bars = this.columns[i].barList;
                int j = 0;
                while (j < bars.size()) {
                    BarGeom bg = (BarGeom)bars.get(j);
                    bg.bounds.height = (int)((float)bg.bounds.height / this.vScale);
                    int oldy = bg.bounds.y;
                    bg.bounds.y = (int)((float)(bg.bounds.y - hh - mh) / this.vScale) + hh + mh;
                    List stripes = bg.stripeList;
                    int k = 0;
                    while (k < stripes.size()) {
                        StripeGeom sg = (StripeGeom)stripes.get(k);
                        sg.bounds.y = (int)((float)(sg.bounds.y - oldy) / this.vScale) + bg.bounds.y;
                        if (sg.bounds.y + sg.bounds.height > bg.bounds.y + bg.bounds.height) {
                            sg.bounds.height = bg.bounds.y + bg.bounds.height - sg.bounds.y;
                        }
                        List kinds = sg.kindList;
                        int l = 0;
                        while (l < kinds.size()) {
                            KindGeom kg = (KindGeom)kinds.get(l);
                            kg.bounds.y = sg.bounds.y;
                            kg.bounds.height = sg.bounds.height;
                            ++l;
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private void calculateStripeGeom(IMember m, BarGeom b) {
        int soffset = 0;
        IMarkupProvider vmp = this.visualiser.getVisMarkupProvider();
        List markups = vmp.getMemberMarkups(m);
        if (markups != null && markups.size() > 0) {
            TreeSet<Stripe> sortedSet = new TreeSet<Stripe>();
            int i = 0;
            while (i < markups.size()) {
                Stripe s = (Stripe)markups.get(i);
                if (s != null) {
                    sortedSet.add(s);
                }
                ++i;
            }
            for (Stripe s : sortedSet) {
                int stripeH;
                int activeKinds = 0;
                int i2 = 0;
                while (i2 < s.getKinds().size()) {
                    IMarkupKind kind = (IMarkupKind)s.getKinds().get(i2);
                    if (VisualiserPlugin.menu == null || VisualiserPlugin.menu.getActive(kind)) {
                        ++activeKinds;
                    }
                    ++i2;
                }
                if (activeKinds <= 0) continue;
                int across = 0;
                int offsetY = s.getOffset() - 1;
                if (offsetY < 0) {
                    offsetY = 0;
                }
                if ((stripeH = VisualiserPreferences.getStripeHeight()) < s.getDepth()) {
                    stripeH = s.getDepth();
                }
                int ypos = offsetY + soffset;
                StripeGeom sg = new StripeGeom(b.index);
                sg.parent = b;
                sg.member = m;
                sg.stripe = s;
                b.stripeList.add(sg);
                sg.bounds = new Rectangle(b.bounds.x + 1, b.bounds.y + ypos, this.colWidth - 2, stripeH);
                int i3 = 0;
                while (i3 < s.getKinds().size()) {
                    IMarkupKind kind = (IMarkupKind)s.getKinds().get(i3);
                    if (VisualiserPlugin.menu == null || VisualiserPlugin.menu.getActive(kind)) {
                        Rectangle kindRect;
                        KindGeom kg = new KindGeom();
                        sg.kindList.add(kg);
                        kg.color = this.visualiser.getVisMarkupProvider().getColorFor(kind);
                        if (kg.color == null) {
                            throw new NullPointerException(VisualiserMessages.getColorForError);
                        }
                        int nw = (across + 1) * this.colWidth / activeKinds - across * this.colWidth / activeKinds;
                        kg.bounds = kindRect = new Rectangle(b.bounds.x + 1 + across * this.colWidth / activeKinds, b.bounds.y + ypos, nw - 1, sg.bounds.height);
                        ++across;
                    }
                    ++i3;
                }
            }
            this.spaceOutStripes(b.stripeList);
            this.spaceOutStripes(b.stripeList);
            this.avoidOverspill(b.stripeList);
        }
    }

    private void avoidOverspill(List stripeList) {
        int i = 0;
        while (i < stripeList.size()) {
            StripeGeom sg = (StripeGeom)stripeList.get(i);
            int endStripeY = sg.bounds.y + sg.bounds.height;
            int endBarY = sg.parent.bounds.y + sg.parent.bounds.height;
            if (endStripeY > endBarY) {
                int move = endStripeY - endBarY;
                int maxMove = sg.bounds.y - sg.parent.bounds.y;
                if (move <= maxMove) {
                    sg.moveVertically(-move);
                } else {
                    sg.moveVertically(-maxMove);
                    sg.reduceHeight(move - maxMove);
                }
            }
            ++i;
        }
    }

    private void spaceOutStripes(List stripeList) {
        int i = 0;
        while (i < stripeList.size()) {
            StripeGeom sg2;
            StripeGeom sg1 = (StripeGeom)stripeList.get(i);
            if (i > 0 && sg1.overlaps(sg2 = (StripeGeom)stripeList.get(i - 1)) && sg1.bounds.y + sg1.bounds.height < sg1.parent.bounds.y + sg1.parent.bounds.y) {
                sg1.moveVertically(1);
            }
            if (i + 1 < stripeList.size() && sg1.overlaps(sg2 = (StripeGeom)stripeList.get(i + 1)) && sg1.bounds.y > sg1.parent.bounds.y) {
                sg1.moveVertically(-1);
            }
            ++i;
        }
    }

    private int heightOfMember(IMember m) {
        int size = m.getSize();
        return size;
    }

    private void calculateWidth() {
        if (this.data == null || this.data.size() <= 0) {
            return;
        }
        if (this.visualiser.isFitToView()) {
            Rectangle clientRect = this.getClientArea();
            int space = clientRect.width - 2 * this.getRenderer().getMarginSize();
            int equalWidth = space / this.data.size() - this.getRenderer().getSpacing();
            this.colWidth = equalWidth < this.visualiser.getMinBarSize() ? this.visualiser.getMinBarSize() : (equalWidth > this.visualiser.getMaxBarSize() ? this.visualiser.getMaxBarSize() : equalWidth);
        } else {
            this.colWidth = VisualiserPreferences.getBarWidth();
        }
    }

    private void setupScrollbarListeners() {
        ScrollBar horiz = this.getHorizontalBar();
        horiz.setEnabled(false);
        horiz.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                VisualiserCanvas.this.scrollToSelection = false;
                VisualiserCanvas.this.redraw();
            }
        });
        ScrollBar vert = this.getVerticalBar();
        vert.setEnabled(false);
        vert.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                VisualiserCanvas.this.scrollToSelection = false;
                VisualiserCanvas.this.redraw();
            }
        });
    }

    private void configScrollBars() {
        Rectangle clientRect = this.getClientArea();
        ScrollBar horiz = this.getHorizontalBar();
        if (this.reqWidth > clientRect.width) {
            horiz.setEnabled(true);
            horiz.setMaximum(this.reqWidth);
            horiz.setThumb(clientRect.width);
        } else {
            horiz.setSelection(0);
            horiz.setMaximum(clientRect.width);
            horiz.setThumb(clientRect.width);
            horiz.setEnabled(false);
        }
        ScrollBar vert = this.getVerticalBar();
        if (this.reqHeight > clientRect.height) {
            vert.setEnabled(true);
            vert.setMaximum(this.reqHeight);
            vert.setThumb(clientRect.height);
        } else {
            vert.setSelection(0);
            vert.setMaximum(clientRect.width);
            vert.setThumb(clientRect.width);
            vert.setEnabled(false);
        }
    }

    private IVisualiserRenderer getRenderer() {
        return RendererManager.getCurrentRenderer().getRenderer();
    }

    private void paint(GC gc) {
        Rectangle clientRect = this.getClientArea();
        if (this.screenImg == null || clientRect.width > this.screenImg.getBounds().width || clientRect.height > this.screenImg.getBounds().height) {
            if (this.screenImg != null) {
                this.screenImg.dispose();
            }
            this.screenImg = new Image((Device)this.getDisplay(), clientRect.width, clientRect.height);
        }
        GC sgc = new GC((Drawable)this.screenImg);
        sgc.setBackground(VIS_BG_COLOUR);
        sgc.fillRectangle(this.screenImg.getBounds());
        if (this.data == null || this.data.size() == 0) {
            String empty = "";
            if (ProviderManager.getCurrent() != null) {
                empty = ProviderManager.getCurrent().getEmptyMessage() != null ? ProviderManager.getCurrent().getEmptyMessage() : "";
            }
            sgc.drawText(empty, this.getRenderer().getMarginSize(), this.getRenderer().getMarginSize());
            final Visualiser visualiser = VisualiserPlugin.visualiser;
            if (this.data == null && visualiser != null && visualiser.contentP != null && visualiser.contentP instanceof JDTContentProvider) {
                this.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        ((JDTContentProvider)visualiser.contentP).lookForData();
                    }
                });
            }
            this.reqWidth = 0;
            this.reqHeight = 0;
            this.configScrollBars();
        } else {
            int newZoom = this.zoomValidRange(this.zoomFactor);
            if (this.zoomFactor != newZoom) {
                this.zoomFactor = newZoom;
                this.zoomChanged = true;
                this.visualiser.setZoomString(String.valueOf(this.zoomFactor * 10) + "%");
            }
            int width = this.scale(this.colWidth);
            int spacing = this.getScaledSpacing();
            int eachWidth = width + spacing;
            if (this.dataChanged || this.zoomChanged) {
                this.dataChanged = false;
                this.zoomChanged = false;
                this.setSelectedItem(null);
                this.reqWidth = this.data.size() * eachWidth + 2 * this.getRenderer().getMarginSize();
                this.reqHeight = this.scale(this.maxSize) + 2 * this.getRenderer().getMarginSize() + this.getRenderer().getColumnHeaderHeight();
                if (this.cImg != null) {
                    this.cImg.dispose();
                }
                this.cImg = new Image((Device)this.getDisplay(), eachWidth, this.reqHeight);
                this.colImgDataSR = new SoftReference[this.data.size()];
                this.configScrollBars();
            }
            int scrollh = this.getHorizontalBar().getSelection();
            int scrollv = this.getVerticalBar().getSelection();
            int startcol = (scrollh - this.getRenderer().getMarginSize()) / eachWidth;
            if (startcol < 0) {
                startcol = 0;
            }
            int x = this.getRenderer().getMarginSize() - scrollh;
            x += startcol * eachWidth;
            sgc.setClipping(clientRect);
            int i = startcol;
            while (i < this.data.size() && x < clientRect.width) {
                ImageData idata = null;
                if (this.colImgDataSR[i] != null) {
                    idata = (ImageData)this.colImgDataSR[i].get();
                }
                if (idata == null) {
                    idata = this.paintColumn(i);
                    this.colImgDataSR[i] = new SoftReference<ImageData>(idata);
                }
                Image tmpImg = new Image((Device)this.getDisplay(), idata);
                int ch = Math.min(clientRect.height - 1, this.cImg.getBounds().height - 1);
                sgc.drawImage(tmpImg, 0, scrollv, eachWidth, ch, x, 0, eachWidth, ch);
                tmpImg.dispose();
                x += eachWidth;
                ++i;
            }
        }
        if (this.selectedItem != null) {
            this.paintSelection(sgc);
        }
        gc.drawImage(this.screenImg, 0, 0, clientRect.width, clientRect.height, 0, 0, clientRect.width, clientRect.height);
        sgc.dispose();
    }

    private ImageData paintColumn(int index) {
        IMember m = (IMember)this.data.get(index);
        GC gc = new GC((Drawable)this.cImg);
        gc.setBackground(VIS_BG_COLOUR);
        gc.fillRectangle(this.cImg.getBounds());
        this.getRenderer().paintColumnHeader(gc, m, 0, this.scale(this.colWidth));
        List bars = this.columns[index].barList;
        int i = 0;
        while (i < bars.size()) {
            BarGeom bg = (BarGeom)bars.get(i);
            List stripes = bg.stripeList;
            if (stripes.size() > 0) {
                this.getRenderer().paintColumn(gc, m, bg.bounds.x, this.scaleExH(bg.bounds.y), this.scale(bg.bounds.width), this.scale(bg.bounds.height), true);
                int j = 0;
                while (j < stripes.size()) {
                    List kinds = ((StripeGeom)stripes.get((int)j)).kindList;
                    int k = 0;
                    while (k < kinds.size()) {
                        KindGeom kg = (KindGeom)kinds.get(k);
                        if (VisualiserPreferences.getUsePatterns()) {
                            PatternVisualiserRenderer.getPatternRenderer().setDitherPattern(gc, kg.color.getRGB());
                        } else {
                            gc.setBackground(kg.color);
                        }
                        gc.fillRectangle(k == 0 ? kg.bounds.x : this.scale(kg.bounds.x), this.scaleExH(kg.bounds.y), this.scale(kg.bounds.width), this.scaleStripeHeight(kg.bounds.height));
                        ++k;
                    }
                    ++j;
                }
            } else {
                this.getRenderer().paintColumn(gc, m, bg.bounds.x, this.scaleExH(bg.bounds.y), this.scale(bg.bounds.width), this.scale(bg.bounds.height), false);
            }
            ++i;
        }
        gc.dispose();
        return this.cImg.getImageData();
    }

    private void paintSelection(GC gc) {
        Rectangle r = this.selectedItem.getBounds();
        int x = this.getRenderer().getMarginSize() + this.selectedItem.getIndex() * (this.scale(this.colWidth) + this.getScaledSpacing()) + r.x - this.getHorizontalBar().getSelection();
        int y = this.scaleExH(r.y) - this.getVerticalBar().getSelection();
        Rectangle clip = gc.getClipping();
        int height = this.scale(r.height) + 1;
        int width = this.scale(r.width);
        int n = 0;
        if (this.selectedItem instanceof ColumnGeom) {
            n = 1;
            height = this.scale(r.height - this.getRenderer().getColumnHeaderHeight()) + this.getRenderer().getColumnHeaderHeight() + 1;
            y = r.y - this.getVerticalBar().getSelection();
            height += 2;
        } else if (this.selectedItem instanceof BarGeom) {
            ++height;
        } else if (this.selectedItem instanceof StripeGeom) {
            height = this.scaleStripeHeight(r.height) + 1;
        }
        Rectangle outer = new Rectangle(x - 3 - n, y - 3, width + 6 + n, height + 4);
        if (this.scrollToSelection) {
            if (outer.y < clip.y) {
                int offset = clip.y - outer.y;
                int scrollv = this.getVerticalBar().getSelection();
                this.getVerticalBar().setSelection(scrollv - offset);
                this.redraw();
                return;
            }
            if (outer.y + outer.height > clip.y + clip.height && clip.height >= outer.height) {
                int offset = outer.y + outer.height - (clip.y + clip.height);
                int scrollv = this.getVerticalBar().getSelection();
                this.getVerticalBar().setSelection(scrollv + offset);
                this.redraw();
                return;
            }
            if (outer.x + outer.width + 1 > clip.x + clip.width) {
                int offset = outer.x + outer.width + 1 - (clip.x + clip.width);
                int scrollh = this.getHorizontalBar().getSelection();
                this.getHorizontalBar().setSelection(scrollh + offset);
                this.redraw();
                return;
            }
            if (outer.x + 1 < clip.x) {
                int offset = clip.x - (outer.x + 1);
                int scrollh = this.getHorizontalBar().getSelection();
                this.getHorizontalBar().setSelection(scrollh - offset);
                this.redraw();
                return;
            }
        }
        if (this.selectedItem != null && this.selectedItem instanceof StripeGeom) {
            StripeGeom sg = (StripeGeom)this.selectedItem;
            int i = 0;
            while (i < sg.kindList.size()) {
                KindGeom kg = (KindGeom)sg.kindList.get(i);
                if (VisualiserPreferences.getUsePatterns()) {
                    PatternVisualiserRenderer.getPatternRenderer().setDitherPattern(gc, kg.color.getRGB());
                } else {
                    gc.setBackground(kg.color);
                }
                gc.fillRectangle(this.scale(kg.bounds.x) + x - 1, y, this.scale(kg.bounds.width), this.scaleStripeHeight(kg.bounds.height));
                ++i;
            }
        }
        gc.setForeground(VIS_BG_COLOUR);
        gc.drawRectangle(x - 1 - n, y - 1, width + 2 + 2 * n, height);
        gc.drawRectangle(outer);
        gc.setForeground(ColorConstants.menuForeground);
        gc.drawRectangle(x - 2 - n, y - 2, width + 4 + 2 * n, height + 2);
    }

    private int scale(int v) {
        if (this.visualiser.isFitToView()) {
            return v;
        }
        return this.zoomFactor * v / 10;
    }

    private int scaleExH(int v) {
        if (this.visualiser.isFitToView()) {
            return v;
        }
        return this.zoomFactor * (v - this.getRenderer().getMarginSize() - this.getRenderer().getColumnHeaderHeight()) / 10 + this.getRenderer().getMarginSize() + this.getRenderer().getColumnHeaderHeight();
    }

    private int scaleStripeHeight(int v) {
        if (this.visualiser.isFitToView()) {
            return v;
        }
        int scaledV = this.scale(v);
        if (scaledV < 1) {
            return 1;
        }
        return scaledV;
    }

    private int getScaledSpacing() {
        if (this.visualiser.isFitToView()) {
            return this.getRenderer().getSpacing();
        }
        return Math.max(this.scale(this.getRenderer().getSpacing()), this.getRenderer().getSpacing());
    }

    class BarGeom
    implements ISelectable {
        public Rectangle bounds;
        public int index;
        public IMember member;
        public List stripeList = new ArrayList();

        public BarGeom(int index) {
            this.index = index;
        }

        public Rectangle getBounds() {
            return this.bounds;
        }

        public int getIndex() {
            return this.index;
        }

        public IMember getMember() {
            return this.member;
        }
    }

    class ColumnGeom
    implements ISelectable {
        public Rectangle bounds;
        public int index;
        public IMember member;
        public List barList = new ArrayList();

        public ColumnGeom(int index) {
            this.index = index;
        }

        public Rectangle getBounds() {
            return this.bounds;
        }

        public int getIndex() {
            return this.index;
        }

        public IMember getMember() {
            return this.member;
        }
    }

    static interface ISelectable {
        public Rectangle getBounds();

        public int getIndex();

        public IMember getMember();
    }

    class KindGeom {
        public Rectangle bounds;
        public Color color;

        KindGeom() {
        }
    }

    class StripeGeom
    implements ISelectable {
        public Rectangle bounds;
        public int index;
        public BarGeom parent;
        public IMember member;
        public Stripe stripe;
        public List kindList = new ArrayList();

        public StripeGeom(int index) {
            this.index = index;
        }

        public Rectangle getBounds() {
            return this.bounds;
        }

        public int getIndex() {
            return this.index;
        }

        public IMember getMember() {
            return this.member;
        }

        public boolean overlaps(StripeGeom sg) {
            return this.bounds.intersects(sg.bounds);
        }

        public void moveVertically(int ypos) {
            this.bounds.y += ypos;
            for (KindGeom kg : this.kindList) {
                kg.bounds.y += ypos;
            }
        }

        public void reduceHeight(int h) {
            this.bounds.height -= h;
            for (KindGeom kg : this.kindList) {
                kg.bounds.height -= h;
            }
        }
    }

    class ToolTipTimerTask
    extends TimerTask {
        MouseEvent event;

        ToolTipTimerTask(MouseEvent e) {
            this.event = e;
        }

        public void run() {
            VisualiserCanvas.this.postToolTipTask = null;
            VisualiserCanvas.this.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    Object o = VisualiserCanvas.this.locationToObject(ToolTipTimerTask.this.event.x, ToolTipTimerTask.this.event.y);
                    if (o != null && o instanceof ISelectable) {
                        String label = o instanceof StripeGeom ? ((StripeGeom)o).stripe.getToolTip() : ((ISelectable)o).getMember().getToolTip();
                        Point dp = VisualiserCanvas.this.toDisplay(ToolTipTimerTask.this.event.x, ToolTipTimerTask.this.event.y);
                        VisualiserCanvas.this.showToolTip(label, dp);
                    }
                }
            });
        }
    }
}

