/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.core.ras.CoreFFDC;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AopXmlPreferences {
    public static final String AOP_XML_FILES_FOR_PROJECT = "org.eclipse.ajdt.aopxml";
    private final IEclipsePreferences projectNode;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_3;

    public AopXmlPreferences(IProject project) {
        ProjectScope projectScope = new ProjectScope(project);
        this.projectNode = projectScope.getNode("org.eclipse.ajdt.ui");
    }

    public void setAopXmlFiles(IPath[] paths) {
        if (paths != null && paths.length > 0) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < paths.length) {
                String pathName = paths[i].toPortableString();
                if (pathName.endsWith(".xml")) {
                    if (sb.length() > 0) {
                        sb.append(File.pathSeparatorChar);
                    }
                    sb.append(pathName);
                }
                ++i;
            }
            this.projectNode.put(AOP_XML_FILES_FOR_PROJECT, sb.toString());
        } else {
            this.projectNode.remove(AOP_XML_FILES_FOR_PROJECT);
        }
        try {
            this.projectNode.flush();
        }
        catch (BackingStoreException backingStoreException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(backingStoreException, this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
        }
    }

    public IPath[] getAopXmlFiles() {
        String pathStr = this.projectNode.get(AOP_XML_FILES_FOR_PROJECT, null);
        if (pathStr == null || pathStr.length() == 0) {
            return new IPath[0];
        }
        String[] pathArr = pathStr.split(File.pathSeparator);
        IPath[] paths = new IPath[pathArr.length];
        int i = 0;
        while (i < pathArr.length) {
            paths[i] = new Path(pathArr[i]);
            ++i;
        }
        return paths;
    }

    public String getAopXmlFilesAsStrings() {
        IPath[] paths = this.getAopXmlFiles();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < paths.length) {
            IFile file = root.getFile(paths[i]);
            sb.append(file.getLocation().toOSString());
            if (i < paths.length - 1) {
                sb.append(File.pathSeparatorChar);
            }
            ++i;
        }
        return sb.toString();
    }

    public List<String> getAopXmlFilesAsListOfStrings() {
        IPath[] paths = this.getAopXmlFiles();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        ArrayList<String> strings = new ArrayList<String>(paths.length);
        int i = 0;
        while (i < paths.length) {
            try {
                IFile file = root.getFile(paths[i]);
                if (file != null && file.getLocation() != null) {
                    strings.add(file.getLocation().toOSString());
                }
            }
            catch (Exception exception) {
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(exception, this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_3);
            }
            ++i;
        }
        return strings;
    }

    public boolean isAopXml(IFile file) {
        if (!file.getFileExtension().equals("xml")) {
            return false;
        }
        IPath path = file.getFullPath();
        IPath[] paths = this.getAopXmlFiles();
        int i = 0;
        while (i < paths.length) {
            if (paths[i].equals((Object)path)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static {
        Factory factory = new Factory("AopXmlPreferences.java", Class.forName("org.eclipse.ajdt.core.AopXmlPreferences"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.AopXmlPreferences", "org.osgi.service.prefs.BackingStoreException:", "<missing>:"), 64);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "setAopXmlFiles", "org.eclipse.ajdt.core.AopXmlPreferences", "[Lorg.eclipse.core.runtime.IPath;:", "paths:", "", "void"), 46);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.AopXmlPreferences", "java.lang.Exception:", "<missing>:"), 104);
        ajc$tjp_3 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "getAopXmlFilesAsListOfStrings", "org.eclipse.ajdt.core.AopXmlPreferences", "", "", "", "java.util.List"), 94);
    }
}

