/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core.javaelements;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.aspectj.asm.IProgramElement;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.javaelements.AspectElement;
import org.eclipse.ajdt.core.javaelements.AspectJMemberElement;
import org.eclipse.ajdt.core.javaelements.BinaryAspectElement;
import org.eclipse.ajdt.core.javaelements.DeclareElement;
import org.eclipse.ajdt.core.javaelements.DeclareElementInfo;
import org.eclipse.ajdt.core.javaelements.IntertypeElement;
import org.eclipse.ajdt.core.model.AJProjectModelFacade;
import org.eclipse.ajdt.core.model.AJProjectModelFactory;
import org.eclipse.ajdt.core.model.AJRelationshipManager;
import org.eclipse.ajdt.internal.core.ras.CoreFFDC;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.eclipse.jdt.internal.core.CompilationUnitElementInfo;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.SourceMethod;
import org.eclipse.jdt.internal.core.SourceMethodInfo;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.core.SourceTypeElementInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ITDAwareSourceTypeInfo
extends SourceTypeElementInfo {
    boolean shouldRemoveInterfaceFlag = false;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_7;

    public ITDAwareSourceTypeInfo(SourceType type) throws JavaModelException {
        this((ISourceType)type.getElementInfo(), type);
    }

    public ITDAwareSourceTypeInfo(ISourceType toCopy, SourceType type) {
        IJavaElement[] children;
        this.handle = this.createITDAwareType(type, this);
        this.setFlags(toCopy.getModifiers());
        this.setSuperclassName(toCopy.getSuperclassName());
        this.setSuperInterfaceNames(toCopy.getInterfaceNames());
        this.setNameSourceEnd(toCopy.getNameSourceEnd());
        this.setNameSourceStart(toCopy.getNameSourceStart());
        this.setSourceRangeEnd(toCopy.getDeclarationSourceEnd());
        this.setSourceRangeStart(toCopy.getDeclarationSourceStart());
        try {
            ITypeParameter[] parameters = type.getTypeParameters();
            if (parameters != null) {
                this.typeParameters = new ITypeParameter[parameters.length];
                System.arraycopy(parameters, 0, this.typeParameters, 0, parameters.length);
            }
        }
        catch (JavaModelException javaModelException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
        }
        if ((children = this.augmentChildrenAndHierarchy(type)) != null) {
            this.setChildren(children);
        }
        try {
            Object info = ((JavaElement)this.handle.getCompilationUnit()).getElementInfo();
            if (info != null && info instanceof CompilationUnitElementInfo) {
                ((CompilationUnitElementInfo)info).annotationNumber = 0;
            }
        }
        catch (JavaModelException javaModelException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_1);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IJavaElement[] augmentChildrenAndHierarchy(SourceType type) {
        Exception exception2;
        block13: {
            IJavaElement[] origChildren;
            block12: {
                try {
                    List<IJavaElement> augmentedChildren;
                    origChildren = type.getChildren();
                    IJavaElement[] newChildren = new IJavaElement[origChildren.length];
                    boolean hasChanges = false;
                    int i = 0;
                    while (true) {
                        SourceType innerType;
                        if (i >= origChildren.length) {
                            augmentedChildren = this.getITDs(type);
                            if (type instanceof AspectElement) {
                                augmentedChildren.add((IJavaElement)this.createAspectOf((AspectElement)this.handle));
                            }
                            if (augmentedChildren.size() > 0 || hasChanges) {
                                break;
                            }
                            break block12;
                        }
                        if (origChildren[i].getElementType() == 7 && !((innerType = (SourceType)origChildren[i]) instanceof ITDAwareSourceType)) {
                            ITDAwareSourceTypeInfo innerInfo = new ITDAwareSourceTypeInfo(innerType);
                            newChildren[i] = this.createITDAwareType(innerType, innerInfo);
                            hasChanges = true;
                        } else {
                            newChildren[i] = origChildren[i];
                        }
                        ++i;
                    }
                    IJavaElement[] allChildren = new IJavaElement[origChildren.length + augmentedChildren.size()];
                    System.arraycopy(newChildren, 0, allChildren, 0, newChildren.length);
                    int i2 = origChildren.length;
                    Iterator<IJavaElement> iterator = augmentedChildren.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            return allChildren;
                        }
                        IJavaElement elt = iterator.next();
                        allChildren[i2++] = elt;
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                    break block13;
                }
            }
            try {
                return origChildren;
            }
            catch (Exception exception3) {
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(exception3, (Object)this, ajc$tjp_3, (JoinPoint.StaticPart)ajc$tjp_4);
                Exception exception4 = exception3;
            }
        }
        CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(exception2, (Object)this, ajc$tjp_5, (JoinPoint.StaticPart)ajc$tjp_4);
        return null;
    }

    private List<IJavaElement> getITDs(SourceType type) throws JavaModelException {
        AJProjectModelFacade model = AJProjectModelFactory.getInstance().getModelForJavaElement((IJavaElement)type);
        if (model.hasModel()) {
            ArrayList<IJavaElement> itds = new ArrayList<IJavaElement>();
            List<IJavaElement> rels = model.getRelationshipsForElement((IJavaElement)type, AJRelationshipManager.ASPECT_DECLARATIONS);
            List childMethods = null;
            block0: for (IJavaElement ije : rels) {
                IProgramElement ipe;
                Map declareParentsMap;
                AspectJMemberElement elt;
                if (ije instanceof IntertypeElement) {
                    elt = (IntertypeElement)ije;
                    IMember member = ((IntertypeElement)elt).createMockDeclaration((IType)type);
                    if (member == null || !this.isAlreadyAnITD(itds, member)) continue;
                    itds.add((IJavaElement)member);
                    if (!this.handle.isInterface()) continue;
                    this.shouldRemoveInterfaceFlag = true;
                    if (member.getElementType() == 8) {
                        itds.remove(member);
                        continue;
                    }
                    if (member.getElementType() != 9) continue;
                    if (childMethods == null) {
                        childMethods = type.getChildrenOfType(9);
                    }
                    for (IMethod method : childMethods) {
                        if (!method.isSimilar((IMethod)member)) continue;
                        itds.remove(member);
                        continue block0;
                    }
                    continue;
                }
                if (ije instanceof DeclareElement) {
                    elt = (DeclareElement)ije;
                    DeclareElementInfo info = (DeclareElementInfo)((DeclareElement)elt).createElementInfo();
                    if (info == null || info.getAJKind() != IProgramElement.Kind.DECLARE_PARENTS) continue;
                    char[][] newSupers = info.getTypes();
                    this.augmentHierarchy(newSupers);
                    continue;
                }
                if (!(ije instanceof AspectElement) && !(ije instanceof BinaryAspectElement) || (declareParentsMap = (ipe = model.javaElementToProgramElement(ije)).getDeclareParentsMap()) == null) continue;
                this.augmentHierarchy((List)declareParentsMap.get(type.getFullyQualifiedName()));
            }
            return itds;
        }
        return new LinkedList<IJavaElement>();
    }

    private void augmentHierarchy(List<String> newSupers) {
        if (newSupers != null) {
            char[][] newSupersArr = new char[newSupers.size()][];
            int i = 0;
            for (String newSuper : newSupers) {
                newSupersArr[i++] = newSuper.toCharArray();
            }
            this.augmentHierarchy(newSupersArr);
        }
    }

    private void augmentHierarchy(char[][] newSupers) {
        if (newSupers != null) {
            char[][] cArray = newSupers;
            int n = newSupers.length;
            int n2 = 0;
            while (n2 < n) {
                char[] newSuper = cArray[n2];
                if (this.isClass(newSuper)) {
                    this.setSuperclassName(newSuper);
                } else {
                    char[][] newInterfaces;
                    char[][] origInterfaces = this.getInterfaceNames();
                    if (origInterfaces == null) {
                        newInterfaces = new char[][]{newSuper};
                    } else {
                        newInterfaces = new char[origInterfaces.length + 1][];
                        System.arraycopy(origInterfaces, 0, newInterfaces, 0, origInterfaces.length);
                        newInterfaces[origInterfaces.length] = newSuper;
                    }
                    this.setSuperInterfaceNames(newInterfaces);
                }
                ++n2;
            }
        }
    }

    private boolean isAlreadyAnITD(List<IJavaElement> itds, IMember member) {
        boolean shouldAdd;
        block2: {
            block3: {
                shouldAdd = true;
                if (member.getElementType() != 8) break block3;
                for (IJavaElement itdElt : itds) {
                    if (!(itdElt instanceof IField)) continue;
                    IField itdField = (IField)itdElt;
                    if (!member.getElementName().equals(itdField.getElementName())) continue;
                    shouldAdd = false;
                    break block2;
                }
                break block2;
            }
            if (member.getElementType() != 9) break block2;
            for (IJavaElement itdElt : itds) {
                IMethod itdMethod;
                if (!(itdElt instanceof IMethod) || !(itdMethod = (IMethod)itdElt).isSimilar((IMethod)member)) continue;
                shouldAdd = false;
                break;
            }
        }
        return shouldAdd;
    }

    private SourceMethod createAspectOf(AspectElement parent) {
        return new SourceMethod((JavaElement)parent, "aspectOf", new String[0]){

            protected Object createElementInfo() {
                return new SourceMethodInfo(){

                    public int getModifiers() {
                        return 9;
                    }

                    public char[] getReturnTypeName() {
                        return ((JavaElement)this).parent.getElementName().toCharArray();
                    }
                };
            }

            public boolean exists() {
                return true;
            }
        };
    }

    private boolean isClass(char[] qualifiedName) {
        try {
            IType type = this.handle.getJavaProject().findType(String.valueOf(qualifiedName), null);
            return type != null && type.isClass();
        }
        catch (JavaModelException javaModelException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_6, (JoinPoint.StaticPart)ajc$tjp_7);
            return false;
        }
    }

    private SourceType createITDAwareType(SourceType type, ITDAwareSourceTypeInfo info) {
        if (type instanceof AspectElement) {
            return new ITDAwareAspectType((JavaElement)type.getParent(), type.getElementName(), info);
        }
        return new ITDAwareSourceType((JavaElement)type.getParent(), type.getElementName(), info);
    }

    public IJavaElement[] getChildren() {
        return super.getChildren();
    }

    public void setChildren(IJavaElement[] children) {
        this.children = children;
    }

    static {
        Factory factory = new Factory("ITDAwareSourceTypeInfo.java", Class.forName("org.eclipse.ajdt.core.javaelements.ITDAwareSourceTypeInfo"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.javaelements.ITDAwareSourceTypeInfo", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 97);
        ajc$tjp_1 = factory.makeESJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "org.eclipse.ajdt.core.javaelements.ITDAwareSourceTypeInfo", "org.eclipse.jdt.internal.compiler.env.ISourceType:org.eclipse.jdt.internal.core.SourceType:", "toCopy:type:", ""), 81);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.javaelements.ITDAwareSourceTypeInfo", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 112);
        ajc$tjp_3 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.javaelements.ITDAwareSourceTypeInfo", "java.lang.Exception:", "<missing>:"), 153);
        ajc$tjp_4 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "augmentChildrenAndHierarchy", "org.eclipse.ajdt.core.javaelements.ITDAwareSourceTypeInfo", "org.eclipse.jdt.internal.core.SourceType:", "type:", "", "[Lorg.eclipse.jdt.core.IJavaElement;"), 116);
        ajc$tjp_5 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.javaelements.ITDAwareSourceTypeInfo", "java.lang.Exception:", "<missing>:"), 153);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.javaelements.ITDAwareSourceTypeInfo", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 338);
        ajc$tjp_7 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "isClass", "org.eclipse.ajdt.core.javaelements.ITDAwareSourceTypeInfo", "[C:", "qualifiedName:", "", "boolean"), 334);
    }

    private static final class ITDAwareAspectType
    extends AspectElement {
        final ITDAwareSourceTypeInfo info;

        private ITDAwareAspectType(JavaElement parent, String name, ITDAwareSourceTypeInfo info) {
            super(parent, name);
            this.info = info;
        }

        public Object getElementInfo() throws JavaModelException {
            return this.info;
        }
    }

    private static final class ITDAwareSourceType
    extends SourceType {
        final ITDAwareSourceTypeInfo info;

        private ITDAwareSourceType(JavaElement parent, String name, ITDAwareSourceTypeInfo info) {
            super(parent, name);
            this.info = info;
        }

        public Object getElementInfo() throws JavaModelException {
            return this.info;
        }
    }
}

