/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.lookup;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.aspectj.ajdt.internal.compiler.ast.AspectDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.AstUtil;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseSourceLocation;
import org.aspectj.ajdt.internal.compiler.lookup.PrivilegedFieldBinding;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.IPrivilegedHandler;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ParameterizedFieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.weaver.AjcMemberMaker;
import org.aspectj.weaver.Lint;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedMemberImpl;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.World;

public class PrivilegedHandler
implements IPrivilegedHandler {
    private AspectDeclaration inAspect;
    private Map accessors = new HashMap();

    public PrivilegedHandler(AspectDeclaration inAspect) {
        this.inAspect = inAspect;
    }

    public boolean definesPrivilegedAccessToField(FieldBinding field) {
        if (field instanceof ParameterizedFieldBinding) {
            field = ((ParameterizedFieldBinding)field).originalField;
        }
        ResolvedMember key = this.inAspect.factory.makeResolvedMember(field);
        return this.accessors.containsKey(key);
    }

    public FieldBinding getPrivilegedAccessField(FieldBinding baseField, ASTNode location) {
        ResolvedMember key;
        if (baseField instanceof ParameterizedFieldBinding) {
            baseField = ((ParameterizedFieldBinding)baseField).originalField;
        }
        if (this.accessors.containsKey(key = this.inAspect.factory.makeResolvedMember(baseField))) {
            return (FieldBinding)this.accessors.get(key);
        }
        PrivilegedFieldBinding ret = new PrivilegedFieldBinding(this.inAspect, baseField);
        this.checkWeaveAccess(key.getDeclaringType(), location);
        if (!baseField.alwaysNeedsAccessMethod(true)) {
            this.accessors.put(key, ret);
        }
        return ret;
    }

    public MethodBinding getPrivilegedAccessMethod(MethodBinding baseMethod, ASTNode location) {
        MethodBinding ret;
        if (baseMethod.alwaysNeedsAccessMethod()) {
            return baseMethod;
        }
        ResolvedMemberImpl key = null;
        key = baseMethod instanceof ParameterizedMethodBinding ? this.inAspect.factory.makeResolvedMember(((ParameterizedMethodBinding)baseMethod).original()) : this.inAspect.factory.makeResolvedMember(baseMethod);
        if (this.accessors.containsKey(key)) {
            return (MethodBinding)this.accessors.get(key);
        }
        if (baseMethod.isConstructor()) {
            ret = new MethodBinding(baseMethod, baseMethod.declaringClass);
            baseMethod.modifiers = ret.modifiers = AstUtil.makePublic(ret.modifiers);
        } else {
            ret = this.inAspect.factory.makeMethodBinding(AjcMemberMaker.privilegedAccessMethodForMethod((UnresolvedType)this.inAspect.typeX, (ResolvedMember)key));
        }
        this.checkWeaveAccess(key.getDeclaringType(), location);
        this.accessors.put(key, ret);
        return ret;
    }

    public void notePrivilegedTypeAccess(ReferenceBinding type, ASTNode location) {
        ResolvedMemberImpl key = new ResolvedMemberImpl(Member.STATIC_INITIALIZATION, (UnresolvedType)this.inAspect.factory.fromEclipse(type), 0, (UnresolvedType)ResolvedType.VOID, "", UnresolvedType.NONE);
        this.checkWeaveAccess(key.getDeclaringType(), location);
        this.accessors.put(key, key);
    }

    private void checkWeaveAccess(UnresolvedType typeX, ASTNode location) {
        World world = this.inAspect.factory.getWorld();
        Lint.Kind check = world.getLint().typeNotExposedToWeaver;
        if (check.isEnabled() && !world.resolve(typeX).isExposedToWeaver()) {
            EclipseSourceLocation loc = null;
            if (location != null) {
                loc = new EclipseSourceLocation(this.inAspect.compilationResult, location.sourceStart, location.sourceEnd);
            }
            check.signal(typeX.getName() + " (needed for privileged access)", (ISourceLocation)loc);
        }
    }

    public ResolvedMember[] getMembers() {
        Set m = this.accessors.keySet();
        int len = m.size();
        ResolvedMember[] ret = new ResolvedMember[len];
        int index = 0;
        Iterator i = m.iterator();
        while (i.hasNext()) {
            ret[index++] = (ResolvedMember)i.next();
        }
        return ret;
    }
}

