/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.aspectj;

import java.util.Dictionary;
import java.util.Properties;
import org.eclipse.equinox.service.weaving.IWeavingServiceFactory;
import org.eclipse.equinox.weaving.aspectj.AspectJWeavingServiceFactory;
import org.eclipse.equinox.weaving.aspectj.loadtime.AspectAdminImpl;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;

public class AspectJWeavingActivator
implements BundleActivator {
    public static boolean DEBUG;
    public static boolean verbose;
    private static AspectJWeavingActivator plugin;
    private AspectAdminImpl aspectDefinitionRegistry;
    private BundleContext context;

    static {
        verbose = Boolean.getBoolean("org.aspectj.osgi.verbose");
    }

    public AspectJWeavingActivator() {
        plugin = this;
    }

    public static AspectJWeavingActivator getDefault() {
        return plugin;
    }

    public BundleContext getContext() {
        return this.context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        this.context = bundleContext;
        this.aspectDefinitionRegistry = new AspectAdminImpl();
        bundleContext.addBundleListener((BundleListener)this.aspectDefinitionRegistry);
        this.aspectDefinitionRegistry.initialize(bundleContext.getBundles());
        this.loadOptions(bundleContext);
        if (verbose) {
            System.err.println("[org.eclipse.equinox.weaving.aspectj] info Starting AspectJ weaving service ...");
        }
        String string = IWeavingServiceFactory.class.getName();
        AspectJWeavingServiceFactory aspectJWeavingServiceFactory = new AspectJWeavingServiceFactory(this.aspectDefinitionRegistry);
        Properties properties = new Properties();
        bundleContext.registerService(string, (Object)aspectJWeavingServiceFactory, (Dictionary)properties);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.context = null;
        plugin = null;
    }

    private void loadOptions(BundleContext bundleContext) {
        DebugOptions debugOptions = null;
        ServiceReference serviceReference = bundleContext.getServiceReference(DebugOptions.class.getName());
        if (serviceReference != null) {
            debugOptions = (DebugOptions)bundleContext.getService(serviceReference);
        }
        if (debugOptions == null) {
            return;
        }
        try {
            DEBUG = debugOptions.getBooleanOption("org.aspectj.osgi.service.weaving/debug", false);
        }
        finally {
            bundleContext.ungetService(serviceReference);
        }
    }
}

